/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.outline;

import com.google.inject.Inject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.xtext.ui.PluginImageHelper;
import org.eclipse.xtext.ui.editor.outline.actions.AbstractToggleOutlineContribution;
import org.eclipse.xtext.ui.editor.outline.impl.OutlinePage;
import org.eclipse.xtext.ui.editor.outline.quickoutline.IQuickOutlineContribution;
import org.eclipse.xtext.ui.editor.outline.quickoutline.QuickOutlinePopup;

public class SwitchOutlineModeContribution
extends AbstractToggleOutlineContribution
implements IQuickOutlineContribution {
    public static final String PREFERENCE_KEY = "ui.outline.switchMode";
    @Inject
    private PluginImageHelper imageHelper;
    private OutlinePage outlinePage;
    private QuickOutlinePopup quickOutline;

    protected void configureAction(Action action) {
        action.setText("Jvm View");
        action.setToolTipText("Jvm Model View");
        action.setDescription("Switch between Source and Jvm model perspectives.");
        action.setImageDescriptor(this.imageHelper.getImageDescriptor("jvm_mode.gif"));
        action.setDisabledImageDescriptor(this.imageHelper.getImageDescriptor("jvm_mode.gif"));
    }

    public String getPreferenceKey() {
        return PREFERENCE_KEY;
    }

    protected void stateChanged(boolean newState) {
        TreeViewer treeViewer;
        if (this.outlinePage != null && (treeViewer = this.outlinePage.getTreeViewer()) != null && !this.outlinePage.getTreeViewer().getTree().isDisposed()) {
            this.outlinePage.scheduleRefresh();
        }
        if (this.quickOutline != null) {
            this.quickOutline.scheduleRefresh();
        }
    }

    public void register(OutlinePage outlinePage) {
        super.register(outlinePage);
        this.outlinePage = outlinePage;
    }

    public void deregister(OutlinePage outlinePage) {
        super.deregister(outlinePage);
        this.outlinePage = null;
    }

    public void register(QuickOutlinePopup quickOutline, IMenuManager dialogMenu) {
        this.quickOutline = quickOutline;
        dialogMenu.add((IAction)this.getAction());
    }

    public void deregister(QuickOutlinePopup quickOutline) {
        this.quickOutline = null;
    }
}

