/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.codetemplates.ui.preferences;

import com.google.inject.Inject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.text.templates.TemplatePersistenceData;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.ui.codetemplates.ui.preferences.EditTemplateDialogFactory;
import org.eclipse.xtext.ui.codetemplates.ui.preferences.IEditTemplateDialog;
import org.eclipse.xtext.ui.codetemplates.ui.preferences.TemplateResourceProvider;
import org.eclipse.xtext.ui.codetemplates.ui.preferences.TemplatesLanguageConfiguration;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorModelAccess;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;
import org.eclipse.xtext.ui.editor.templates.XtextTemplatePreferencePage;

public class AdvancedTemplatesPreferencePage
extends XtextTemplatePreferencePage {
    @Inject
    private EditTemplateDialogFactory factory;
    @Inject
    private TemplatesLanguageConfiguration configuration;
    @Inject
    private IGrammarAccess grammarAccess;
    @Inject
    private TemplateResourceProvider resourceProvider;
    private EmbeddedEditorModelAccess partialEditor;

    @Inject
    public AdvancedTemplatesPreferencePage(IPreferenceStore preferenceStore, ContextTypeRegistry registry, TemplateStore templateStore) {
        super(preferenceStore, registry, templateStore);
    }

    protected Template editTemplate(Template template, boolean edit, boolean isNameModifiable) {
        IEditTemplateDialog dialog = this.factory.createDialog(template, edit, isNameModifiable, this.getShell());
        if (dialog.open() == 0) {
            return dialog.getTemplate();
        }
        return null;
    }

    protected void updateViewerInput() {
        IStructuredSelection selection = (IStructuredSelection)this.getTableViewer().getSelection();
        if (selection.size() == 1) {
            TemplatePersistenceData data = (TemplatePersistenceData)selection.getFirstElement();
            Template template = data.getTemplate();
            String name = template.getName();
            TemplateContextType contextType = this.getContextTypeRegistry().getContextType(template.getContextTypeId());
            if (contextType != null) {
                String prefix = "templates for " + this.grammarAccess.getGrammar().getName() + "'" + name + "' for " + this.getContextTypeForGrammar(contextType) + ">>";
                String editablePart = template.getPattern();
                String suffix = "";
                this.partialEditor.updateModel(prefix, editablePart, suffix);
            } else {
                this.partialEditor.updateModel("", template.getPattern(), "");
            }
        } else {
            this.partialEditor.updateModel("", "", "");
        }
    }

    protected String getContextTypeForGrammar(TemplateContextType contextType) {
        String result = contextType.getName();
        if (result.startsWith("Keyword ")) {
            result = result.substring("Keyword ".length());
        }
        return result;
    }

    protected SourceViewer createViewer(Composite parent) {
        EmbeddedEditor handle = this.configuration.getEmbeddedEditorFactory().newEditor((IEditedResourceProvider)this.resourceProvider).readOnly().withParent(parent);
        this.partialEditor = handle.createPartialEditor(true);
        return handle.getViewer();
    }
}

