/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.web;

import org.eclipse.xtext.util.Strings;

public class RegexpExtensions {
    public static String toRegexpString(String string, boolean ignoreCase) {
        int length = string.length();
        StringBuilder out = new StringBuilder(2 * length);
        int x = 0;
        while (x < length) {
            char c = string.charAt(x);
            switch (c) {
                case '\t': {
                    out.append("\\\\t");
                    break;
                }
                case '\n': {
                    out.append("\\\\n");
                    break;
                }
                case '\r': {
                    out.append("\\\\r");
                    break;
                }
                case '\f': {
                    out.append("\\\\f");
                    break;
                }
                case '\b': {
                    out.append("[\\\\b]");
                    break;
                }
                case '\"': 
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    out.append("\\\\");
                    out.append(c);
                    break;
                }
                default: {
                    if (ignoreCase && Character.isLetter(c)) {
                        out.append('[');
                        out.append(Character.toLowerCase(c));
                        out.append(Character.toUpperCase(c));
                        out.append(']');
                        break;
                    }
                    if (c < ' ' || c > '~') {
                        out.append("\\\\u");
                        out.append(Strings.toHex((int)(c >> 12 & 0xF)));
                        out.append(Strings.toHex((int)(c >> 8 & 0xF)));
                        out.append(Strings.toHex((int)(c >> 4 & 0xF)));
                        out.append(Strings.toHex((int)(c & 0xF)));
                        break;
                    }
                    out.append(c);
                }
            }
            ++x;
        }
        return out.toString();
    }
}

