/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.hierarchy;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.ide.editor.hierarchy.DefaultCallHierarchyBuilder;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyNode;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyNodeLocationProvider;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.ui.editor.hierarchy.XtextCallHierarchyNode;
import org.eclipse.xtext.ui.editor.hierarchy.XtextCallHierarchyNodeLocationProvider;

public class XtextCallHierarchyBuilder
extends DefaultCallHierarchyBuilder {
    @Inject
    private XtextCallHierarchyNodeLocationProvider callHierarchyNodeLocationProvider;

    protected IHierarchyNodeLocationProvider getHierarchyNodeLocationProvider() {
        return this.callHierarchyNodeLocationProvider;
    }

    protected IEObjectDescription findDeclaration(URI objectURI) {
        IEObjectDescription description = this.getDescription(objectURI);
        if (description != null && description.getEClass() != null && this.isRule((EClassifier)description.getEClass())) {
            return description;
        }
        return (IEObjectDescription)this.readOnly(objectURI, object -> this.getDescription(EcoreUtil2.getContainerOfType((EObject)object, AbstractRule.class)));
    }

    protected boolean filterReference(IReferenceDescription reference) {
        return reference != null && this.isRule(reference.getEReference().getEType());
    }

    protected IEObjectDescription findSourceDeclaration(IReferenceDescription reference) {
        return this.getDescription(reference.getContainerEObjectURI());
    }

    protected boolean isRule(EClassifier type) {
        return this.isAssignable(XtextPackage.Literals.ABSTRACT_RULE, type);
    }

    protected IHierarchyNode createRoot(IEObjectDescription declaration) {
        XtextCallHierarchyNode node = new XtextCallHierarchyNode();
        node.setElement(declaration);
        node.setGrammarDescription(this.getGrammarDescription(declaration));
        node.setMayHaveChildren(true);
        return node;
    }

    protected IHierarchyNode createChild(IEObjectDescription declaration, IHierarchyNode parent) {
        XtextCallHierarchyNode node = new XtextCallHierarchyNode();
        node.setParent(parent);
        node.setElement(declaration);
        node.setGrammarDescription(this.getGrammarDescription(declaration));
        node.setMayHaveChildren(this.isRule((EClassifier)declaration.getEClass()) && !node.isRecursive());
        return node;
    }

    protected IEObjectDescription getGrammarDescription(IEObjectDescription description) {
        URI resourceURI = description.getEObjectURI().trimFragment();
        Iterable exportedObjectsByType = this.getIndexData().getResourceDescription(resourceURI).getExportedObjectsByType(XtextPackage.Literals.GRAMMAR);
        return (IEObjectDescription)Iterables.getFirst((Iterable)exportedObjectsByType, null);
    }
}

