/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.xtext.builder.EclipseSourceFolderProvider;
import org.eclipse.xtext.generator.IOutputConfigurationProvider;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;
import org.eclipse.xtext.ui.resource.ProjectByResourceProvider;

public class EclipseOutputConfigurationProvider
extends IOutputConfigurationProvider.Delegate {
    public static final String OUTPUT_PREFERENCE_TAG = "outlet";
    public static final String OUTPUT_NAME = "name";
    public static final String OUTPUT_DESCRIPTION = "description";
    public static final String OUTPUT_DIRECTORY = "directory";
    public static final String OUTPUT_CREATE_DIRECTORY = "createDirectory";
    public static final String OUTPUT_CLEAN_DIRECTORY = "cleanDirectory";
    public static final String OUTPUT_OVERRIDE = "override";
    public static final String OUTPUT_CLEANUP_DERIVED = "cleanupDerived";
    public static final String OUTPUT_DERIVED = "derived";
    public static final String OUTPUT_KEEP_LOCAL_HISTORY = "keepLocalHistory";
    public static final String INSTALL_DSL_AS_PRIMARY_SOURCE = "installDslAsPrimarySource";
    public static final String HIDE_LOCAL_SYNTHETIC_VARIABLES = "hideLocalSyntheticVariables";
    public static final String USE_OUTPUT_PER_SOURCE_FOLDER = "userOutputPerSourceFolder";
    public static final String SOURCE_FOLDER_TAG = "sourceFolder";
    public static final String IGNORE_SOURCE_FOLDER_TAG = "ignore";
    private IPreferenceStoreAccess preferenceStoreAccess;
    private EclipseSourceFolderProvider sourceFolderProvider;
    @Inject
    private ProjectByResourceProvider projectProvider;

    public IPreferenceStoreAccess getPreferenceStoreAccess() {
        return this.preferenceStoreAccess;
    }

    @Inject
    public void setPreferenceStoreAccess(IPreferenceStoreAccess preferenceStoreAccess) {
        this.preferenceStoreAccess = preferenceStoreAccess;
    }

    @Inject(optional=true)
    public void setSourceFolderProvider(EclipseSourceFolderProvider sourceFolderProvider) {
        this.sourceFolderProvider = sourceFolderProvider;
    }

    @Inject
    public EclipseOutputConfigurationProvider(IOutputConfigurationProvider delegate) {
        super(delegate);
    }

    public Set<OutputConfiguration> getOutputConfigurations(Resource resource) {
        IProject project = this.projectProvider.getProjectContext(resource);
        return this.getOutputConfigurations(project);
    }

    public Set<OutputConfiguration> getOutputConfigurations(IProject project) {
        IPreferenceStore store = this.getPreferenceStoreAccess().getContextPreferenceStore((Object)project);
        LinkedHashSet<OutputConfiguration> outputConfigurations = new LinkedHashSet<OutputConfiguration>(this.getOutputConfigurations().size());
        for (OutputConfiguration output : this.getOutputConfigurations()) {
            OutputConfiguration configuration = this.createAndOverlayOutputConfiguration(project, store, output);
            outputConfigurations.add(configuration);
        }
        return outputConfigurations;
    }

    @Deprecated
    protected OutputConfiguration createAndOverlayOutputConfiguration(IPreferenceStore store, OutputConfiguration output) {
        OutputConfiguration result = new OutputConfiguration(output.getName());
        boolean clearOutputDirectory = this.getBoolean(output, OUTPUT_CLEAN_DIRECTORY, store, output.isCanClearOutputDirectory());
        result.setCanClearOutputDirectory(clearOutputDirectory);
        boolean cleanUpDerivedResources = this.getBoolean(output, OUTPUT_CLEANUP_DERIVED, store, output.isCleanUpDerivedResources());
        result.setCleanUpDerivedResources(cleanUpDerivedResources);
        boolean createOutputDirectory = this.getBoolean(output, OUTPUT_CREATE_DIRECTORY, store, output.isCreateOutputDirectory());
        result.setCreateOutputDirectory(createOutputDirectory);
        boolean overrideExistingResources = this.getBoolean(output, OUTPUT_OVERRIDE, store, output.isOverrideExistingResources());
        result.setOverrideExistingResources(overrideExistingResources);
        boolean setDerivedProperty = this.getBoolean(output, OUTPUT_DERIVED, store, output.isSetDerivedProperty());
        result.setSetDerivedProperty(setDerivedProperty);
        boolean installDslAsPrimarySource = this.getBoolean(output, INSTALL_DSL_AS_PRIMARY_SOURCE, store, output.isInstallDslAsPrimarySource());
        result.setInstallDslAsPrimarySource(installDslAsPrimarySource);
        boolean hideSyntheticLocalVariables = this.getBoolean(output, HIDE_LOCAL_SYNTHETIC_VARIABLES, store, output.isHideSyntheticLocalVariables());
        result.setHideSyntheticLocalVariables(hideSyntheticLocalVariables);
        String description = this.getString(output, OUTPUT_DESCRIPTION, store, output.getDescription());
        result.setDescription(description);
        String directory = this.getString(output, OUTPUT_DIRECTORY, store, output.getOutputDirectory());
        result.setOutputDirectory(directory);
        boolean keepLocalHistory = this.getBoolean(output, OUTPUT_KEEP_LOCAL_HISTORY, store, output.isKeepLocalHistory());
        result.setKeepLocalHistory(Boolean.valueOf(keepLocalHistory));
        boolean useOutputPerSourceFolder = this.getBoolean(output, USE_OUTPUT_PER_SOURCE_FOLDER, store, output.isUseOutputPerSourceFolder());
        result.setUseOutputPerSourceFolder(useOutputPerSourceFolder);
        return result;
    }

    protected OutputConfiguration createAndOverlayOutputConfiguration(IProject project, IPreferenceStore store, OutputConfiguration output) {
        OutputConfiguration result = this.createAndOverlayOutputConfiguration(store, output);
        if (project != null && this.sourceFolderProvider != null) {
            for (IContainer iContainer : this.sourceFolderProvider.getSourceFolders(project)) {
                String sourceFolder = this.toProjectRelativePath(iContainer).toString();
                OutputConfiguration.SourceMapping mapping = new OutputConfiguration.SourceMapping(sourceFolder);
                mapping.setOutputDirectory(this.getOutputForSourceFolder(store, output, sourceFolder));
                mapping.setIgnore(this.isIgnoreSourceFolder(store, output, sourceFolder));
                result.getSourceMappings().add(mapping);
            }
        }
        return result;
    }

    private IPath toProjectRelativePath(IContainer source) {
        return source.getFullPath().makeRelativeTo(source.getProject().getFullPath());
    }

    private boolean getBoolean(OutputConfiguration outputConfiguration, String name, IPreferenceStore preferenceStore, Boolean defaultValue) {
        String preferenceKey = this.getKey(outputConfiguration, name);
        return preferenceStore.contains(preferenceKey) ? preferenceStore.getBoolean(preferenceKey) : defaultValue.booleanValue();
    }

    private String getString(OutputConfiguration outputConfiguration, String name, IPreferenceStore preferenceStore, String defaultValue) {
        String preferenceKey = this.getKey(outputConfiguration, name);
        return preferenceStore.contains(preferenceKey) ? preferenceStore.getString(preferenceKey) : defaultValue;
    }

    private String getKey(OutputConfiguration outputConfiguration, String preferenceName) {
        return "outlet." + outputConfiguration.getName() + "." + preferenceName;
    }

    private String getOutputForSourceFolder(IPreferenceStore store, OutputConfiguration outputConfiguration, String sourceFolder) {
        String key = this.getKey(outputConfiguration, "sourceFolder." + sourceFolder + ".directory");
        return Strings.emptyToNull((String)store.getString(key));
    }

    private boolean isIgnoreSourceFolder(IPreferenceStore store, OutputConfiguration outputConfiguration, String sourceFolder) {
        String key = this.getKey(outputConfiguration, "sourceFolder." + sourceFolder + ".ignore");
        return store.contains(key) ? store.getBoolean(key) : false;
    }
}

