/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.concurrent;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.xtext.ide.server.concurrent.AbstractRequest;
import org.eclipse.xtext.ide.server.concurrent.AbstractRequestManager;
import org.eclipse.xtext.ide.server.concurrent.ReadRequest;
import org.eclipse.xtext.ide.server.concurrent.WriteRequest;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.Functions;

@Singleton
public class RequestManager
extends AbstractRequestManager {
    private final ExecutorService parallel;
    private final ExecutorService queue = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat(this.getThreadQueueNameFormat()).build());
    private List<AbstractRequest<?>> requests = new ArrayList();

    @Inject
    public RequestManager(ExecutorService parallel, OperationCanceledManager operationCanceledManager) {
        super(operationCanceledManager);
        this.parallel = parallel;
    }

    protected String getThreadQueueNameFormat() {
        return "RequestManager-Queue-%d";
    }

    @Override
    public void shutdown() {
        this.queue.shutdown();
        this.parallel.shutdown();
        this.cancel();
    }

    protected final ExecutorService getParallelExecutorService() {
        return this.parallel;
    }

    @Override
    public synchronized <V> CompletableFuture<V> runRead(Functions.Function1<? super CancelIndicator, ? extends V> cancellable) {
        return this.submit(new ReadRequest<V>(this, cancellable, this.parallel));
    }

    @Override
    public synchronized <U, V> CompletableFuture<V> runWrite(Functions.Function0<? extends U> nonCancellable, Functions.Function2<? super CancelIndicator, ? super U, ? extends V> cancellable) {
        return this.submit(new WriteRequest<U, V>(this, nonCancellable, cancellable, this.cancel()));
    }

    protected <V> CompletableFuture<V> submit(AbstractRequest<V> request) {
        this.addRequest(request);
        this.submitRequest(request);
        return request.get();
    }

    protected void submitRequest(AbstractRequest<?> request) {
        this.queue.submit(request);
    }

    protected void addRequest(AbstractRequest<?> request) {
        this.requests.add(request);
    }

    protected CompletableFuture<Void> cancel() {
        List<AbstractRequest<?>> localRequests = this.requests;
        this.requests = new ArrayList();
        CompletableFuture[] cfs = new CompletableFuture[localRequests.size()];
        int i = 0;
        int max = localRequests.size();
        while (i < max) {
            AbstractRequest<?> request = localRequests.get(i);
            request.cancel();
            cfs[i] = request.get();
            ++i;
        }
        return CompletableFuture.allOf(cfs);
    }
}

