/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.testing;

import com.google.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.utils.TextStyle;
import org.eclipse.xtext.ui.testing.AbstractEditorTest;

public abstract class AbstractHighlightingTest
extends AbstractEditorTest {
    @Inject
    private FileExtensionProvider fileExtensionProvider;

    public void testHighlighting(CharSequence content, String text, TextStyle style) {
        this.testHighlighting(content, text, style.getStyle(), style.getColor() == null ? 0 : style.getColor().red, style.getColor() == null ? 0 : style.getColor().green, style.getColor() == null ? 0 : style.getColor().blue, style.getBackgroundColor() == null ? 255 : style.getBackgroundColor().red, style.getBackgroundColor() == null ? 255 : style.getBackgroundColor().green, style.getBackgroundColor() == null ? 255 : style.getBackgroundColor().blue);
    }

    public void testHighlighting(CharSequence content, String text, int fontStyle, int foregroundR, int foregroundG, int foregroundB) {
        this.testHighlighting(content, text, fontStyle, foregroundR, foregroundG, foregroundB, 255, 255, 255);
    }

    public void testHighlighting(CharSequence content, String text, int fontStyle, int foregroundR, int foregroundG, int foregroundB, int backgroundR, int backgroundG, int backgroundB) {
        this.testHighlighting(this.openInEditor(this.dslFile(this.getProjectName(), this.getFileName(), this.getFileExtension(), content)), text, fontStyle, foregroundR, foregroundG, foregroundB, backgroundR, backgroundG, backgroundB);
    }

    protected String getProjectName() {
        return "HighlightingTestProject";
    }

    protected String getFileName() {
        return "highlighting";
    }

    protected String getFileExtension() {
        return this.fileExtensionProvider.getPrimaryFileExtension();
    }

    protected StyledText openInEditor(IFile dslFile) {
        try {
            XtextEditor editor = this.openEditor(dslFile);
            this.waitForEventProcessing();
            return editor.getInternalSourceViewer().getTextWidget();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void testHighlighting(StyledText styledText, String text, int fontStyle, int foregroundR, int foregroundG, int foregroundB, int backgroundR, int backgroundG, int backgroundB) {
        Color expectedForegroundColor = new Color(null, foregroundR, foregroundG, foregroundB);
        Color expectedBackgroundColor = new Color(null, backgroundR, backgroundG, backgroundB);
        String content = styledText.getText();
        int offset = this.getStartPosition(content, text);
        AbstractHighlightingTest.assertNotEquals((String)("Cannot locate '" + text + "' in " + content), (long)-1L, (long)offset);
        int i = 0;
        while (i < text.length()) {
            int currentPosition = offset + i;
            String character = styledText.getTextRange(currentPosition, 1);
            StyleRange styleRange = styledText.getStyleRangeAtOffset(currentPosition);
            if (this.isRelevant(character)) {
                this.assertFontStyle(styleRange, character, fontStyle);
                this.assertForegroundColor(styleRange, character, expectedForegroundColor);
                this.assertBackgroundColor(styleRange, character, expectedBackgroundColor);
            }
            ++i;
        }
    }

    protected int getStartPosition(String content, String text) {
        return content.indexOf(text);
    }

    protected boolean isRelevant(String character) {
        return character.equals(character.trim());
    }

    protected void assertFontStyle(StyleRange styleRange, String character, int expected) {
        int actual = styleRange.fontStyle;
        AbstractHighlightingTest.assertEquals((String)("Expected font style does not correspond to the actual font style on character " + character), (long)expected, (long)actual);
    }

    protected void assertForegroundColor(StyleRange styleRange, String character, Color expected) {
        Color actual = styleRange.foreground != null ? styleRange.foreground : new Color(null, 0, 0, 0);
        AbstractHighlightingTest.assertEquals((String)("Expected foreground color does not correspond to the actual foreground color on character " + character), (Object)expected, (Object)actual);
    }

    protected void assertBackgroundColor(StyleRange styleRange, String character, Color expected) {
        Color actual = styleRange.background != null ? styleRange.background : new Color(null, 255, 255, 255);
        AbstractHighlightingTest.assertEquals((String)("Expected background color does not correspond to the actual background color on character " + character), (Object)expected, (Object)actual);
    }
}

