/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.testing.util;

import com.google.common.annotations.Beta;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.xtext.builder.impl.ProjectOpenedOrClosedListener;
import org.eclipse.xtext.ui.shared.contribution.ISharedStateContributionRegistry;
import org.eclipse.xtext.ui.testing.util.IResourcesSetupUtil;
import org.eclipse.xtext.ui.testing.util.JavaProjectSetupUtil;
import org.eclipse.xtext.ui.testing.util.TestedWorkspace;
import org.eclipse.xtext.util.Exceptions;
import org.junit.runner.Description;

@Beta
public class TestedWorkspaceWithJDT
extends TestedWorkspace {
    private volatile Job updateClasspathJob;
    private final IJobChangeListener listener = this.createJobListener();

    protected UpdateClasspathJobListener createJobListener() {
        return new UpdateClasspathJobListener();
    }

    @Inject
    public TestedWorkspaceWithJDT(ISharedStateContributionRegistry contributions) {
        this((ProjectOpenedOrClosedListener)contributions.getSingleContributedInstance(ProjectOpenedOrClosedListener.class));
    }

    public TestedWorkspaceWithJDT(ProjectOpenedOrClosedListener closedProjectTaskProcessor) {
        super(closedProjectTaskProcessor);
    }

    @Override
    protected void starting(Description d) {
        super.starting(d);
        this.addJobListener();
    }

    protected void addJobListener() {
        IJobManager jobManager = Job.getJobManager();
        jobManager.addJobChangeListener(this.listener);
    }

    protected IJobChangeListener getJobListener() {
        return this.listener;
    }

    protected Job getUpdateClasspathJob() {
        return this.updateClasspathJob;
    }

    protected void removeJobListener() {
        IJobManager jobManager = Job.getJobManager();
        jobManager.removeJobChangeListener(this.listener);
        this.updateClasspathJob = null;
    }

    @Override
    protected void finished(Description description) {
        super.finished(description);
        this.removeJobListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void joinUpdateClasspathJob() {
        try {
            TestedWorkspaceWithJDT testedWorkspaceWithJDT = this;
            synchronized (testedWorkspaceWithJDT) {
                ((Object)((Object)this)).wait(1L);
            }
            Job joinMe = this.updateClasspathJob;
            if (joinMe != null) {
                joinMe.join();
            }
        }
        catch (Exception e) {
            Exceptions.throwUncheckedException((Throwable)e);
        }
    }

    @Override
    public void joinJobsBeforeBuild() {
        this.joinUpdateClasspathJob();
        super.joinJobsBeforeBuild();
    }

    public void addToClasspath(IJavaProject project, IClasspathEntry newClassPathEntry) {
        try {
            JavaProjectSetupUtil.addToClasspath(project, newClassPathEntry, false);
            this.build();
        }
        catch (Exception e) {
            Exceptions.throwUncheckedException((Throwable)e);
        }
    }

    public IJavaProject createJavaProject(String name) {
        try {
            IJavaProject result = JavaProjectSetupUtil.createJavaProject(name, false);
            this.build();
            return result;
        }
        catch (Exception e) {
            return (IJavaProject)Exceptions.throwUncheckedException((Throwable)e);
        }
    }

    public IClasspathEntry addJarToClasspath(IJavaProject project, IFile jarFile) {
        try {
            IClasspathEntry result = JavaProjectSetupUtil.addJarToClasspath(project, jarFile);
            this.build();
            return result;
        }
        catch (Exception e) {
            return (IClasspathEntry)Exceptions.throwUncheckedException((Throwable)e);
        }
    }

    public void addProjectReference(IJavaProject from, IJavaProject to) {
        try {
            JavaProjectSetupUtil.addProjectReference(from, to, false);
            this.addDynamicProjectReference(from.getProject(), to.getProject());
            this.build();
        }
        catch (Exception e) {
            Exceptions.throwUncheckedException((Throwable)e);
        }
    }

    @Deprecated
    private void addDynamicProjectReference(IProject from, IProject to) throws CoreException {
        IProjectDescription description = from.getDescription();
        ArrayList<IProject> dynamicReferences = new ArrayList<IProject>(Arrays.asList(description.getDynamicReferences()));
        dynamicReferences.add(to);
        description.setDynamicReferences(dynamicReferences.toArray(new IProject[0]));
        from.setDescription(description, null);
    }

    public void removeProjectReference(IJavaProject from, IJavaProject to) {
        try {
            JavaProjectSetupUtil.removeProjectReference(from, to);
            this.removeDynamicProjectReference(from.getProject(), to.getProject());
            this.build();
        }
        catch (Exception e) {
            Exceptions.throwUncheckedException((Throwable)e);
        }
    }

    public void removeClasspathEntry(IJavaProject from, IClasspathEntry entry) {
        try {
            JavaProjectSetupUtil.removeFromClasspath(from, entry.getEntryKind(), entry.getPath());
            this.build();
        }
        catch (Exception e) {
            Exceptions.throwUncheckedException((Throwable)e);
        }
    }

    @Deprecated
    private void removeDynamicProjectReference(IProject from, IProject to) throws CoreException {
        IProjectDescription description = from.getDescription();
        ArrayList<IProject> dynamicReferences = new ArrayList<IProject>(Arrays.asList(description.getDynamicReferences()));
        dynamicReferences.removeAll(Collections.singleton(to));
        description.setDynamicReferences(dynamicReferences.toArray(new IProject[0]));
        from.setDescription(description, null);
    }

    public void addSourceFolder(IJavaProject project, String folder) {
        try {
            JavaProjectSetupUtil.addSourceFolder(project, folder, false);
            this.build();
        }
        catch (Exception e) {
            Exceptions.throwUncheckedException((Throwable)e);
        }
    }

    public IFolder createSubFolder(IProject project, String name) {
        try {
            return IResourcesSetupUtil.createFolder(project.getFolder(name).getFullPath());
        }
        catch (Exception e) {
            return (IFolder)Exceptions.throwUncheckedException((Throwable)e);
        }
    }

    public void deleteClasspathEntry(IJavaProject project, IPath entry) {
        try {
            JavaProjectSetupUtil.deleteClasspathEntry(project, entry);
        }
        catch (Exception e) {
            Exceptions.throwUncheckedException((Throwable)e);
        }
    }

    public class UpdateClasspathJobListener
    implements IJobChangeListener {
        public void aboutToRun(IJobChangeEvent event) {
        }

        public void awake(IJobChangeEvent event) {
        }

        public void done(IJobChangeEvent event) {
        }

        public void running(IJobChangeEvent event) {
        }

        public void scheduled(IJobChangeEvent event) {
            Class<?> jobType;
            if (TestedWorkspaceWithJDT.this.updateClasspathJob == null && PluginModelManager.class.equals((jobType = event.getJob().getClass()).getEnclosingClass())) {
                TestedWorkspaceWithJDT.this.updateClasspathJob = event.getJob();
            }
        }

        public void sleeping(IJobChangeEvent event) {
        }
    }
}

