/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.findrefs;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.IGlobalServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.findrefs.Messages;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceQueryExecutor;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class FindReferencesHandler
extends AbstractHandler {
    @Inject
    protected EObjectAtOffsetHelper eObjectAtOffsetHelper;
    @Inject
    protected IGlobalServiceProvider globalServiceProvider;
    private static final Logger LOG = Logger.getLogger(FindReferencesHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            XtextEditor editor = EditorUtils.getActiveXtextEditor(event);
            if (editor != null) {
                final ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
                editor.getDocument().priorityReadOnly((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                    public void process(XtextResource state) throws Exception {
                        EObject target = FindReferencesHandler.this.eObjectAtOffsetHelper.resolveElementAt(state, selection.getOffset());
                        FindReferencesHandler.this.findReferences(target);
                    }
                });
            }
        }
        catch (Exception e) {
            LOG.error((Object)Messages.FindReferencesHandler_3, (Throwable)e);
        }
        return null;
    }

    protected void findReferences(EObject target) {
        ReferenceQueryExecutor queryExecutor = this.getQueryExecutor(target);
        if (queryExecutor != null) {
            queryExecutor.execute();
        }
    }

    protected ReferenceQueryExecutor getQueryExecutor(EObject target) {
        ReferenceQueryExecutor queryExecutor;
        if (target == null) {
            return null;
        }
        URI targetURI = EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)target);
        if (targetURI != null && (queryExecutor = (ReferenceQueryExecutor)this.globalServiceProvider.findService(targetURI.trimFragment(), ReferenceQueryExecutor.class)) != null) {
            queryExecutor.init(target);
            return queryExecutor;
        }
        return null;
    }
}

