/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.quickfix;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import org.eclipse.xtext.ui.editor.model.edit.BatchModification;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolution;
import org.eclipse.xtext.ui.editor.quickfix.MarkerResolutionGenerator;
import org.eclipse.xtext.ui.util.IssueUtil;
import org.eclipse.xtext.validation.Issue;

public class WorkbenchMarkerResolutionAdapter
extends WorkbenchMarkerResolution {
    private static final Logger LOG = Logger.getLogger(WorkbenchMarkerResolutionAdapter.class);
    @Inject
    private MarkerResolutionGenerator resolutionsGenerator;
    @Inject
    private IssueUtil issueUtil;
    @Inject
    private Provider<BatchModification> batchModificationProvider;
    private IssueResolution primaryResolution;
    private IMarker primaryMarker;

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        ArrayList<IMarker> otherMarkers = new ArrayList<IMarker>();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (marker != this.primaryMarker && Objects.equals(this.issueUtil.getCode(this.primaryMarker), this.issueUtil.getCode(marker))) {
                otherMarkers.add(marker);
            }
            ++n2;
        }
        return otherMarkers.toArray(new IMarker[0]);
    }

    public String getLabel() {
        return this.primaryResolution.getLabel();
    }

    public void run(IMarker marker) {
        if (!marker.exists()) {
            return;
        }
        this.run(new IMarker[]{marker}, (IProgressMonitor)new NullProgressMonitor());
    }

    public void run(IMarker[] markers, IProgressMonitor progressMonitor) {
        Map<IProject, List<IMarker>> markersByProject = Arrays.asList(markers).stream().collect(Collectors.groupingBy(marker -> marker.getResource().getProject()));
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor);
        monitor.beginTask("Applying resolutions", markersByProject.size());
        markersByProject.forEach((key, value) -> {
            BatchModification batch = (BatchModification)this.batchModificationProvider.get();
            batch.setProject((IProject)key);
            ArrayList<BatchModification.IBatchableModification> modifications = new ArrayList<BatchModification.IBatchableModification>();
            List markersInProject = value;
            markersInProject.forEach(marker -> {
                IModification modification;
                IssueResolution resolution = this.resolution((IMarker)marker);
                if (resolution != null && (modification = resolution.getModification()) instanceof BatchModification.IBatchableModification) {
                    modifications.add((BatchModification.IBatchableModification)((Object)modification));
                }
            });
            this.cancelIfNeeded((IProgressMonitor)monitor);
            batch.apply(modifications, (IProgressMonitor)monitor.newChild(1));
            this.cancelIfNeeded((IProgressMonitor)monitor);
        });
        monitor.done();
    }

    protected void cancelIfNeeded(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public IssueResolution resolution(IMarker marker) {
        if (!marker.exists()) {
            return null;
        }
        Issue issue = this.issueUtil.createIssue(marker);
        List<IssueResolution> resolutions = this.resolutionsGenerator.getResolutionProvider().getResolutions(issue);
        Optional<IssueResolution> issueResolution = resolutions.stream().filter(resolution -> this.isSameResolution((IssueResolution)resolution, this.primaryResolution)).findFirst();
        if (!issueResolution.isPresent()) {
            LOG.warn((Object)("Resolution missing for " + issue.getCode()));
            return null;
        }
        return issueResolution.get();
    }

    public String getDescription() {
        return this.primaryResolution.getDescription();
    }

    public Image getImage() {
        return this.resolutionsGenerator.getImage(this.primaryResolution);
    }

    private boolean isSameResolution(IssueResolution issueResolution, IssueResolution other) {
        return issueResolution != null && other != null && Objects.equals(issueResolution.getDescription(), other.getDescription()) && Objects.equals(issueResolution.getLabel(), other.getLabel()) && Objects.equals(issueResolution.getImage(), other.getImage());
    }

    public IssueResolution getPrimaryResolution() {
        return this.primaryResolution;
    }

    public void setPrimaryResolution(IssueResolution primaryResolution) {
        this.primaryResolution = primaryResolution;
    }

    public IMarker getPrimaryMarker() {
        return this.primaryMarker;
    }

    public void setPrimaryMarker(IMarker primaryMarker) {
        this.primaryMarker = primaryMarker;
    }

    public static class Factory {
        @Inject
        private Provider<WorkbenchMarkerResolutionAdapter> provider;

        public IMarkerResolution create(IMarker marker, IssueResolution resolution) {
            WorkbenchMarkerResolutionAdapter resolutionFix = (WorkbenchMarkerResolutionAdapter)((Object)this.provider.get());
            resolutionFix.primaryResolution = resolution;
            resolutionFix.primaryMarker = marker;
            return resolutionFix;
        }
    }
}

