/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.widgets.util;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.widgets.Display;

public class RepeatFiringBehavior {
    protected static final int INITIAL_DELAY = 250;
    protected static final int STEP_DELAY = 40;
    protected int stepDelay = 250;
    protected int initialDelay = 40;
    protected Timer timer;
    private Runnable runTask;
    private Display display = Display.getCurrent();

    public void pressed() {
        this.runTask.run();
        this.timer = new Timer();
        Task runAction = new Task();
        this.timer.scheduleAtFixedRate((TimerTask)runAction, 250L, 40L);
    }

    public void canceled() {
        this.suspend();
    }

    public void released() {
        this.suspend();
    }

    public void resume() {
        this.timer = new Timer();
        Task runAction = new Task();
        this.timer.scheduleAtFixedRate((TimerTask)runAction, 40L, 40L);
    }

    public void suspend() {
        if (this.timer == null) {
            return;
        }
        this.timer.cancel();
        this.timer = null;
    }

    public void setRunTask(Runnable runTask) {
        this.runTask = runTask;
    }

    class Task
    extends TimerTask {
        Task() {
        }

        @Override
        public void run() {
            RepeatFiringBehavior.this.display.syncExec(RepeatFiringBehavior.this.runTask);
        }
    }
}

