/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.calculator;

import java.math.BigDecimal;
import org.eclipse.nebula.widgets.opal.calculator.CalculatorButtonsComposite;
import org.eclipse.nebula.widgets.opal.commons.ResourceManager;

class CalculatorEngine {
    static final String OPERATOR_PLUS = "+";
    static final String OPERATOR_MINUS = "-";
    static final String OPERATOR_MULTIPLY = "*";
    static final String OPERATOR_DIVIDE = "/";
    private String lastOperator;
    private final CalculatorButtonsComposite composite;
    private boolean error;
    private Double lastNumber;

    CalculatorEngine(CalculatorButtonsComposite composite) {
        this.composite = composite;
    }

    private void setContent(Double value) {
        this.composite.getDisplayArea().setText(this.doubleToString(value));
        this.composite.fireModifyListeners();
    }

    private String doubleToString(Double d) {
        if (d == null) {
            return "0";
        }
        if (d == 0.0) {
            return "0";
        }
        if (Math.floor(d) == d) {
            return Integer.toString(d.intValue());
        }
        return new BigDecimal(d.toString()).stripTrailingZeros().toPlainString();
    }

    private Double getContent() {
        String content = this.composite.getDisplayArea().getText();
        return Double.valueOf(content);
    }

    void processEquals() {
        if (this.error) {
            return;
        }
        if (this.lastOperator == null) {
            return;
        }
        double result = 0.0;
        double content = this.getContent();
        if (this.lastOperator.equals(OPERATOR_DIVIDE)) {
            if (content == 0.0) {
                this.displayErrorMessage("calculator.dividebyzero");
                return;
            }
            result = this.lastNumber / content;
        }
        if (this.lastOperator.equals(OPERATOR_MULTIPLY)) {
            result = this.lastNumber * content;
        }
        if (this.lastOperator.equals(OPERATOR_MINUS)) {
            result = this.lastNumber - content;
        }
        if (this.lastOperator.equals(OPERATOR_PLUS)) {
            result = this.lastNumber + content;
        }
        this.setContent(result);
        this.lastOperator = null;
        this.lastNumber = result;
    }

    private void displayErrorMessage(String errorMessage) {
        this.composite.getDisplayArea().setText(ResourceManager.getLabel((String)errorMessage));
        this.lastOperator = null;
        this.lastNumber = null;
        this.error = true;
    }

    void processInverseOperation() {
        if (this.error) {
            return;
        }
        this.processEquals();
        try {
            double result = 1.0 / this.getContent();
            this.setContent(result);
        }
        catch (Exception ex) {
            this.displayErrorMessage("calculator.dividebyzero");
        }
    }

    void processOperation(String operator) {
        if (this.error) {
            return;
        }
        this.lastOperator = operator;
        this.lastNumber = this.getContent();
        this.composite.setReadyToEnterNewNumber(true);
    }

    void processPerCentageOperation() {
        if (this.error) {
            return;
        }
        double result = this.getContent();
        this.setContent(result / 100.0);
    }

    void processSignChange() {
        if (this.error) {
            return;
        }
        double result = this.getContent();
        this.setContent(result * -1.0);
    }

    void processSquareRootOperation() {
        if (this.error) {
            return;
        }
        this.processEquals();
        try {
            double result = Math.sqrt(this.getContent());
            this.setContent(result);
        }
        catch (Exception ex) {
            this.displayErrorMessage("calculator.invalid");
        }
    }

    public void cancel() {
        this.lastOperator = null;
        this.error = false;
        this.composite.setReadyToEnterNewNumber(false);
        this.lastNumber = null;
    }
}

