/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.geomap.internal.geomapbrowser;

import org.eclipse.nebula.widgets.geomap.internal.geomapbrowser.HeaderControl;
import org.eclipse.nebula.widgets.geomap.internal.geomapbrowser.Page;
import org.eclipse.nebula.widgets.geomap.internal.geomapbrowser.PageContainer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public abstract class AbstractPage
implements Page {
    private PageContainer container;
    private Composite composite;

    protected PageContainer getContainer() {
        return this.container;
    }

    protected Composite getComposite() {
        return this.composite;
    }

    @Override
    public Control getControl(PageContainer container, Composite parent) {
        if (this.composite == null) {
            this.container = container;
            this.composite = new Composite(parent, 0);
            this.composite.addDisposeListener(e -> this.widgetDisposed(e));
            this.composite.setLayout((Layout)new GridLayout(2, false));
            container.adapt((Control)this.composite);
            this.initContent(container, this.composite);
        }
        return this.composite;
    }

    protected void addHeaderRow(PageContainer container, Composite parent, String text) {
        HeaderControl header = new HeaderControl(parent);
        container.adapt((Control)header);
        header.setLayoutData(new GridData(4, 1, true, false, 2, 1));
        header.setText(text);
    }

    protected Link addInfoText(PageContainer container, Composite parent, String text) {
        Link link = new Link(parent, 66);
        container.adapt((Control)link);
        GridData layoutData = new GridData(4, 1, true, false, 2, 1);
        link.setLayoutData((Object)layoutData);
        link.setText(text);
        link.addListener(13, event -> {
            try {
                if (event.text != null && event.text.length() > 0) {
                    Program.launch((String)event.text);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return link;
    }

    protected void addActionLink(PageContainer container, Composite parent, String text, SelectionAdapter selectionAdapter) {
        Composite wrap = new Composite(parent, 0);
        wrap.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        container.adapt((Control)wrap);
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = 8;
        layout.marginHeight = 0;
        wrap.setLayout((Layout)layout);
        Label titleImage = new Label(wrap, 64);
        container.adapt((Control)titleImage);
        Link link = new Link(wrap, 0);
        container.adapt((Control)link);
        link.setText(text);
        link.addSelectionListener((SelectionListener)selectionAdapter);
    }

    protected abstract void widgetDisposed(DisposeEvent var1);

    protected abstract void initContent(PageContainer var1, Composite var2);
}

