/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.widgets;

import java.util.function.Consumer;
import org.eclipse.jface.widgets.AbstractControlFactory;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public final class TextFactory
extends AbstractControlFactory<TextFactory, Text> {
    private TextFactory(int style) {
        super(TextFactory.class, (Composite parent) -> new Text(parent, style));
    }

    public static TextFactory newText(int style) {
        return new TextFactory(style);
    }

    public TextFactory text(String text) {
        this.addProperty(t -> t.setText(text));
        return this;
    }

    public TextFactory message(String message) {
        this.addProperty(t -> t.setMessage(message));
        return this;
    }

    public TextFactory limitTo(int limit) {
        this.addProperty(t -> t.setTextLimit(limit));
        return this;
    }

    public TextFactory onSelect(Consumer<SelectionEvent> consumer) {
        this.addProperty(t -> t.addSelectionListener(SelectionListener.widgetSelectedAdapter((Consumer)consumer)));
        return this;
    }

    public TextFactory onModify(ModifyListener listener) {
        this.addProperty(t -> t.addModifyListener(listener));
        return this;
    }

    public TextFactory onVerify(VerifyListener listener) {
        this.addProperty(l -> l.addVerifyListener(listener));
        return this;
    }
}

