/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.map;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.map.BidiObservableMap;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.observable.map.ObservableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.runtime.Assert;

public class CompositeMap<K, I, V>
extends ObservableMap<K, V> {
    private final Set<I> pendingAdds = new HashSet<I>();
    private final Map<I, K> pendingRemoves = new HashMap<I, K>();
    private final Map<I, I> pendingChanges = new HashMap<I, I>();
    private BidiObservableMap<K, I> firstMap;
    private IObservableMap<I, V> secondMap;
    private final WritableSetPlus<I> rangeSet = new WritableSetPlus();
    private final IMapChangeListener<K, I> firstMapListener = event -> {
        MapDiff diff = event.diff;
        HashSet rangeSetAdditions = new HashSet();
        HashSet rangeSetRemovals = new HashSet();
        final HashSet adds = new HashSet();
        final HashSet changes = new HashSet();
        final HashSet removes = new HashSet();
        final HashMap oldValues = new HashMap();
        for (Object addedKey : diff.getAddedKeys()) {
            Object newValue1 = diff.getNewValue(addedKey);
            if (!this.rangeSet.contains(newValue1)) {
                this.pendingAdds.add(newValue1);
                rangeSetAdditions.add(newValue1);
                continue;
            }
            adds.add(addedKey);
            this.wrappedMap.put(addedKey, this.secondMap.get(newValue1));
        }
        for (Object changedKey : diff.getChangedKeys()) {
            boolean added;
            Object oldValue1 = diff.getOldValue(changedKey);
            Object newValue2 = diff.getNewValue(changedKey);
            boolean removed = this.firstMap.getKeys(oldValue1).isEmpty();
            boolean bl = added = !this.rangeSet.contains(newValue2);
            if (removed) {
                this.pendingRemoves.put(oldValue1, changedKey);
                rangeSetRemovals.add(oldValue1);
            }
            if (added) {
                this.pendingAdds.add(newValue2);
                rangeSetAdditions.add(newValue2);
            }
            if (added || removed) {
                this.pendingChanges.put(oldValue1, newValue2);
                this.pendingChanges.put(newValue2, oldValue1);
                continue;
            }
            changes.add(changedKey);
            oldValues.put(changedKey, this.secondMap.get(oldValue1));
            this.wrappedMap.put(changedKey, this.secondMap.get(newValue2));
        }
        for (Object removedKey : diff.getRemovedKeys()) {
            Object oldValue2 = diff.getOldValue(removedKey);
            if (this.firstMap.getKeys(oldValue2).isEmpty()) {
                this.pendingRemoves.put(oldValue2, removedKey);
                rangeSetRemovals.add(oldValue2);
                continue;
            }
            removes.add(removedKey);
            oldValues.put(removedKey, this.secondMap.get(oldValue2));
            this.wrappedMap.remove(removedKey);
        }
        if (adds.size() > 0 || removes.size() > 0 || changes.size() > 0) {
            this.fireMapChange(new MapDiff<K, V>(){

                @Override
                public Set<K> getAddedKeys() {
                    return adds;
                }

                @Override
                public Set<K> getChangedKeys() {
                    return changes;
                }

                @Override
                public V getNewValue(Object key) {
                    return CompositeMap.this.wrappedMap.get(key);
                }

                @Override
                public V getOldValue(Object key) {
                    return oldValues.get(key);
                }

                @Override
                public Set<K> getRemovedKeys() {
                    return removes;
                }
            });
        }
        if (rangeSetAdditions.size() > 0 || rangeSetRemovals.size() > 0) {
            this.rangeSet.addAndRemove(rangeSetAdditions, rangeSetRemovals);
        }
    };
    private final IMapChangeListener<I, V> secondMapListener = event -> {
        MapDiff diff = event.diff;
        final HashSet<Object> adds = new HashSet<Object>();
        final HashSet<K> changes = new HashSet<K>();
        final HashSet<K> removes = new HashSet<K>();
        final HashMap<K, Iterator<Object>> oldValues = new HashMap<K, Iterator<Object>>();
        final HashMap<Object, V> newValues = new HashMap<Object, V>();
        HashSet addedKeys = new HashSet(diff.getAddedKeys());
        HashSet removedKeys = new HashSet(diff.getRemovedKeys());
        for (Object addedKey : addedKeys) {
            Set<K> elements1 = this.firstMap.getKeys(addedKey);
            Object newValue1 = diff.getNewValue(addedKey);
            if (this.pendingChanges.containsKey(addedKey)) {
                I oldKey = this.pendingChanges.remove(addedKey);
                Iterator<Object> oldValue1 = removedKeys.remove(oldKey) ? diff.getOldValue(oldKey) : this.secondMap.get(oldKey);
                this.pendingChanges.remove(oldKey);
                this.pendingAdds.remove(addedKey);
                this.pendingRemoves.remove(oldKey);
                for (K element1 : elements1) {
                    changes.add(element1);
                    oldValues.put(element1, oldValue1);
                    newValues.put(element1, newValue1);
                    this.wrappedMap.put(element1, newValue1);
                }
                continue;
            }
            if (this.pendingAdds.remove(addedKey)) {
                for (Object element2 : elements1) {
                    adds.add(element2);
                    newValues.put(element2, newValue1);
                    this.wrappedMap.put(element2, newValue1);
                }
                continue;
            }
            Assert.isTrue((boolean)false, (String)"unexpected case");
        }
        for (Object changedKey : diff.getChangedKeys()) {
            Set<K> elements2 = this.firstMap.getKeys(changedKey);
            for (K element3 : elements2) {
                changes.add(element3);
                oldValues.put(element3, (Iterator<Object>)diff.getOldValue(changedKey));
                Object newValue2 = diff.getNewValue(changedKey);
                newValues.put(element3, newValue2);
                this.wrappedMap.put(element3, newValue2);
            }
        }
        for (Object removedKey : removedKeys) {
            K element4 = this.pendingRemoves.remove(removedKey);
            if (element4 != null) {
                if (this.pendingChanges.containsKey(removedKey)) {
                    I newKey = this.pendingChanges.remove(removedKey);
                    this.pendingChanges.remove(newKey);
                    this.pendingAdds.remove(newKey);
                    this.pendingRemoves.remove(removedKey);
                    changes.add(element4);
                    oldValues.put(element4, (Iterator<Object>)diff.getOldValue(removedKey));
                    V newValue3 = this.secondMap.get(newKey);
                    newValues.put(element4, newValue3);
                    this.wrappedMap.put(element4, newValue3);
                    continue;
                }
                removes.add(element4);
                Object oldValue2 = diff.getOldValue(removedKey);
                oldValues.put(element4, (Iterator<Object>)oldValue2);
                this.wrappedMap.remove(element4);
                continue;
            }
            Assert.isTrue((boolean)false, (String)"unexpected case");
        }
        if (adds.size() > 0 || removes.size() > 0 || changes.size() > 0) {
            this.fireMapChange(new MapDiff<K, V>(){

                @Override
                public Set<K> getAddedKeys() {
                    return adds;
                }

                @Override
                public Set<K> getChangedKeys() {
                    return changes;
                }

                @Override
                public V getNewValue(Object key) {
                    return newValues.get(key);
                }

                @Override
                public V getOldValue(Object key) {
                    return oldValues.get(key);
                }

                @Override
                public Set<K> getRemovedKeys() {
                    return removes;
                }
            });
        }
    };

    public CompositeMap(IObservableMap<K, I> firstMap, IObservableFactory<? super IObservableSet<I>, ? extends IObservableMap<I, V>> secondMapFactory) {
        super(firstMap.getRealm(), new HashMap());
        this.firstMap = new BidiObservableMap<K, I>(firstMap);
        this.firstMap.addMapChangeListener(this.firstMapListener);
        this.rangeSet.addAll(this.firstMap.values());
        this.secondMap = secondMapFactory.createObservable(this.rangeSet);
        this.secondMap.addMapChangeListener(this.secondMapListener);
        for (Map.Entry entry : this.firstMap.entrySet()) {
            this.wrappedMap.put(entry.getKey(), this.secondMap.get(entry.getValue()));
        }
    }

    @Override
    public Object getKeyType() {
        return this.firstMap.getKeyType();
    }

    @Override
    public Object getValueType() {
        return this.secondMap.getValueType();
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        if (this.firstMap != null) {
            this.firstMap.removeMapChangeListener(this.firstMapListener);
            this.firstMap = null;
        }
        if (this.secondMap != null) {
            this.secondMap.dispose();
            this.secondMap = null;
        }
    }

    private static class WritableSetPlus<E>
    extends WritableSet<E> {
        private WritableSetPlus() {
        }

        void addAndRemove(Set<E> additions, Set<E> removals) {
            this.wrappedSet.removeAll(removals);
            this.wrappedSet.addAll(additions);
            this.fireSetChange(Diffs.createSetDiff(additions, removals));
        }
    }
}

