/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.sync;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SyncPolicy implements Enumerator
{
    INCLUDE(0, "Include", "Include"),
    EXCLUDE(1, "Exclude", "Exclude");

    public static final int INCLUDE_VALUE = 0;
    public static final int EXCLUDE_VALUE = 1;
    private static final SyncPolicy[] VALUES_ARRAY;
    public static final List<SyncPolicy> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SyncPolicy[]{INCLUDE, EXCLUDE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SyncPolicy get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SyncPolicy result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SyncPolicy getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SyncPolicy result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SyncPolicy get(int value) {
        switch (value) {
            case 0: {
                return INCLUDE;
            }
            case 1: {
                return EXCLUDE;
            }
        }
        return null;
    }

    private SyncPolicy(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

