/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.facet.FacetUtils;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.TaxonomyFacets;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ConjunctionUtils;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.Bits;

public class FastTaxonomyFacetCounts
extends TaxonomyFacets {
    public FastTaxonomyFacetCounts(TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc) throws IOException {
        this("$facets", taxoReader, config, fc);
    }

    public FastTaxonomyFacetCounts(String indexFieldName, TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc) throws IOException {
        super(indexFieldName, taxoReader, config, fc);
        this.count(fc.getMatchingDocs());
    }

    public FastTaxonomyFacetCounts(String indexFieldName, IndexReader reader, TaxonomyReader taxoReader, FacetsConfig config) throws IOException {
        super(indexFieldName, taxoReader, config, null);
        this.countAll(reader);
    }

    private void count(List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            int i;
            SortedNumericDocValues multiValued;
            if (hits.totalHits == 0 || (multiValued = FacetUtils.loadOrdinalValues(hits.context.reader(), this.indexFieldName)) == null) continue;
            this.initializeValueCounters();
            NumericDocValues singleValued = DocValues.unwrapSingleton((SortedNumericDocValues)multiValued);
            NumericDocValues valuesIt = singleValued != null ? singleValued : multiValued;
            DocIdSetIterator it = ConjunctionUtils.intersectIterators(Arrays.asList(hits.bits.iterator(), valuesIt));
            if (singleValued != null) {
                if (this.counts != null) {
                    while (it.nextDoc() != Integer.MAX_VALUE) {
                        int n = (int)singleValued.longValue();
                        this.counts[n] = this.counts[n] + 1;
                    }
                    continue;
                }
                while (it.nextDoc() != Integer.MAX_VALUE) {
                    this.sparseCounts.addTo((int)singleValued.longValue(), 1);
                }
                continue;
            }
            if (this.counts != null) {
                while (it.nextDoc() != Integer.MAX_VALUE) {
                    for (i = 0; i < multiValued.docValueCount(); ++i) {
                        int n = (int)multiValued.nextValue();
                        this.counts[n] = this.counts[n] + 1;
                    }
                }
                continue;
            }
            while (it.nextDoc() != Integer.MAX_VALUE) {
                for (i = 0; i < multiValued.docValueCount(); ++i) {
                    this.sparseCounts.addTo((int)multiValued.nextValue(), 1);
                }
            }
        }
        this.rollup();
    }

    private void countAll(IndexReader reader) throws IOException {
        for (LeafReaderContext context : reader.leaves()) {
            int i;
            int doc;
            SortedNumericDocValues multiValued = FacetUtils.loadOrdinalValues(context.reader(), this.indexFieldName);
            if (multiValued == null) continue;
            this.initializeValueCounters();
            assert (this.counts != null);
            Bits liveDocs = context.reader().getLiveDocs();
            NumericDocValues singleValued = DocValues.unwrapSingleton((SortedNumericDocValues)multiValued);
            if (singleValued != null) {
                if (liveDocs == null) {
                    doc = singleValued.nextDoc();
                    while (doc != Integer.MAX_VALUE) {
                        int n = (int)singleValued.longValue();
                        this.counts[n] = this.counts[n] + 1;
                        doc = singleValued.nextDoc();
                    }
                    continue;
                }
                doc = singleValued.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    if (liveDocs.get(doc)) {
                        int n = (int)singleValued.longValue();
                        this.counts[n] = this.counts[n] + 1;
                    }
                    doc = singleValued.nextDoc();
                }
                continue;
            }
            if (liveDocs == null) {
                doc = multiValued.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    for (i = 0; i < multiValued.docValueCount(); ++i) {
                        int n = (int)multiValued.nextValue();
                        this.counts[n] = this.counts[n] + 1;
                    }
                    doc = multiValued.nextDoc();
                }
                continue;
            }
            doc = multiValued.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (liveDocs.get(doc)) {
                    for (i = 0; i < multiValued.docValueCount(); ++i) {
                        int n = (int)multiValued.nextValue();
                        this.counts[n] = this.counts[n] + 1;
                    }
                }
                doc = multiValued.nextDoc();
            }
        }
        this.rollup();
    }
}

