/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.cli;

import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.passage.lic.api.FeatureIdentifier;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.access.GrantLockAttempt;
import org.eclipse.passage.lic.base.BaseFeatureIdentifier;
import org.eclipse.passage.lic.base.diagnostic.DiagnosticExplained;
import org.eclipse.passage.lic.cli.ConsoleInteraction;
import org.eclipse.passage.lic.cli.Interaction;
import org.eclipse.passage.lic.cli.LicenseCoverageCheck;
import org.eclipse.passage.lic.cli.OptionDefinitions;
import org.eclipse.passage.lic.cli.Product;
import org.eclipse.passage.lic.cli.TheOtherSide;
import org.eclipse.passage.lic.equinox.EquinoxPassage;

public final class LicenseProtection {
    private Optional<GrantLockAttempt> lock = Optional.empty();
    private final String name;
    private final TheOtherSide communication;
    private final OptionDefinitions opts;

    public LicenseProtection() {
        this(ConsoleInteraction::new);
    }

    public LicenseProtection(Supplier<Interaction> interaction) {
        this(new TheOtherSide.Blind(interaction.get()));
    }

    public LicenseProtection(TheOtherSide communication) {
        this("application", communication);
    }

    public LicenseProtection(String name, TheOtherSide communication) {
        this(name, communication, new OptionDefinitions.Default(communication));
    }

    public LicenseProtection(String name, TheOtherSide communication, OptionDefinitions opts) {
        this.name = name;
        this.communication = communication;
        this.opts = opts;
    }

    public boolean check() {
        if (this.licenseCoverageIsNotSufficient()) {
            return false;
        }
        return this.locAcquired();
    }

    public void release() {
        this.lock.ifPresent(acq -> {
            ServiceInvocationResult serviceInvocationResult = new EquinoxPassage().releaseLicense(acq);
        });
    }

    private boolean locAcquired() {
        Optional<GrantLockAttempt> attempt = this.acquireLicense();
        if (!attempt.isPresent()) {
            return false;
        }
        if (!attempt.get().successful()) {
            return false;
        }
        this.lock = attempt;
        return true;
    }

    private boolean licenseCoverageIsNotSufficient() {
        return !LicenseCoverageCheck.Result.proceed.equals((Object)new LicenseCoverageCheck(this.name, this.communication, this.opts).run());
    }

    private Optional<GrantLockAttempt> acquireLicense() {
        return this.acquireLicense(new Product().get());
    }

    private Optional<GrantLockAttempt> acquireLicense(LicensedProduct product) {
        ServiceInvocationResult response = new EquinoxPassage().acquireLicense((FeatureIdentifier)new BaseFeatureIdentifier(product.identifier()));
        if (!this.successful((ServiceInvocationResult<GrantLockAttempt>)response)) {
            System.err.printf("Failed to acquire license \nfor product %s:\n%s\n", product, new DiagnosticExplained(response.diagnostic()).get());
            return Optional.empty();
        }
        return Optional.of((GrantLockAttempt)response.data().get());
    }

    private boolean successful(ServiceInvocationResult<GrantLockAttempt> response) {
        return response.data().map(GrantLockAttempt::successful).orElse(Boolean.FALSE);
    }
}

