/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.ui.text.correction.JavadocTagsSubProcessorCore;
import org.eclipse.text.edits.TextEditGroup;

public class JavadocUtil {
    private static List<String> tagOrder = Arrays.asList("@author", "@version", "@param", "@return", "@throws", "@exception", "@see", "@since", "@serial", "@serialField", "@serialData", "@deprecated", "@value");

    private JavadocUtil() {
    }

    public static TagElement createParamTag(String parameterName, AST ast, IJavaProject javaProject) {
        TagElement paramNode = ast.newTagElement();
        paramNode.setTagName("@param");
        SimpleName simpleName = ast.newSimpleName(parameterName);
        paramNode.fragments().add(simpleName);
        TextElement textElement = ast.newTextElement();
        String text = StubUtility.getTodoTaskTag(javaProject);
        if (text != null) {
            textElement.setText(text);
        }
        paramNode.fragments().add(textElement);
        return paramNode;
    }

    public static boolean shouldAddParamJavadoc(MethodDeclaration methodDeclaration) {
        Javadoc javadoc = methodDeclaration.getJavadoc();
        if (javadoc == null) {
            return false;
        }
        if (methodDeclaration.parameters().size() == 0) {
            return true;
        }
        List tags = javadoc.tags();
        for (TagElement element : tags) {
            if (!"@param".equals(element.getTagName())) continue;
            return true;
        }
        return false;
    }

    public static void addParamJavadoc(String parameterName, MethodDeclaration methodDeclaration, ASTRewrite astRewrite, IJavaProject javaProject, TextEditGroup groupDescription) {
        if (!JavadocUtil.shouldAddParamJavadoc(methodDeclaration)) {
            return;
        }
        ListRewrite tagsRewrite = astRewrite.getListRewrite((ASTNode)methodDeclaration.getJavadoc(), Javadoc.TAGS_PROPERTY);
        HashSet<String> leadingNames = new HashSet<String>();
        for (SingleVariableDeclaration curr : methodDeclaration.parameters()) {
            leadingNames.add(curr.getName().getIdentifier());
        }
        TagElement parameterTag = JavadocUtil.createParamTag(parameterName, astRewrite.getAST(), javaProject);
        JavadocTagsSubProcessorCore.insertTag(tagsRewrite, parameterTag, leadingNames, groupDescription);
    }

    public static TagElement findTagElementToInsertAfter(List<TagElement> tags, String tagName) {
        int goalOrdinal = tagOrder.indexOf(tagName);
        if (goalOrdinal == -1) {
            return tags.isEmpty() ? null : tags.get(tags.size());
        }
        int i = 0;
        while (i < tags.size()) {
            int tagOrdinal = tagOrder.indexOf(tags.get(i).getTagName());
            if (tagOrdinal >= goalOrdinal) {
                return i == 0 ? null : tags.get(i - 1);
            }
            ++i;
        }
        return tags.isEmpty() ? null : tags.get(tags.size() - 1);
    }

    public static TagElement findTagElementToInsertBefore(List<TagElement> tags, String tagName) {
        int goalOrdinal = tagOrder.indexOf(tagName);
        if (goalOrdinal == -1) {
            return tags.isEmpty() ? null : tags.get(tags.size());
        }
        int i = tags.size() - 1;
        while (i >= 0) {
            int tagOrdinal = tagOrder.indexOf(tags.get(i).getTagName());
            if (tagOrdinal <= goalOrdinal) {
                return i == tags.size() - 1 ? null : tags.get(i + 1);
            }
            --i;
        }
        return null;
    }
}

