/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.verifications.runtime;

import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.rcptt.verifications.runtime.VerificationStatus;
import org.eclipse.rcptt.verifications.status.StatusFactory;
import org.eclipse.rcptt.verifications.status.VerificationStatusData;

public class ErrorList {
    private EList<VerificationStatusData> errors = new BasicEList();

    public void add(String error, Object ... args) {
        VerificationStatusData newError = StatusFactory.eINSTANCE.createVerificationStatusData();
        newError.setMessage(String.format(error, args));
        this.errors.add((Object)newError);
    }

    public void add(VerificationStatusData data) {
        this.errors.add((Object)data);
    }

    public void throwIfAny(String message, String pluginId, String resourceId) throws CoreException {
        if (this.errors.size() == 0) {
            return;
        }
        for (VerificationStatusData data : this.errors) {
            data.setResourceId(resourceId);
        }
        throw new CoreException((IStatus)new VerificationStatus(4, pluginId, message, resourceId, (Collection<? extends VerificationStatusData>)this.errors));
    }

    public boolean isEmpty() {
        return this.errors.isEmpty();
    }
}

