/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.aut;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.rcptt.internal.launching.aut.BaseAutLaunch;
import org.eclipse.rcptt.internal.launching.aut.BaseAutManager;
import org.eclipse.rcptt.internal.launching.aut.LaunchInfoCache;
import org.eclipse.rcptt.launching.Aut;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.launching.ILaunchExecutor;

public class BaseAut
implements Aut {
    public static final int TERMINATE_CODE = 7788;
    private static final ILog LOG = Platform.getLog(BaseAut.class);
    private final ILaunchConfiguration config;
    private final ILaunchExecutor executor;

    public BaseAut(ILaunchConfiguration config, ILaunchExecutor executor) {
        this.config = config;
        this.executor = executor;
    }

    @Override
    public ILaunchConfiguration getConfig() {
        return this.config;
    }

    @Override
    public String getName() {
        return this.config.getName();
    }

    @Override
    public List<AutLaunch> getLaunches() {
        return BaseAutManager.INSTANCE.getLaunches(this);
    }

    @Override
    public AutLaunch launch(IProgressMonitor monitor) throws CoreException {
        ILaunch launch = this.executor.launch("run", this.config, monitor);
        if (monitor != null && monitor.isCanceled()) {
            assert (BaseAutManager.INSTANCE.getByLaunch(launch) == null);
            if (launch != null) {
                launch.terminate();
            }
            throw new CoreException(Status.CANCEL_STATUS);
        }
        assert (launch.getProcesses().length > 0);
        BaseAutLaunch result = BaseAutManager.INSTANCE.getByLaunch(launch);
        return result;
    }

    @Override
    public BaseAutLaunch getActiveLaunch() {
        return BaseAutManager.INSTANCE.getCurrentLaunch(this);
    }

    public ILaunchExecutor getExecutor() {
        return this.executor;
    }

    @Override
    public void delete() {
        ILaunchConfiguration config2 = this.getConfig();
        try {
            LaunchInfoCache.remove(config2);
            BaseAutManager.INSTANCE.launchConfigurationRemoved(config2);
            config2.delete();
        }
        catch (CoreException e) {
            LOG.log(e.getStatus());
        }
    }
}

