/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.base;

import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.base.SailDataset;
import org.eclipse.rdf4j.sail.base.SailSink;
import org.eclipse.rdf4j.sail.base.SailSource;
import org.eclipse.rdf4j.sail.base.UnionSailDataset;

class UnionSailSource
implements SailSource {
    private final SailSource primary;
    private final SailSource additional;

    public UnionSailSource(SailSource primary, SailSource additional) {
        this.primary = primary;
        this.additional = additional;
    }

    public String toString() {
        return this.primary.toString() + "\n" + this.additional.toString();
    }

    @Override
    public void close() throws SailException {
        try {
            this.primary.close();
        }
        finally {
            this.additional.close();
        }
    }

    @Override
    public SailSource fork() {
        return new UnionSailSource(this.primary.fork(), this.additional.fork());
    }

    @Override
    public void prepare() throws SailException {
        this.primary.prepare();
        this.additional.prepare();
    }

    @Override
    public void flush() throws SailException {
        this.primary.flush();
        this.additional.flush();
    }

    @Override
    public SailSink sink(IsolationLevel level) throws SailException {
        return this.primary.sink(level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SailDataset dataset(IsolationLevel level) throws SailException {
        SailDataset primaryDataset = null;
        SailDataset additionalDataset = null;
        try {
            primaryDataset = this.primary.dataset(level);
            additionalDataset = this.additional.dataset(level);
            return UnionSailDataset.getInstance(primaryDataset, additionalDataset);
        }
        catch (Throwable t) {
            try {
                if (primaryDataset != null) {
                    primaryDataset.close();
                }
            }
            finally {
                if (additionalDataset != null) {
                    additionalDataset.close();
                }
            }
            throw t;
        }
    }
}

