/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.r_osgi;

import ch.ethz.iks.r_osgi.RemoteOSGiException;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.core.util.reflection.ClassUtil;
import org.eclipse.ecf.internal.provider.r_osgi.Activator;
import org.eclipse.ecf.internal.provider.r_osgi.RemoteServiceReferenceImpl;
import org.eclipse.ecf.remoteservice.AbstractRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.IRemoteCallListener;
import org.eclipse.ecf.remoteservice.IRemoteServiceID;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.events.IRemoteCallCompleteEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteCallEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteCallStartEvent;
import org.eclipse.equinox.concurrent.future.IExecutor;
import org.eclipse.equinox.concurrent.future.IFuture;
import org.eclipse.equinox.concurrent.future.IProgressRunnable;
import org.eclipse.equinox.concurrent.future.ImmediateExecutor;
import org.eclipse.equinox.concurrent.future.ThreadsExecutor;
import org.eclipse.equinox.concurrent.future.TimeoutException;

final class RemoteServiceImpl
extends AbstractRemoteService {
    RemoteServiceReferenceImpl refImpl;
    Object service;
    private long nextID;
    private IExecutor asyncExecutor;
    private IExecutor syncExecutor;
    private final Object executorLock = new Object();

    public RemoteServiceImpl(RemoteServiceReferenceImpl refImpl, Object service) {
        this.refImpl = refImpl;
        this.service = service;
    }

    protected IRemoteServiceID getRemoteServiceID() {
        return this.refImpl.getID();
    }

    protected IRemoteServiceReference getRemoteServiceReference() {
        return this.refImpl;
    }

    protected String[] getInterfaceClassNames() {
        return this.refImpl.getR_OSGiServiceReference().getServiceInterfaces();
    }

    public void callAsync(IRemoteCall call, IRemoteCallListener listener) {
        new AsyncResult(call, listener).start();
    }

    public IFuture callAsync(final IRemoteCall call) {
        return this.getAsyncExecutor().execute(new IProgressRunnable(){

            public Object run(IProgressMonitor monitor) throws Exception {
                return RemoteServiceImpl.this.callSync(call);
            }
        }, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IExecutor getAsyncExecutor() {
        Object object = this.executorLock;
        synchronized (object) {
            if (this.asyncExecutor == null) {
                IExecutor executor = Activator.getDefault().getExecutor(false);
                this.asyncExecutor = executor == null ? new ThreadsExecutor() : executor;
            }
            return this.asyncExecutor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IExecutor getSyncExecutor() {
        Object object = this.executorLock;
        synchronized (object) {
            if (this.syncExecutor == null) {
                IExecutor executor = Activator.getDefault().getExecutor(true);
                this.syncExecutor = executor == null ? new ImmediateExecutor() : executor;
            }
            return this.syncExecutor;
        }
    }

    public Object callSync(final IRemoteCall call) throws ECFException {
        Object[] ps = call.getParameters();
        final Object[] parameters = ps == null ? EMPTY_ARGS : ps;
        final Class[] formalParams = new Class[parameters.length];
        int i = 0;
        while (i < formalParams.length) {
            formalParams[i] = call.getParameters()[i].getClass();
            ++i;
        }
        IFuture future = this.getSyncExecutor().execute(new IProgressRunnable(){

            public Object run(IProgressMonitor monitor) throws Exception {
                Method method = ClassUtil.getMethod(RemoteServiceImpl.this.service.getClass(), (String)call.getMethod(), (Class[])formalParams);
                return method.invoke(RemoteServiceImpl.this.service, parameters);
            }
        }, null);
        Object result = null;
        try {
            result = future.get(call.getTimeout());
        }
        catch (OperationCanceledException e) {
            throw new ECFException("callSync cancelled", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new ECFException("callSync interrupted ", (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new ECFException("callSync timed out after " + Long.toString(call.getTimeout()) + "ms", (Throwable)new TimeoutException(call.getTimeout()));
        }
        IStatus status = future.getStatus();
        if (!status.isOK()) {
            throw new ECFException("Exception during callSync", status.getException());
        }
        return result;
    }

    public void fireAsync(IRemoteCall call) throws ECFException {
        try {
            this.callAsync(call);
        }
        catch (RemoteOSGiException r) {
            throw new ECFException((Throwable)r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Object getProxy() throws ECFException {
        if (!this.refImpl.getR_OSGiServiceReference().isActive()) {
            throw new ECFException("Container currently not connected");
        }
        return super.getProxy();
    }

    synchronized long getNextID() {
        return this.nextID++;
    }

    private class AsyncResult
    extends Thread {
        Object result;
        Throwable exception;
        IRemoteCall call;
        private IRemoteCallListener listener;

        AsyncResult(IRemoteCall call, IRemoteCallListener listener) {
            this.call = call;
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object r = null;
            Throwable e = null;
            final long reqID = RemoteServiceImpl.this.getNextID();
            if (this.listener != null) {
                this.listener.handleEvent((IRemoteCallEvent)new IRemoteCallStartEvent(){

                    public IRemoteCall getCall() {
                        return AsyncResult.this.call;
                    }

                    public IRemoteServiceReference getReference() {
                        return ((AsyncResult)AsyncResult.this).RemoteServiceImpl.this.refImpl;
                    }

                    public long getRequestId() {
                        return reqID;
                    }
                });
            }
            try {
                r = RemoteServiceImpl.this.callSync(this.call);
            }
            catch (Throwable t) {
                e = t;
            }
            AsyncResult asyncResult = this;
            synchronized (asyncResult) {
                this.result = r;
                this.exception = e;
                this.notify();
            }
            if (this.listener != null) {
                this.listener.handleEvent((IRemoteCallEvent)new IRemoteCallCompleteEvent(){

                    public Throwable getException() {
                        return AsyncResult.this.exception;
                    }

                    public Object getResponse() {
                        return AsyncResult.this.result;
                    }

                    public boolean hadException() {
                        return AsyncResult.this.exception != null;
                    }

                    public long getRequestId() {
                        return reqID;
                    }
                });
            }
        }
    }
}

