/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.synchronizer;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.synchronizer.CreatedOutput;
import org.eclipse.sirius.synchronizer.Mapping;
import org.eclipse.sirius.synchronizer.OutputDescriptor;
import org.eclipse.sirius.synchronizer.Signature;
import org.eclipse.sirius.synchronizer.SignatureProvider;

public class RefreshPlan {
    private SignatureProvider signatureProvider;
    private Map<Signature, OutputDescriptor> outputToCreate = new LinkedHashMap<Signature, OutputDescriptor>();
    private Map<Signature, CreatedOutput> outputToRefresh = new LinkedHashMap<Signature, CreatedOutput>();
    private Map<Signature, CreatedOutput> outputToUpdateMapping;
    private Multimap<Signature, CreatedOutput> outputToRemove = HashMultimap.create();

    public RefreshPlan(SignatureProvider signProvider) {
        this.outputToUpdateMapping = new HashMap<Signature, CreatedOutput>();
        this.signatureProvider = signProvider;
    }

    public Collection<CreatedOutput> getDescriptorToUpdateMapping() {
        return this.outputToUpdateMapping.values();
    }

    public void addPreviousStatus(Iterable<? extends CreatedOutput> pre) {
        for (CreatedOutput createdOutput : pre) {
            this.shouldBeRemoved(createdOutput);
        }
    }

    private void shouldBeRemoved(CreatedOutput desc) {
        this.outputToRemove.put((Object)this.signatureProvider.getSignature(desc.getDescriptor()), (Object)desc);
    }

    public void appendOutputDescritorsKeepingTheMostSpecific(Collection<? extends OutputDescriptor> computeDescriptors) {
        for (OutputDescriptor outputDescriptor : computeDescriptors) {
            Option<CreatedOutput> wasHere = this.getDescriptorAlreadyHereWeWantToKeep(outputDescriptor);
            if (wasHere.some()) {
                if (((CreatedOutput)wasHere.get()).getDescriptor().getIndex() != outputDescriptor.getIndex()) {
                    this.shouldBeReordered((CreatedOutput)wasHere.get(), outputDescriptor.getIndex());
                }
                if (((CreatedOutput)wasHere.get()).getDescriptor().getMapping() != outputDescriptor.getMapping()) {
                    this.shouldUpdateTheMapping((CreatedOutput)wasHere.get(), outputDescriptor.getMapping());
                }
                this.shouldBeRefreshed((CreatedOutput)wasHere.get());
                continue;
            }
            this.shouldBeCreated(outputDescriptor);
        }
    }

    private void shouldUpdateTheMapping(CreatedOutput createdOutput, Mapping mapping) {
        createdOutput.setNewMapping(mapping);
        Signature signature = this.signatureProvider.getSignature(createdOutput.getDescriptor());
        this.outputToUpdateMapping.put(signature, createdOutput);
    }

    private void shouldBeCreated(OutputDescriptor newDescriptor) {
        Signature signature = this.signatureProvider.getSignature(newDescriptor);
        if (!this.outputToCreate.containsKey(signature) && !this.outputToRefresh.containsKey(signature)) {
            this.outputToCreate.put(signature, newDescriptor);
        }
    }

    private void shouldBeRefreshed(CreatedOutput outputDescriptor) {
        Signature signature = this.signatureProvider.getSignature(outputDescriptor.getDescriptor());
        Option<CreatedOutput> element = this.getDescriptorAlreadyHereWeWantToKeep(outputDescriptor.getDescriptor());
        if (element.some()) {
            this.outputToRemove.remove((Object)signature, element.get());
            if (!this.outputToRefresh.containsKey(signature)) {
                this.outputToRefresh.put(signature, (CreatedOutput)element.get());
            }
        }
    }

    private void shouldBeReordered(CreatedOutput newDescriptor, int nextIndex) {
        newDescriptor.setNewIndex(nextIndex);
    }

    private Option<CreatedOutput> getDescriptorAlreadyHereWeWantToKeep(OutputDescriptor newDescriptor) {
        Collection toRemove = this.outputToRemove.get((Object)this.signatureProvider.getSignature(newDescriptor));
        if (toRemove.size() > 0) {
            return Options.newSome((Object)((CreatedOutput)toRemove.iterator().next()));
        }
        return Options.newNone();
    }

    public Collection<CreatedOutput> getDescriptorsToDelete() {
        return this.outputToRemove.values();
    }

    public Collection<OutputDescriptor> getDescriptorsToCreate() {
        return this.outputToCreate.values();
    }

    public Collection<CreatedOutput> getDescriptorsToRefresh() {
        return this.outputToRefresh.values();
    }
}

