/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.properties.core.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.eef.EEFGroupDescription;
import org.eclipse.eef.EEFPageDescription;
import org.eclipse.eef.EEFViewDescription;
import org.eclipse.eef.EefFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.properties.GroupDescription;
import org.eclipse.sirius.properties.PageDescription;
import org.eclipse.sirius.properties.ViewExtensionDescription;
import org.eclipse.sirius.properties.core.api.IDescriptionLinkResolver;
import org.eclipse.sirius.properties.core.api.SiriusInputDescriptor;
import org.eclipse.sirius.properties.core.api.TransformationCache;
import org.eclipse.sirius.properties.core.internal.SiriusPropertiesCorePlugin;

public class ViewDescriptionConverter {
    private final List<PageDescription> pageDescriptions = new ArrayList<PageDescription>();

    public ViewDescriptionConverter(List<PageDescription> pageDescriptions) {
        this.pageDescriptions.addAll(pageDescriptions);
    }

    public EEFViewDescription convert(SiriusInputDescriptor input) {
        EEFViewDescription view = this.createView();
        TransformationCache cache = new TransformationCache();
        HashMap<String, SiriusInputDescriptor> parameters = new HashMap<String, SiriusInputDescriptor>();
        parameters.put("input", input);
        parameters.put("view", (SiriusInputDescriptor)view);
        this.pageDescriptions.forEach(pageDescription -> this.convertPage(input, view, cache, (PageDescription)pageDescription, (Map<String, Object>)parameters));
        List<IDescriptionLinkResolver> linkResolvers = SiriusPropertiesCorePlugin.getPlugin().getDescriptionConverterLinkResolvers();
        linkResolvers.forEach(linkResolver -> linkResolver.resolve((EObject)view, cache));
        return view;
    }

    private void convertPage(SiriusInputDescriptor input, EEFViewDescription view, TransformationCache cache, PageDescription pageDescription, Map<String, Object> parameters) {
        SiriusPropertiesCorePlugin.getPlugin().getDescriptionConverter((EObject)pageDescription).ifPresent(converter -> {
            EObject eObject = converter.convert((EObject)pageDescription, parameters, cache);
            if (eObject instanceof EEFPageDescription) {
                EEFPageDescription convertedPageDescription = (EEFPageDescription)eObject;
                view.getPages().add((Object)convertedPageDescription);
                for (GroupDescription groupDescription : pageDescription.getGroups()) {
                    this.convertGroup(view, cache, parameters, convertedPageDescription, groupDescription);
                }
            }
        });
    }

    private void convertGroup(EEFViewDescription view, TransformationCache cache, Map<String, Object> parameters, EEFPageDescription convertedPageDescription, GroupDescription groupDescription) {
        if (!cache.getAllInputs().contains(groupDescription)) {
            SiriusPropertiesCorePlugin.getPlugin().getDescriptionConverter((EObject)groupDescription).ifPresent(converter -> {
                EObject group = converter.convert((EObject)groupDescription, parameters, cache);
                if (group instanceof EEFGroupDescription) {
                    view.getGroups().add((Object)((EEFGroupDescription)group));
                    convertedPageDescription.getGroups().add((Object)((EEFGroupDescription)group));
                }
            });
        } else {
            Optional<Object> output = cache.getOutput(groupDescription);
            output.filter(EEFGroupDescription.class::isInstance).map(EEFGroupDescription.class::cast).ifPresent(eefGroupDescription -> convertedPageDescription.getGroups().add(eefGroupDescription));
        }
    }

    private EEFViewDescription createView() {
        EEFViewDescription view = EefFactory.eINSTANCE.createEEFViewDescription();
        view.setLabelExpression("aql:input.emfEditServices(self).getText()");
        view.setImageExpression("aql:input.emfEditServices(self).getImage()");
        LinkedHashSet ePackages = new LinkedHashSet();
        this.pageDescriptions.stream().map(EObject::eContainer).forEach(eContainer -> {
            if (eContainer instanceof ViewExtensionDescription) {
                ViewExtensionDescription viewExtensionDescription = (ViewExtensionDescription)eContainer;
                ePackages.addAll(viewExtensionDescription.getMetamodels());
            }
        });
        view.getEPackages().addAll(ePackages);
        return view;
    }
}

