/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.disco.transform;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.util.ElkGraphUtil;
import org.eclipse.emf.common.util.EList;

public final class ElkGraphComponentsProcessor {
    private static List<ElkNode> visited = Lists.newArrayList();
    private static Map<ElkNode, Set<ElkNode>> incidenceMap = Maps.newHashMap();
    private static List<List<ElkNode>> components = Lists.newArrayList();

    private ElkGraphComponentsProcessor() {
    }

    public static List<List<ElkNode>> split(ElkNode graph) {
        visited = Lists.newArrayList();
        incidenceMap = Maps.newHashMap();
        components = Lists.newArrayList();
        EList children = graph.getChildren();
        ElkGraphComponentsProcessor.computeIncidences(children);
        for (ElkNode node : children) {
            if (visited.contains(node)) continue;
            ArrayList component = Lists.newArrayList();
            components.add(component);
            ElkGraphComponentsProcessor.dfs(node, component);
        }
        return components;
    }

    private static <C extends Collection<ElkNode>> void computeIncidences(C nodes) {
        HashMap adjacentAndInsideParent = Maps.newHashMap();
        for (ElkNode node : nodes) {
            Set<ElkNode> nodesAtPort;
            ElkPort port;
            HashSet adjacentNodes = Sets.newHashSet();
            incidenceMap.put(node, adjacentNodes);
            Predicate<ElkEdge> sameHierarchyLevel = edge -> ElkGraphUtil.getSourceNode((ElkEdge)edge).getParent().equals(ElkGraphUtil.getTargetNode((ElkEdge)edge).getParent());
            Map<Boolean, List<ElkEdge>> edges = StreamSupport.stream(ElkGraphUtil.allIncomingEdges((ElkNode)node).spliterator(), true).collect(Collectors.partitioningBy(sameHierarchyLevel));
            ElkGraphComponentsProcessor.addNodesToIncidenceSet(adjacentNodes, (Collection<ElkEdge>)edges.get(true), edge -> ElkGraphUtil.getSourceNode((ElkEdge)edge));
            List connectedToParentPort = edges.get(false).parallelStream().filter(edge -> ElkGraphUtil.getSourceNode((ElkEdge)edge).equals(ElkGraphUtil.getTargetNode((ElkEdge)edge).getParent())).collect(Collectors.toList());
            for (ElkEdge incomingEdge : connectedToParentPort) {
                port = ElkGraphUtil.getSourcePort((ElkEdge)incomingEdge);
                if (port == null) continue;
                nodesAtPort = (Set<ElkNode>)adjacentAndInsideParent.get(port);
                if (nodesAtPort == null) {
                    nodesAtPort = ElkGraphComponentsProcessor.getInnerNeighborsOfPort(port);
                    adjacentAndInsideParent.put(port, nodesAtPort);
                }
                adjacentNodes.addAll(nodesAtPort);
            }
            edges = StreamSupport.stream(ElkGraphUtil.allOutgoingEdges((ElkNode)node).spliterator(), true).collect(Collectors.partitioningBy(sameHierarchyLevel));
            ElkGraphComponentsProcessor.addNodesToIncidenceSet(adjacentNodes, (Collection<ElkEdge>)edges.get(true), edge -> ElkGraphUtil.getTargetNode((ElkEdge)edge));
            connectedToParentPort = edges.get(false).parallelStream().filter(edge -> ElkGraphUtil.getTargetNode((ElkEdge)edge).equals(ElkGraphUtil.getSourceNode((ElkEdge)edge).getParent())).collect(Collectors.toList());
            for (ElkEdge outgoingEdge : connectedToParentPort) {
                port = ElkGraphUtil.getTargetPort((ElkEdge)outgoingEdge);
                if (port == null) continue;
                nodesAtPort = (Set<ElkNode>)adjacentAndInsideParent.get(port);
                if (nodesAtPort == null) {
                    nodesAtPort = ElkGraphComponentsProcessor.getInnerNeighborsOfPort(port);
                    adjacentAndInsideParent.put(port, nodesAtPort);
                }
                adjacentNodes.addAll(nodesAtPort);
            }
        }
    }

    private static Set<ElkNode> getInnerNeighborsOfPort(ElkPort port) {
        ElkNode portParent = port.getParent();
        Predicate<ElkEdge> inwardsPredicate = edge -> portParent.equals(ElkGraphUtil.getSourceNode((ElkEdge)edge).getParent()) || portParent.equals(ElkGraphUtil.getTargetNode((ElkEdge)edge).getParent());
        Function<ElkEdge, ElkNode> nodeMapper = edge -> portParent.equals(ElkGraphUtil.getSourceNode((ElkEdge)edge)) ? ElkGraphUtil.getTargetNode((ElkEdge)edge) : ElkGraphUtil.getSourceNode((ElkEdge)edge);
        ArrayList allEdges = Lists.newArrayList();
        allEdges.addAll(port.getIncomingEdges());
        allEdges.addAll(port.getOutgoingEdges());
        return allEdges.parallelStream().filter(inwardsPredicate).map(nodeMapper).collect(Collectors.toSet());
    }

    private static void addNodesToIncidenceSet(Set<ElkNode> incidentNodes, Collection<ElkEdge> edges, Function<ElkEdge, ElkNode> chooseNode) {
        for (ElkEdge edge : edges) {
            incidentNodes.add(chooseNode.apply(edge));
        }
    }

    private static void dfs(ElkNode start, List<ElkNode> component) {
        visited.add(start);
        component.add(start);
        Set<ElkNode> adjacentNodes = incidenceMap.get(start);
        if (adjacentNodes != null) {
            for (ElkNode node : adjacentNodes) {
                if (visited.contains(node)) continue;
                ElkGraphComponentsProcessor.dfs(node, component);
            }
        }
    }
}

