/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.internal.part;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderedShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayServiceManager;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.business.internal.view.LayoutData;
import org.eclipse.sirius.diagram.ui.internal.refresh.borderednode.CanonicalDBorderItemLocator;
import org.eclipse.sirius.diagram.ui.internal.view.factories.ViewLocationHint;
import org.eclipse.sirius.diagram.ui.internal.view.factories.ViewSizeHint;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IBorderItemOffsets;
import org.eclipse.sirius.diagram.ui.tools.api.layout.LayoutUtils;

public final class PortLayoutHelper {
    private PortLayoutHelper() {
    }

    protected static Rectangle getDefaultBounds(IBorderedShapeEditPart parentEditPart, DNode portNode, CreateViewRequest.ViewDescriptor viewDescriptor) {
        Dimension size = ViewSizeHint.getInstance().consumeSize();
        Point location = null;
        if (DisplayServiceManager.INSTANCE.getDisplayService().isDisplayed(portNode.getParentDiagram(), (DDiagramElement)portNode)) {
            location = ViewLocationHint.getInstance().consumeLocation(parentEditPart);
        }
        if (size == null) {
            size = LayoutUtils.getDefaultDimension(viewDescriptor);
        }
        if (location == null) {
            location = new Point(0, 0);
        }
        return new Rectangle(location, size);
    }

    public static Rectangle getBounds(IBorderedShapeEditPart parentEditPart, DNode portNode, CreateViewRequest.ViewDescriptor viewDescriptor, DDiagramElement container) {
        Rectangle finalBounds = null;
        LayoutData layoutData = SiriusLayoutDataManager.INSTANCE.getData((AbstractDNode)portNode);
        if (layoutData == null) {
            layoutData = SiriusLayoutDataManager.INSTANCE.getData((AbstractDNode)portNode, true);
            Rectangle tempBounds = layoutData != null ? PortLayoutHelper.completeLayoutData(layoutData, viewDescriptor) : PortLayoutHelper.getDefaultBounds(parentEditPart, portNode, viewDescriptor);
            finalBounds = new Rectangle(LayoutUtils.getValidLocation((DDiagramElement)portNode, tempBounds.getLocation(), tempBounds.getSize(), container, parentEditPart.getBorderedFigure().getBorderItemContainer(), parentEditPart.getMainFigure()));
        } else {
            finalBounds = PortLayoutHelper.completeLayoutData(layoutData, viewDescriptor);
        }
        return finalBounds;
    }

    public static Rectangle getUncollapseCandidateLocation(Dimension expandedDim, Rectangle collapsedBounds, Rectangle parentBorder) {
        Rectangle suggestedBounds = new Rectangle(collapsedBounds.x - (expandedDim.width - collapsedBounds.width) / 2, collapsedBounds.y - (expandedDim.height - collapsedBounds.height) / 2, expandedDim.width, expandedDim.height);
        if (parentBorder != null) {
            int side = CanonicalDBorderItemLocator.findClosestSideOfParent(suggestedBounds, parentBorder);
            suggestedBounds = PortLayoutHelper.getCorrectLocationOnParentForExpand(suggestedBounds, collapsedBounds, side, IBorderItemOffsets.COLLAPSE_FILTER_OFFSET, IBorderItemOffsets.DEFAULT_OFFSET);
        }
        return suggestedBounds;
    }

    public static Rectangle getCollapseCandidateLocation(Dimension collapsedDim, Rectangle expandedBounds, Rectangle parentBorder) {
        Rectangle suggestedBounds = new Rectangle(expandedBounds.x + (expandedBounds.width - collapsedDim.width) / 2, expandedBounds.y + (expandedBounds.height - collapsedDim.height) / 2, collapsedDim.width, collapsedDim.height);
        if (parentBorder != null) {
            int side = CanonicalDBorderItemLocator.findClosestSideOfParent(suggestedBounds, parentBorder);
            suggestedBounds = PortLayoutHelper.getCorrectLocationOnParentForCollapse(suggestedBounds, expandedBounds, side, IBorderItemOffsets.COLLAPSE_FILTER_OFFSET, IBorderItemOffsets.DEFAULT_OFFSET);
        }
        return suggestedBounds;
    }

    private static Rectangle getCorrectLocationOnParentForExpand(Rectangle suggestedExpandedBounds, Rectangle currentBounds, int side, Dimension collapsedOffset, Dimension expandedOffset) {
        Rectangle correctLocation = new Rectangle(suggestedExpandedBounds);
        switch (side) {
            case 8: {
                correctLocation.setX(currentBounds.x - (collapsedOffset.width - currentBounds.width) - (suggestedExpandedBounds.width - expandedOffset.width));
                break;
            }
            case 16: {
                correctLocation.setX(currentBounds.x - (expandedOffset.width - collapsedOffset.width));
                break;
            }
            case 4: {
                correctLocation.setY(currentBounds.y - (expandedOffset.height - collapsedOffset.height));
                break;
            }
            case 1: {
                correctLocation.setY(currentBounds.y - (collapsedOffset.height - currentBounds.height) - (suggestedExpandedBounds.height - expandedOffset.height));
                break;
            }
        }
        return correctLocation;
    }

    private static Rectangle getCorrectLocationOnParentForCollapse(Rectangle suggestedCollapsedBounds, Rectangle currentBounds, int side, Dimension collapsedOffset, Dimension expandedOffset) {
        Rectangle correctLocation = new Rectangle(suggestedCollapsedBounds);
        switch (side) {
            case 8: {
                correctLocation.setX(currentBounds.x + currentBounds.width - suggestedCollapsedBounds.width - (expandedOffset.width - collapsedOffset.width));
                break;
            }
            case 16: {
                correctLocation.setX(currentBounds.x + (expandedOffset.width - collapsedOffset.width));
                break;
            }
            case 4: {
                correctLocation.setY(currentBounds.y + (expandedOffset.height - collapsedOffset.height));
                break;
            }
            case 1: {
                correctLocation.setY(currentBounds.y + currentBounds.height - suggestedCollapsedBounds.height - (expandedOffset.height - collapsedOffset.height));
                break;
            }
        }
        return correctLocation;
    }

    private static Rectangle completeLayoutData(LayoutData layoutData, CreateViewRequest.ViewDescriptor viewDescriptor) {
        Point location = layoutData.getLocation() != null ? layoutData.getLocation() : new Point(0, 0);
        Dimension size = layoutData.getSize() != null ? layoutData.getSize() : LayoutUtils.getDefaultDimension(viewDescriptor);
        return new Rectangle(location, size);
    }
}

