/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.format;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.tools.internal.SiriusCopierHelper;
import org.eclipse.sirius.viewpoint.Style;

public final class SiriusStyleClipboard {
    private static final SiriusStyleClipboard INSTANCE = new SiriusStyleClipboard();
    private Optional<View> gmfView = Optional.empty();
    private Optional<Style> siriusStyle = Optional.empty();
    private List<Listener> listeners = new ArrayList<Listener>();

    private SiriusStyleClipboard() {
    }

    public void clear() {
        this.gmfView = Optional.empty();
        this.siriusStyle = Optional.empty();
        this.notifyListener();
    }

    public void store(View newGmfView, Style newSiriusStyle) {
        View copiedGmfView = (View)SiriusCopierHelper.copyWithNoUidDuplication((EObject)newGmfView);
        copiedGmfView.setElement(null);
        this.gmfView = Optional.of(copiedGmfView);
        this.siriusStyle = Optional.of((Style)SiriusCopierHelper.copyWithNoUidDuplication((EObject)newSiriusStyle));
        this.notifyListener();
    }

    public Optional<View> getGmfView() {
        return this.gmfView;
    }

    public Optional<Style> getSiriusStyle() {
        return this.siriusStyle;
    }

    public void addListener(Listener onChangeClipboard) {
        this.listeners.add(Objects.requireNonNull(onChangeClipboard));
    }

    public void removeListener(Listener onChangeClipboard) {
        this.listeners.remove(onChangeClipboard);
    }

    private void notifyListener() {
        for (Listener listener : this.listeners) {
            listener.onChangeData(this.gmfView, this.siriusStyle);
        }
    }

    public static SiriusStyleClipboard getInstance() {
        return INSTANCE;
    }

    @FunctionalInterface
    public static interface Listener {
        public void onChangeData(Optional<View> var1, Optional<Style> var2);
    }
}

