/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.actions.export;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.query.DRepresentationDescriptorQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.dialect.ExportFormat;
import org.eclipse.sirius.ui.tools.internal.actions.export.AbstractExportRepresentationsAction;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ExportRepresentationsAction
extends AbstractExportRepresentationsAction {
    private final Session session;
    private Collection<EObject> selectedEObjects;
    private Collection<DRepresentationDescriptor> selectedRepDescriptors;

    public ExportRepresentationsAction(Session session, Collection<EObject> selectedEObjects, Collection<DRepresentationDescriptor> selectedRepDescriptors) {
        super(Messages.ExportRepresentationsAction_label, AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/others/image.gif"));
        this.session = session;
        this.selectedEObjects = selectedEObjects;
        this.selectedRepDescriptors = selectedRepDescriptors;
    }

    @Override
    protected Collection<DRepresentationDescriptor> getRepresentationToExport() {
        LinkedHashSet<DRepresentationDescriptor> dRepDescriptorsToExport = new LinkedHashSet<DRepresentationDescriptor>(this.selectedRepDescriptors);
        if (dRepDescriptorsToExport.isEmpty()) {
            dRepDescriptorsToExport.addAll(this.computeAllRepresentationsUnderSemantic());
        }
        return dRepDescriptorsToExport.stream().filter(repDesc -> new DRepresentationDescriptorQuery(repDesc).isRepresentationValid()).filter(repDesc -> DialectUIManager.INSTANCE.canExport((DRepresentationDescriptor)repDesc, new ExportFormat(ExportFormat.ExportDocumentFormat.NONE, null))).collect(Collectors.toSet());
    }

    @Override
    protected Session getSession(DRepresentationDescriptor repDescriptor) {
        return this.session;
    }

    private Collection<DRepresentationDescriptor> computeAllRepresentationsUnderSemantic() {
        LinkedHashSet<DRepresentationDescriptor> result = new LinkedHashSet<DRepresentationDescriptor>();
        for (EObject eObject : this.selectedEObjects) {
            result.addAll(DialectManager.INSTANCE.getRepresentationDescriptors(eObject, this.session));
            TreeIterator iter = eObject.eAllContents();
            while (iter.hasNext()) {
                EObject child = (EObject)iter.next();
                result.addAll(DialectManager.INSTANCE.getRepresentationDescriptors(child, this.session));
            }
        }
        return result;
    }
}

