/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.serial;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.UncheckedIOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class SerialObjectBuilder {
    private final ObjectOutputStream objectOutputStream;
    private final ByteArrayOutputStream byteArrayOutputStream;
    private String className;
    private long suid;
    private SerialObjectBuilder superClass;
    private final LinkedHashMap<NameAndType<?>, Object> primFields = new LinkedHashMap();
    private final LinkedHashMap<NameAndType<?>, Object> objectFields = new LinkedHashMap();

    private SerialObjectBuilder() {
        try {
            this.byteArrayOutputStream = new ByteArrayOutputStream();
            this.objectOutputStream = new ObjectOutputStream(this.byteArrayOutputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static SerialObjectBuilder newBuilder(String className) {
        return new SerialObjectBuilder().className(className);
    }

    private SerialObjectBuilder className(String className) {
        this.className = className;
        return this;
    }

    public SerialObjectBuilder suid(long suid) {
        this.suid = suid;
        return this;
    }

    public SerialObjectBuilder superClass(SerialObjectBuilder superClass) {
        this.superClass = superClass;
        return this;
    }

    public <T> SerialObjectBuilder addPrimitiveField(String name, Class<T> type, T value) {
        if (!type.isPrimitive()) {
            throw new IllegalArgumentException("Unexpected non-primitive field: " + String.valueOf(type));
        }
        this.primFields.put(new NameAndType<T>(name, type), value);
        return this;
    }

    public <T> SerialObjectBuilder addField(String name, Class<T> type, T value) {
        if (type.isPrimitive()) {
            throw new IllegalArgumentException("Unexpected primitive field: " + String.valueOf(type));
        }
        this.objectFields.put(new NameAndType<T>(name, type), value);
        return this;
    }

    private static void writeUTF(DataOutputStream out, String str) throws IOException {
        assert (str.codePoints().noneMatch(cp -> cp > 127));
        int utflen = str.length();
        assert (utflen <= 65535);
        out.writeShort(utflen);
        out.writeBytes(str);
    }

    private void writePrimFieldsDesc(DataOutputStream out) throws IOException {
        for (Map.Entry<NameAndType<?>, Object> entry : this.primFields.entrySet()) {
            Class<?> primClass = entry.getKey().type();
            assert (primClass.isPrimitive());
            assert (primClass != Void.TYPE);
            out.writeByte(primClass.descriptorString().getBytes()[0]);
            out.writeUTF(entry.getKey().name());
        }
    }

    private void writePrimFieldsValues(DataOutputStream out) throws IOException {
        for (Map.Entry<NameAndType<?>, Object> entry : this.primFields.entrySet()) {
            Class<?> cl = entry.getKey().type();
            Object value = entry.getValue();
            if (cl == Integer.TYPE) {
                out.writeInt((Integer)value);
                continue;
            }
            if (cl == Byte.TYPE) {
                out.writeByte(((Byte)value).byteValue());
                continue;
            }
            if (cl == Long.TYPE) {
                out.writeLong((Long)value);
                continue;
            }
            if (cl == Float.TYPE) {
                out.writeFloat(((Float)value).floatValue());
                continue;
            }
            if (cl == Double.TYPE) {
                out.writeDouble((Double)value);
                continue;
            }
            if (cl == Short.TYPE) {
                out.writeShort(((Short)value).shortValue());
                continue;
            }
            if (cl == Character.TYPE) {
                out.writeChar(((Character)value).charValue());
                continue;
            }
            if (cl == Boolean.TYPE) {
                out.writeBoolean((Boolean)value);
                continue;
            }
            throw new InternalError();
        }
    }

    private void writeObjectFieldDesc(DataOutputStream out) throws IOException {
        for (Map.Entry<NameAndType<?>, Object> entry : this.objectFields.entrySet()) {
            Class<?> cl = entry.getKey().type();
            assert (!cl.isPrimitive());
            if (cl.isArray()) {
                out.writeByte(91);
            } else {
                out.writeByte(76);
            }
            SerialObjectBuilder.writeUTF(out, entry.getKey().name());
            out.writeByte(116);
            SerialObjectBuilder.writeUTF(out, cl.descriptorString());
        }
    }

    private void writeObject(DataOutputStream out, Object value) throws IOException {
        this.objectOutputStream.reset();
        this.byteArrayOutputStream.reset();
        this.objectOutputStream.writeUnshared(value);
        out.write(this.byteArrayOutputStream.toByteArray());
    }

    private void writeObjectFieldValues(DataOutputStream out) throws IOException {
        for (Map.Entry<NameAndType<?>, Object> entry : this.objectFields.entrySet()) {
            Class<?> cl = entry.getKey().type();
            assert (!cl.isPrimitive());
            if (cl == String.class) {
                out.writeByte(116);
                SerialObjectBuilder.writeUTF(out, (String)entry.getValue());
                continue;
            }
            this.writeObject(out, entry.getValue());
        }
    }

    private int numFields() {
        return this.primFields.size() + this.objectFields.size();
    }

    private static void writeClassDesc(DataOutputStream dos, SerialObjectBuilder sb) throws IOException {
        dos.writeByte(114);
        dos.writeUTF(sb.className);
        dos.writeLong(sb.suid);
        dos.writeByte(2);
        dos.writeShort(sb.numFields());
        sb.writePrimFieldsDesc(dos);
        sb.writeObjectFieldDesc(dos);
        dos.writeByte(120);
        if (sb.superClass == null) {
            dos.writeByte(112);
        } else {
            SerialObjectBuilder.writeClassDesc(dos, sb.superClass);
        }
    }

    public byte[] build() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeShort(-21267);
            dos.writeShort(5);
            dos.writeByte(115);
            SerialObjectBuilder.writeClassDesc(dos, this);
            if (this.superClass != null) {
                this.superClass.writePrimFieldsValues(dos);
                this.superClass.writeObjectFieldValues(dos);
            }
            this.writePrimFieldsValues(dos);
            this.writeObjectFieldValues(dos);
            dos.close();
            return baos.toByteArray();
        }
        catch (IOException unexpected) {
            throw new AssertionError((Object)unexpected);
        }
    }

    private record NameAndType<T>(String name, Class<T> type) {
    }
}

