/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.Extension;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.util.SignatureUtil;
import sun.security.x509.AccessDescription;
import sun.security.x509.AlgorithmId;
import sun.security.x509.AuthorityInfoAccessExtension;
import sun.security.x509.AuthorityKeyIdentifierExtension;
import sun.security.x509.BasicConstraintsExtension;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.DNSName;
import sun.security.x509.ExtendedKeyUsageExtension;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNames;
import sun.security.x509.KeyIdentifier;
import sun.security.x509.KeyUsageExtension;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.SubjectKeyIdentifierExtension;
import sun.security.x509.URIName;
import sun.security.x509.X500Name;

public class CertificateBuilder {
    private final CertificateFactory factory;
    private X500Name subjectName = null;
    private BigInteger serialNumber = null;
    private PublicKey publicKey = null;
    private Date notBefore = null;
    private Date notAfter = null;
    private final Map<String, Extension> extensions = new HashMap<String, Extension>();
    private byte[] tbsCertBytes;
    private byte[] signatureBytes;

    public CertificateBuilder() throws CertificateException {
        this.factory = CertificateFactory.getInstance("X.509");
    }

    public CertificateBuilder setSubjectName(X500Principal name) {
        this.subjectName = X500Name.asX500Name(name);
        return this;
    }

    public CertificateBuilder setSubjectName(String name) {
        try {
            this.subjectName = new X500Name(name);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe);
        }
        return this;
    }

    public CertificateBuilder setSubjectName(X500Name name) {
        this.subjectName = name;
        return this;
    }

    public CertificateBuilder setPublicKey(PublicKey pubKey) {
        this.publicKey = Objects.requireNonNull(pubKey, "Caught null public key");
        return this;
    }

    public CertificateBuilder setNotBefore(Date nbDate) {
        Objects.requireNonNull(nbDate, "Caught null notBefore date");
        this.notBefore = (Date)nbDate.clone();
        return this;
    }

    public CertificateBuilder setNotAfter(Date naDate) {
        Objects.requireNonNull(naDate, "Caught null notAfter date");
        this.notAfter = (Date)naDate.clone();
        return this;
    }

    public CertificateBuilder setValidity(Date nbDate, Date naDate) {
        return this.setNotBefore(nbDate).setNotAfter(naDate);
    }

    public CertificateBuilder setSerialNumber(BigInteger serial) {
        Objects.requireNonNull(serial, "Caught null serial number");
        this.serialNumber = serial;
        return this;
    }

    public CertificateBuilder addExtension(Extension ext) {
        Objects.requireNonNull(ext, "Caught null extension");
        this.extensions.put(ext.getId(), ext);
        return this;
    }

    public CertificateBuilder addExtensions(List<Extension> extList) {
        Objects.requireNonNull(extList, "Caught null extension list");
        for (Extension ext : extList) {
            this.extensions.put(ext.getId(), ext);
        }
        return this;
    }

    public CertificateBuilder addSubjectAltNameDNSExt(List<String> dnsNames) throws IOException {
        if (!dnsNames.isEmpty()) {
            GeneralNames gNames = new GeneralNames();
            for (String name : dnsNames) {
                gNames.add(new GeneralName(new DNSName(name)));
            }
            this.addExtension(new SubjectAlternativeNameExtension((Boolean)false, gNames));
        }
        return this;
    }

    public CertificateBuilder addAIAExt(List<String> locations) throws IOException {
        if (!locations.isEmpty()) {
            ArrayList<AccessDescription> acDescList = new ArrayList<AccessDescription>();
            for (String loc : locations) {
                String uriLoc;
                ObjectIdentifier adObj;
                String[] tokens = loc.split("\\|", 2);
                if (tokens.length == 1) {
                    adObj = AccessDescription.Ad_OCSP_Id;
                    uriLoc = tokens[0];
                } else {
                    switch (tokens[0].toUpperCase()) {
                        case "OCSP": {
                            adObj = AccessDescription.Ad_OCSP_Id;
                            break;
                        }
                        case "CAISSUER": {
                            adObj = AccessDescription.Ad_CAISSUERS_Id;
                            break;
                        }
                        default: {
                            throw new IOException("Unknown AD: " + tokens[0]);
                        }
                    }
                    uriLoc = tokens[1];
                }
                acDescList.add(new AccessDescription(adObj, new GeneralName(new URIName(uriLoc))));
            }
            this.addExtension(new AuthorityInfoAccessExtension(acDescList));
        }
        return this;
    }

    public CertificateBuilder addKeyUsageExt(boolean[] bitSettings) {
        return this.addExtension(new KeyUsageExtension(bitSettings));
    }

    public CertificateBuilder addBasicConstraintsExt(boolean crit, boolean isCA, int maxPathLen) {
        return this.addExtension(new BasicConstraintsExtension(crit, isCA, maxPathLen));
    }

    public CertificateBuilder addAuthorityKeyIdExt(X509Certificate authorityCert) throws IOException {
        return this.addAuthorityKeyIdExt(authorityCert.getPublicKey());
    }

    public CertificateBuilder addAuthorityKeyIdExt(PublicKey authorityKey) throws IOException {
        KeyIdentifier kid = new KeyIdentifier(authorityKey);
        return this.addExtension(new AuthorityKeyIdentifierExtension(kid, null, null));
    }

    public CertificateBuilder addSubjectKeyIdExt(PublicKey subjectKey) throws IOException {
        byte[] keyIdBytes = new KeyIdentifier(subjectKey).getIdentifier();
        return this.addExtension(new SubjectKeyIdentifierExtension(keyIdBytes));
    }

    public CertificateBuilder addExtendedKeyUsageExt(List<String> ekuOids) throws IOException {
        if (!ekuOids.isEmpty()) {
            Vector<ObjectIdentifier> oidVector = new Vector<ObjectIdentifier>();
            for (String oid : ekuOids) {
                oidVector.add(ObjectIdentifier.of(oid));
            }
            this.addExtension(new ExtendedKeyUsageExtension(oidVector));
        }
        return this;
    }

    public CertificateBuilder reset() {
        this.extensions.clear();
        this.subjectName = null;
        this.notBefore = null;
        this.notAfter = null;
        this.serialNumber = null;
        this.publicKey = null;
        this.signatureBytes = null;
        this.tbsCertBytes = null;
        return this;
    }

    public X509Certificate build(X509Certificate issuerCert, PrivateKey issuerKey) throws IOException, CertificateException {
        return this.build(issuerCert, issuerKey, SignatureUtil.getDefaultSigAlgForKey(issuerKey));
    }

    public X509Certificate build(X509Certificate issuerCert, PrivateKey issuerKey, String algName) throws IOException, CertificateException {
        byte[] encodedCert = this.encodeTopLevel(issuerCert, issuerKey, algName);
        ByteArrayInputStream bais = new ByteArrayInputStream(encodedCert);
        return (X509Certificate)this.factory.generateCertificate(bais);
    }

    private byte[] encodeTopLevel(X509Certificate issuerCert, PrivateKey issuerKey, String algName) throws CertificateException, IOException {
        AlgorithmId signAlg;
        DerOutputStream outerSeq = new DerOutputStream();
        DerOutputStream topLevelItems = new DerOutputStream();
        try {
            Signature sig = SignatureUtil.fromKey(algName, issuerKey, "");
            signAlg = SignatureUtil.fromSignature(sig, issuerKey);
            this.tbsCertBytes = this.encodeTbsCert(issuerCert, signAlg);
            sig.update(this.tbsCertBytes);
            this.signatureBytes = sig.sign();
        }
        catch (GeneralSecurityException ge) {
            throw new CertificateException(ge);
        }
        topLevelItems.write(this.tbsCertBytes);
        signAlg.encode(topLevelItems);
        topLevelItems.putBitString(this.signatureBytes);
        outerSeq.write((byte)48, topLevelItems);
        return outerSeq.toByteArray();
    }

    private byte[] encodeTbsCert(X509Certificate issuerCert, AlgorithmId signAlg) throws IOException {
        DerOutputStream tbsCertSeq = new DerOutputStream();
        DerOutputStream tbsCertItems = new DerOutputStream();
        if (!this.extensions.isEmpty()) {
            byte[] v3int = new byte[]{2, 1, 2};
            tbsCertItems.write(DerValue.createTag((byte)-128, true, (byte)0), v3int);
        }
        CertificateSerialNumber sn = this.serialNumber != null ? new CertificateSerialNumber(this.serialNumber) : CertificateSerialNumber.newRandom64bit(new SecureRandom());
        sn.encode(tbsCertItems);
        signAlg.encode(tbsCertItems);
        if (issuerCert != null) {
            tbsCertItems.write(issuerCert.getSubjectX500Principal().getEncoded());
        } else {
            tbsCertItems.write(this.subjectName.getEncoded());
        }
        DerOutputStream valSeq = new DerOutputStream();
        Instant now = Instant.now();
        Date startDate = this.notBefore != null ? this.notBefore : Date.from(now);
        valSeq.putUTCTime(startDate);
        Date endDate = this.notAfter != null ? this.notAfter : Date.from(now.plus(90L, ChronoUnit.DAYS));
        valSeq.putUTCTime(endDate);
        tbsCertItems.write((byte)48, valSeq);
        tbsCertItems.write(this.subjectName.getEncoded());
        tbsCertItems.write(this.publicKey.getEncoded());
        this.encodeExtensions(tbsCertItems);
        tbsCertSeq.write((byte)48, tbsCertItems);
        return tbsCertSeq.toByteArray();
    }

    private void encodeExtensions(DerOutputStream tbsStream) throws IOException {
        if (this.extensions.isEmpty()) {
            return;
        }
        DerOutputStream extSequence = new DerOutputStream();
        DerOutputStream extItems = new DerOutputStream();
        for (Extension ext : this.extensions.values()) {
            ext.encode(extItems);
        }
        extSequence.write((byte)48, extItems);
        tbsStream.write(DerValue.createTag((byte)-128, true, (byte)3), extSequence);
    }
}

