/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.containers.cgroup;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import jdk.internal.platform.Metrics;
import jdk.test.lib.containers.cgroup.CgroupMetricsTester;

public class MetricsTesterCgroupV2
implements CgroupMetricsTester {
    private static final long UNLIMITED = -1L;
    private static final long NOT_AVAILABLE = -1L;
    private static final UnifiedController UNIFIED = new UnifiedController();
    private static final String MAX = "max";
    private static final int PER_CPU_SHARES = 1024;
    private final long startSysVal;
    private final long startUserVal;
    private final long startUsage;

    private long getLongLimitValueFromFile(String file) {
        String strVal = this.getStringVal(file);
        if (MAX.equals(strVal)) {
            return -1L;
        }
        return this.convertStringToLong(strVal);
    }

    public MetricsTesterCgroupV2() {
        Metrics metrics = Metrics.systemMetrics();
        this.startSysVal = metrics.getCpuSystemUsage();
        this.startUserVal = metrics.getCpuUserUsage();
        this.startUsage = metrics.getCpuUsage();
    }

    private long getLongValueFromFile(String file) {
        return this.convertStringToLong(this.getStringVal(file));
    }

    private long getLongValueEntryFromFile(String file, String metric) {
        Path filePath = Paths.get(UNIFIED.getPath(), file);
        try {
            String strVal = Files.lines(filePath).filter(l -> l.startsWith(metric)).collect(Collectors.joining());
            if (strVal.isEmpty()) {
                return -1L;
            }
            String[] keyValues = strVal.split("\\s+");
            String value = keyValues[1];
            return this.convertStringToLong(value);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private String getStringVal(String file) {
        Path filePath = Paths.get(UNIFIED.getPath(), file);
        try {
            return Files.lines(filePath).collect(Collectors.joining());
        }
        catch (IOException e) {
            return null;
        }
    }

    private void fail(String metric, long oldVal, long newVal) {
        CgroupMetricsTester.fail("unified", metric, oldVal, newVal);
    }

    private void fail(String metric, String oldVal, String newVal) {
        CgroupMetricsTester.fail("unified", metric, oldVal, newVal);
    }

    private void warn(String metric, long oldVal, long newVal) {
        CgroupMetricsTester.warn("unified", metric, oldVal, newVal);
    }

    private long getCpuShares(String file) {
        int distance_upper;
        long rawVal = this.getLongValueFromFile(file);
        if (rawVal == -1L || rawVal == 100L) {
            return -1L;
        }
        int shares = (int)rawVal;
        int x = 262142 * shares - 1;
        double frac = (double)x / 9999.0;
        if ((x = (int)frac + 2) <= 1024) {
            return 1024L;
        }
        int f = x / 1024;
        int lower_multiple = f * 1024;
        int upper_multiple = (f + 1) * 1024;
        int distance_lower = Math.max(lower_multiple, x) - Math.min(lower_multiple, x);
        x = distance_lower <= (distance_upper = Math.max(upper_multiple, x) - Math.min(upper_multiple, x)) ? lower_multiple : upper_multiple;
        return x;
    }

    private long getCpuMaxValueFromFile(String file) {
        return this.getCpuValueFromFile(file, 0);
    }

    private long getCpuPeriodValueFromFile(String file) {
        return this.getCpuValueFromFile(file, 1);
    }

    private long getCpuValueFromFile(String file, int index) {
        String maxPeriod = this.getStringVal(file);
        if (maxPeriod == null) {
            return -1L;
        }
        String[] tokens = maxPeriod.split("\\s+");
        String val = tokens[index];
        if (MAX.equals(val)) {
            return -1L;
        }
        return this.convertStringToLong(val);
    }

    private long convertStringToLong(String val) {
        return CgroupMetricsTester.convertStringToLong(val, -1L, -1L);
    }

    private long nanosOrUnlimited(long micros) {
        if (micros < 0L) {
            return -1L;
        }
        return TimeUnit.MICROSECONDS.toNanos(micros);
    }

    @Override
    public void testMemorySubsystem() {
        long memLimit;
        long memAndSwapLimit;
        long newVal;
        Metrics metrics = Metrics.systemMetrics();
        long oldVal = metrics.getMemoryFailCount();
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal, newVal = this.getLongValueEntryFromFile("memory.events", MAX))) {
            this.fail("memory.events[max]", oldVal, newVal);
        }
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal = metrics.getMemoryLimit(), newVal = this.getLongLimitValueFromFile("memory.max"))) {
            this.fail("memory.max", oldVal, newVal);
        }
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal = metrics.getMemoryUsage(), newVal = this.getLongValueFromFile("memory.current"))) {
            this.fail("memory.current", oldVal, newVal);
        }
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal = metrics.getTcpMemoryUsage(), newVal = this.getLongValueEntryFromFile("memory.stat", "sock"))) {
            this.fail("memory.stat[sock]", oldVal, newVal);
        }
        if ((memAndSwapLimit = metrics.getMemoryAndSwapLimit()) <= (memLimit = metrics.getMemoryLimit())) {
            System.out.println("No swap memory limits, test case(s) skipped");
        } else {
            long memUsage;
            long swapUsage;
            oldVal = memAndSwapLimit;
            long valSwap = this.getLongLimitValueFromFile("memory.swap.max");
            long valMemory = this.getLongLimitValueFromFile("memory.max");
            if (valSwap == -1L) {
                newVal = valSwap;
            } else {
                assert (valMemory >= 0L);
                newVal = valSwap + valMemory;
            }
            if (!CgroupMetricsTester.compareWithErrorMargin(oldVal, newVal)) {
                this.fail("memory.swap.max", oldVal, newVal);
            }
            if (!CgroupMetricsTester.compareWithErrorMargin(oldVal = metrics.getMemoryAndSwapUsage(), newVal = (swapUsage = this.getLongValueFromFile("memory.swap.current")) + (memUsage = this.getLongValueFromFile("memory.current")))) {
                this.fail("memory.swap.current", oldVal, newVal);
            }
        }
        oldVal = metrics.getMemorySoftLimit();
        newVal = this.getLongLimitValueFromFile("memory.low");
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal, newVal)) {
            this.fail("memory.low", oldVal, newVal);
        }
    }

    @Override
    public void testCpuAccounting() {
        long newVal;
        Metrics metrics = Metrics.systemMetrics();
        long oldVal = metrics.getCpuUsage();
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal, newVal = this.nanosOrUnlimited(this.getLongValueEntryFromFile("cpu.stat", "usage_usec")))) {
            this.warn("cpu.stat[usage_usec]", oldVal, newVal);
        }
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal = metrics.getCpuUserUsage(), newVal = this.nanosOrUnlimited(this.getLongValueEntryFromFile("cpu.stat", "user_usec")))) {
            this.warn("cpu.stat[user_usec]", oldVal, newVal);
        }
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal = metrics.getCpuSystemUsage(), newVal = this.nanosOrUnlimited(this.getLongValueEntryFromFile("cpu.stat", "system_usec")))) {
            this.warn("cpu.stat[system_usec]", oldVal, newVal);
        }
    }

    @Override
    public void testCpuSchedulingMetrics() {
        long newVal;
        Metrics metrics = Metrics.systemMetrics();
        long oldVal = metrics.getCpuPeriod();
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal, newVal = this.getCpuPeriodValueFromFile("cpu.max"))) {
            this.fail("cpu.max[$PERIOD]", oldVal, newVal);
        }
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal = metrics.getCpuQuota(), newVal = this.getCpuMaxValueFromFile("cpu.max"))) {
            this.fail("cpu.max[$MAX]", oldVal, newVal);
        }
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal = metrics.getCpuShares(), newVal = this.getCpuShares("cpu.weight"))) {
            this.fail("cpu.weight", oldVal, newVal);
        }
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal = metrics.getCpuNumPeriods(), newVal = this.getLongValueEntryFromFile("cpu.stat", "nr_periods"))) {
            this.fail("cpu.stat[nr_periods]", oldVal, newVal);
        }
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal = metrics.getCpuNumThrottled(), newVal = this.getLongValueEntryFromFile("cpu.stat", "nr_throttled"))) {
            this.fail("cpu.stat[nr_throttled]", oldVal, newVal);
        }
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal = metrics.getCpuThrottledTime(), newVal = this.nanosOrUnlimited(this.getLongValueEntryFromFile("cpu.stat", "throttled_usec")))) {
            this.fail("cpu.stat[throttled_usec]", oldVal, newVal);
        }
    }

    @Override
    public void testCpuSets() {
        Metrics metrics = Metrics.systemMetrics();
        Object[] oldVal = CgroupMetricsTester.boxedArrayOrNull(metrics.getCpuSetCpus());
        oldVal = CgroupMetricsTester.sortAllowNull((Integer[])oldVal);
        String cpusstr = this.getStringVal("cpuset.cpus");
        Object[] newVal = CgroupMetricsTester.convertCpuSetsToArray(cpusstr);
        if (Arrays.compare((Comparable[])oldVal, (Comparable[])(newVal = CgroupMetricsTester.sortAllowNull((Integer[])newVal))) != 0) {
            this.fail("cpuset.cpus", Arrays.toString(oldVal), Arrays.toString(newVal));
        }
        oldVal = CgroupMetricsTester.boxedArrayOrNull(metrics.getEffectiveCpuSetCpus());
        oldVal = CgroupMetricsTester.sortAllowNull((Integer[])oldVal);
        cpusstr = this.getStringVal("cpuset.cpus.effective");
        newVal = CgroupMetricsTester.convertCpuSetsToArray(cpusstr);
        if (Arrays.compare((Comparable[])oldVal, (Comparable[])(newVal = CgroupMetricsTester.sortAllowNull((Integer[])newVal))) != 0) {
            this.fail("cpuset.cpus.effective", Arrays.toString(oldVal), Arrays.toString(newVal));
        }
        oldVal = CgroupMetricsTester.boxedArrayOrNull(metrics.getCpuSetMems());
        oldVal = CgroupMetricsTester.sortAllowNull((Integer[])oldVal);
        cpusstr = this.getStringVal("cpuset.mems");
        newVal = CgroupMetricsTester.convertCpuSetsToArray(cpusstr);
        if (Arrays.compare((Comparable[])oldVal, (Comparable[])(newVal = CgroupMetricsTester.sortAllowNull((Integer[])newVal))) != 0) {
            this.fail("cpuset.mems", Arrays.toString(oldVal), Arrays.toString(newVal));
        }
        oldVal = CgroupMetricsTester.boxedArrayOrNull(metrics.getEffectiveCpuSetMems());
        oldVal = CgroupMetricsTester.sortAllowNull((Integer[])oldVal);
        cpusstr = this.getStringVal("cpuset.mems.effective");
        newVal = CgroupMetricsTester.convertCpuSetsToArray(cpusstr);
        if (Arrays.compare((Comparable[])oldVal, (Comparable[])(newVal = CgroupMetricsTester.sortAllowNull((Integer[])newVal))) != 0) {
            this.fail("cpuset.mems.effective", Arrays.toString(oldVal), Arrays.toString(newVal));
        }
    }

    @Override
    public void testCpuConsumption() {
        Metrics metrics = Metrics.systemMetrics();
        long newSysVal = metrics.getCpuSystemUsage();
        long newUserVal = metrics.getCpuUserUsage();
        long newUsage = metrics.getCpuUsage();
        if (newSysVal < this.startSysVal) {
            this.fail("getCpuSystemUsage", newSysVal, this.startSysVal);
        }
        if (newUserVal < this.startUserVal) {
            this.fail("getCpuUserUsage", newUserVal, this.startUserVal);
        }
        if (newUsage <= this.startUsage) {
            this.fail("getCpuUsage", newUsage, this.startUsage);
        }
    }

    @Override
    public void testMemoryUsage() {
        Metrics metrics = Metrics.systemMetrics();
        long memoryUsage = metrics.getMemoryUsage();
        long newMemoryUsage = 0L;
        byte[][] bytes = new byte[32][];
        for (int i = 0; i < 32; ++i) {
            bytes[i] = new byte[0x800000];
            newMemoryUsage = metrics.getMemoryUsage();
            if (newMemoryUsage > memoryUsage) break;
        }
        if (newMemoryUsage < memoryUsage) {
            this.fail("getMemoryUsage", memoryUsage, newMemoryUsage);
        }
    }

    @Override
    public void testMisc() {
        this.testIOStat();
    }

    private void testIOStat() {
        Metrics metrics = Metrics.systemMetrics();
        long oldVal = metrics.getBlkIOServiceCount();
        long newVal = this.getIoStatAccumulate(new String[]{"rios", "wios"});
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal, newVal)) {
            this.fail("io.stat->rios/wios: ", oldVal, newVal);
        }
        oldVal = metrics.getBlkIOServiced();
        newVal = this.getIoStatAccumulate(new String[]{"rbytes", "wbytes"});
        if (!CgroupMetricsTester.compareWithErrorMargin(oldVal, newVal)) {
            this.fail("io.stat->rbytes/wbytes: ", oldVal, newVal);
        }
    }

    private long getIoStatAccumulate(String[] matchNames) {
        try {
            return Files.lines(Paths.get(UNIFIED.getPath(), "io.stat")).map(line -> {
                String[] tokens;
                long accumulator = 0L;
                for (String t : tokens = line.split("\\s+")) {
                    String[] keyVal = t.split("=");
                    if (keyVal.length != 2) continue;
                    for (String match : matchNames) {
                        if (!match.equals(keyVal[0])) continue;
                        accumulator += Long.parseLong(keyVal[1]);
                    }
                }
                return accumulator;
            }).collect(Collectors.summingLong(e -> e));
        }
        catch (IOException e2) {
            return -1L;
        }
    }

    static class UnifiedController {
        private static final String NAME = "unified";
        private final String path = UnifiedController.constructPath();

        UnifiedController() {
        }

        String getPath() {
            return this.path;
        }

        private static String constructPath() {
            try {
                List fifthTokens = Files.lines(Paths.get("/proc/self/mountinfo", new String[0])).filter(l -> l.contains("- cgroup2")).map(UnifiedController::splitAndMountPath).collect(Collectors.toList());
                if (fifthTokens.size() != 1) {
                    throw new AssertionError((Object)"Expected only one cgroup2 line");
                }
                String mountPath = (String)fifthTokens.get(0);
                List cgroupPaths = Files.lines(Paths.get("/proc/self/cgroup", new String[0])).filter(l -> l.startsWith("0:")).map(UnifiedController::splitAndCgroupPath).collect(Collectors.toList());
                if (cgroupPaths.size() != 1) {
                    throw new AssertionError((Object)"Expected only one unified controller line");
                }
                String cgroupPath = (String)cgroupPaths.get(0);
                return Paths.get(mountPath, cgroupPath).toString();
            }
            catch (IOException e) {
                return null;
            }
        }

        public static String splitAndMountPath(String input) {
            String[] tokens = input.split("\\s+");
            return tokens[4];
        }

        public static String splitAndCgroupPath(String input) {
            String[] tokens = input.split(":");
            return tokens[2];
        }
    }
}

