/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl.krb5;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import javax.net.ssl.SSLKeyException;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.kerberos.ServicePermission;
import sun.security.jgss.GSSCaller;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.jgss.krb5.ServiceCreds;
import sun.security.krb5.EncryptedData;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.internal.EncTicketPart;
import sun.security.krb5.internal.Ticket;
import sun.security.ssl.Krb5Helper;
import sun.security.ssl.KrbClientKeyExchangeHelper;
import sun.security.ssl.SSLLogger;

public final class KrbClientKeyExchangeHelperImpl
implements KrbClientKeyExchangeHelper {
    private byte[] preMaster;
    private byte[] preMasterEnc;
    private byte[] encodedTicket;
    private KerberosPrincipal peerPrincipal;
    private KerberosPrincipal localPrincipal;

    @Override
    public void init(byte[] byArray, String string, AccessControlContext accessControlContext) throws IOException {
        this.preMaster = byArray;
        KerberosTicket kerberosTicket = KrbClientKeyExchangeHelperImpl.getServiceTicket(string, accessControlContext);
        this.encodedTicket = kerberosTicket.getEncoded();
        this.peerPrincipal = kerberosTicket.getServer();
        this.localPrincipal = kerberosTicket.getClient();
        EncryptionKey encryptionKey = new EncryptionKey(kerberosTicket.getSessionKeyType(), kerberosTicket.getSessionKey().getEncoded());
        this.encryptPremasterSecret(encryptionKey);
    }

    @Override
    public void init(byte[] byArray, byte[] byArray2, Object object, AccessControlContext accessControlContext) throws IOException {
        EncryptionKey encryptionKey;
        block13: {
            this.encodedTicket = byArray;
            this.preMasterEnc = byArray2;
            encryptionKey = null;
            try {
                KerberosKey[] kerberosKeyArray;
                Ticket ticket = new Ticket(byArray);
                EncryptedData encryptedData = ticket.encPart;
                PrincipalName principalName = ticket.sname;
                final ServiceCreds serviceCreds = (ServiceCreds)object;
                final KerberosPrincipal kerberosPrincipal = new KerberosPrincipal(principalName.toString());
                if (serviceCreds.getName() == null) {
                    kerberosKeyArray = System.getSecurityManager();
                    try {
                        if (kerberosKeyArray != null) {
                            kerberosKeyArray.checkPermission(Krb5Helper.getServicePermission(principalName.toString(), "accept"), accessControlContext);
                        }
                    }
                    catch (SecurityException securityException) {
                        if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                            SSLLogger.fine("Permission to access Kerberos secret key denied", new Object[0]);
                        }
                        throw new IOException("Kerberos service not allowed");
                    }
                }
                if ((kerberosKeyArray = AccessController.doPrivileged(new PrivilegedAction<KerberosKey[]>(){

                    @Override
                    public KerberosKey[] run() {
                        return serviceCreds.getKKeys(kerberosPrincipal);
                    }
                })).length == 0) {
                    throw new IOException("Found no key for " + kerberosPrincipal + (serviceCreds.getName() == null ? "" : ", this keytab is for " + serviceCreds.getName() + " only"));
                }
                int n = encryptedData.getEType();
                Integer n2 = encryptedData.getKeyVersionNumber();
                KerberosKey kerberosKey = null;
                try {
                    kerberosKey = KrbClientKeyExchangeHelperImpl.findKey(n, n2, kerberosKeyArray);
                }
                catch (KrbException krbException) {
                    throw new IOException("Cannot find key matching version number", krbException);
                }
                if (kerberosKey == null) {
                    throw new IOException("Cannot find key of appropriate type to decrypt ticket - need etype " + n);
                }
                EncryptionKey encryptionKey2 = new EncryptionKey(n, kerberosKey.getEncoded());
                byte[] byArray3 = encryptedData.decrypt(encryptionKey2, 2);
                byte[] byArray4 = encryptedData.reset(byArray3);
                EncTicketPart encTicketPart = new EncTicketPart(byArray4);
                this.peerPrincipal = new KerberosPrincipal(encTicketPart.cname.getName());
                this.localPrincipal = new KerberosPrincipal(principalName.getName());
                encryptionKey = encTicketPart.key;
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("server principal: " + principalName, new Object[0]);
                    SSLLogger.fine("cname: " + encTicketPart.cname.toString(), new Object[0]);
                }
            }
            catch (Exception exception) {
                encryptionKey = null;
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) break block13;
                SSLLogger.fine("Error getting the Kerberos session key to decrypt the pre-master secret", new Object[0]);
            }
        }
        if (encryptionKey != null) {
            this.decryptPremasterSecret(encryptionKey);
        }
    }

    @Override
    public byte[] getEncodedTicket() {
        return this.encodedTicket;
    }

    @Override
    public byte[] getEncryptedPreMasterSecret() {
        return this.preMasterEnc;
    }

    @Override
    public byte[] getPlainPreMasterSecret() {
        return this.preMaster;
    }

    @Override
    public KerberosPrincipal getPeerPrincipal() {
        return this.peerPrincipal;
    }

    @Override
    public KerberosPrincipal getLocalPrincipal() {
        return this.localPrincipal;
    }

    private void encryptPremasterSecret(EncryptionKey encryptionKey) throws IOException {
        if (encryptionKey.getEType() == 16) {
            throw new IOException("session keys with des3-cbc-hmac-sha1-kd encryption type are not supported for TLS Kerberos cipher suites");
        }
        try {
            EncryptedData encryptedData = new EncryptedData(encryptionKey, this.preMaster, 0);
            this.preMasterEnc = encryptedData.getBytes();
        }
        catch (KrbException krbException) {
            throw (IOException)new SSLKeyException("Kerberos pre-master secret error").initCause(krbException);
        }
    }

    private void decryptPremasterSecret(EncryptionKey encryptionKey) throws IOException {
        block8: {
            if (encryptionKey.getEType() == 16) {
                throw new IOException("session keys with des3-cbc-hmac-sha1-kd encryption type are not supported for TLS Kerberos cipher suites");
            }
            try {
                EncryptedData encryptedData = new EncryptedData(encryptionKey.getEType(), null, this.preMasterEnc);
                byte[] byArray = encryptedData.decrypt(encryptionKey, 0);
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake") && this.preMasterEnc != null) {
                    SSLLogger.fine("decrypted premaster secret", new Object[]{byArray});
                }
                if (byArray.length == 52 && encryptedData.getEType() == 1) {
                    if (KrbClientKeyExchangeHelperImpl.paddingByteIs(byArray, 52, (byte)4) || KrbClientKeyExchangeHelperImpl.paddingByteIs(byArray, 52, (byte)0)) {
                        byArray = Arrays.copyOf(byArray, 48);
                    }
                } else if (byArray.length == 56 && encryptedData.getEType() == 3 && KrbClientKeyExchangeHelperImpl.paddingByteIs(byArray, 56, (byte)8)) {
                    byArray = Arrays.copyOf(byArray, 48);
                }
                this.preMaster = byArray;
            }
            catch (Exception exception) {
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) break block8;
                SSLLogger.fine("Error decrypting the pre-master secret", new Object[0]);
            }
        }
    }

    private static boolean paddingByteIs(byte[] byArray, int n, byte by) {
        for (int i = 48; i < n; ++i) {
            if (byArray[i] == by) continue;
            return false;
        }
        return true;
    }

    private static KerberosTicket getServiceTicket(String string, final AccessControlContext accessControlContext) throws IOException {
        PrincipalName principalName;
        String string2;
        if ("localhost".equals(string) || "localhost.localdomain".equals(string)) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Get the local hostname", new Object[0]);
            }
            if ((string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    try {
                        return InetAddress.getLocalHost().getHostName();
                    }
                    catch (UnknownHostException unknownHostException) {
                        if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                            SSLLogger.fine("Warning, cannot get the local hostname: " + unknownHostException.getMessage(), new Object[0]);
                        }
                        return null;
                    }
                }
            })) != null) {
                string = string2;
            }
        }
        string2 = "host/" + string;
        try {
            principalName = new PrincipalName(string2, 3);
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Invalid service principal name: " + string2);
            iOException.initCause(exception);
            throw iOException;
        }
        String string3 = principalName.getRealmAsString();
        final String string4 = principalName.toString();
        final String string5 = "krbtgt/" + string3 + "@" + string3;
        final String string6 = null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ServicePermission(string4, "initiate"), accessControlContext);
        }
        try {
            KerberosTicket kerberosTicket = AccessController.doPrivileged(new PrivilegedExceptionAction<KerberosTicket>(){

                @Override
                public KerberosTicket run() throws Exception {
                    return Krb5Util.getTicketFromSubjectAndTgs((GSSCaller)GSSCaller.CALLER_SSL_CLIENT, (String)string6, (String)string4, (String)string5, (AccessControlContext)accessControlContext);
                }
            });
            if (kerberosTicket == null) {
                throw new IOException("Failed to find any kerberos service ticket for " + string4);
            }
            return kerberosTicket;
        }
        catch (PrivilegedActionException privilegedActionException) {
            IOException iOException = new IOException("Attempt to obtain kerberos service ticket for " + string4 + " failed!");
            iOException.initCause(privilegedActionException);
            throw iOException;
        }
    }

    private static boolean versionMatches(Integer n, int n2) {
        if (n == null || n == 0 || n2 == 0) {
            return true;
        }
        return n.equals(n2);
    }

    private static KerberosKey findKey(int n, Integer n2, KerberosKey[] kerberosKeyArray) throws KrbException {
        int n3;
        int n4;
        int n5;
        boolean bl = false;
        int n6 = 0;
        KerberosKey kerberosKey = null;
        for (n5 = 0; n5 < kerberosKeyArray.length; ++n5) {
            n4 = kerberosKeyArray[n5].getKeyType();
            if (n != n4) continue;
            n3 = kerberosKeyArray[n5].getVersionNumber();
            bl = true;
            if (KrbClientKeyExchangeHelperImpl.versionMatches(n2, n3)) {
                return kerberosKeyArray[n5];
            }
            if (n3 <= n6) continue;
            kerberosKey = kerberosKeyArray[n5];
            n6 = n3;
        }
        if (n == 1 || n == 3) {
            for (n5 = 0; n5 < kerberosKeyArray.length; ++n5) {
                n4 = kerberosKeyArray[n5].getKeyType();
                if (n4 != 1 && n4 != 3) continue;
                n3 = kerberosKeyArray[n5].getVersionNumber();
                bl = true;
                if (KrbClientKeyExchangeHelperImpl.versionMatches(n2, n3)) {
                    return new KerberosKey(kerberosKeyArray[n5].getPrincipal(), kerberosKeyArray[n5].getEncoded(), n, n3);
                }
                if (n3 <= n6) continue;
                kerberosKey = new KerberosKey(kerberosKeyArray[n5].getPrincipal(), kerberosKeyArray[n5].getEncoded(), n, n3);
                n6 = n3;
            }
        }
        if (bl) {
            return kerberosKey;
        }
        return null;
    }
}

