/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.edit;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.AccessibleAnchorProvider;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.examples.logicdesigner.edit.OutputEditPart;
import org.eclipse.gef.examples.logicdesigner.figures.AndGateFigure;
import org.eclipse.gef.examples.logicdesigner.figures.GateFigure;
import org.eclipse.gef.examples.logicdesigner.figures.OrGateFigure;
import org.eclipse.gef.examples.logicdesigner.figures.XOrGateFigure;
import org.eclipse.gef.examples.logicdesigner.model.AndGate;
import org.eclipse.gef.examples.logicdesigner.model.OrGate;
import org.eclipse.gef.examples.logicdesigner.model.XORGate;

public class GateEditPart
extends OutputEditPart {
    @Override
    protected IFigure createFigure() {
        if (this.getModel() == null) {
            return null;
        }
        if (this.getModel() instanceof OrGate) {
            return new OrGateFigure();
        }
        if (this.getModel() instanceof AndGate) {
            return new AndGateFigure();
        }
        if (this.getModel() instanceof XORGate) {
            return new XOrGateFigure();
        }
        return new GateFigure();
    }

    @Override
    public <T> T getAdapter(Class<T> key) {
        if (key == AccessibleAnchorProvider.class) {
            return key.cast(new AbstractGraphicalEditPart.DefaultAccessibleAnchorProvider(this){

                public List<Point> getSourceAnchorLocations() {
                    ArrayList<Point> list = new ArrayList<Point>();
                    List<ConnectionAnchor> sourceAnchors = GateEditPart.this.getNodeFigure().getSourceConnectionAnchors();
                    sourceAnchors.forEach(anchor -> {
                        boolean bl = list.add(anchor.getReferencePoint().getTranslated(0, -3));
                    });
                    return list;
                }

                public List<Point> getTargetAnchorLocations() {
                    ArrayList<Point> list = new ArrayList<Point>();
                    List<ConnectionAnchor> targetAnchors = GateEditPart.this.getNodeFigure().getTargetConnectionAnchors();
                    targetAnchors.forEach(anchor -> {
                        boolean bl = list.add(anchor.getReferencePoint());
                    });
                    return list;
                }
            });
        }
        return super.getAdapter(key);
    }
}

