/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.shapes.parts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ShortestPathConnectionRouter;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.examples.shapes.model.EllipticalShape;
import org.eclipse.gef.examples.shapes.model.RectangularShape;
import org.eclipse.gef.examples.shapes.model.Shape;
import org.eclipse.gef.examples.shapes.model.ShapesDiagram;
import org.eclipse.gef.examples.shapes.model.commands.ShapeCreateCommand;
import org.eclipse.gef.examples.shapes.model.commands.ShapeSetConstraintCommand;
import org.eclipse.gef.examples.shapes.parts.ShapeEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

class DiagramEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener {
    DiagramEditPart() {
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getModel().addPropertyChangeListener(this);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ShapesXYLayoutEditPolicy());
    }

    protected IFigure createFigure() {
        FreeformLayer f = new FreeformLayer();
        f.setBorder((Border)new MarginBorder(3));
        f.setLayoutManager((LayoutManager)new FreeformLayout());
        ConnectionLayer connLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        connLayer.setConnectionRouter((ConnectionRouter)new ShortestPathConnectionRouter((IFigure)f));
        return f;
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            this.getModel().removePropertyChangeListener(this);
        }
    }

    public ShapesDiagram getModel() {
        return (ShapesDiagram)super.getModel();
    }

    protected List<Shape> getModelChildren() {
        return this.getModel().getChildren();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("ShapesDiagram.ChildAdded".equals(prop) || "ShapesDiagram.ChildRemoved".equals(prop)) {
            this.refreshChildren();
        }
    }

    private static class ShapesXYLayoutEditPolicy
    extends XYLayoutEditPolicy {
        private ShapesXYLayoutEditPolicy() {
        }

        protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
            if (child instanceof ShapeEditPart && constraint instanceof Rectangle) {
                return new ShapeSetConstraintCommand((Shape)child.getModel(), request, (Rectangle)constraint);
            }
            return super.createChangeConstraintCommand(request, child, constraint);
        }

        protected Command getCreateCommand(CreateRequest request) {
            Object childClass = request.getNewObjectType();
            if (childClass == EllipticalShape.class || childClass == RectangularShape.class) {
                return new ShapeCreateCommand((Shape)request.getNewObject(), (ShapesDiagram)this.getHost().getModel(), (Rectangle)this.getConstraintFor(request));
            }
            return null;
        }
    }
}

