/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.ui.views.vresources;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.ui.views.vresources.AggregateEventIterator;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.ui.views.vresources.VirtualResourceEntry;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;

class AggregateResourcesEntry
extends VirtualResourceEntry {
    private final @NonNull List<ITimeGraphEntry> fContributors = new ArrayList<ITimeGraphEntry>();
    private static final Comparator<ITimeEvent> COMPARATOR = new Comparator<ITimeEvent>(){

        @Override
        public int compare(ITimeEvent o1, ITimeEvent o2) {
            return Integer.compare(this.getValue(o2), this.getValue(o1));
        }

        private int getValue(ITimeEvent element) {
            return element instanceof TimeEvent ? ((TimeEvent)element).getValue() : Integer.MIN_VALUE;
        }
    };

    public AggregateResourcesEntry(@NonNull ITmfTrace trace, long startTime, long endTime, VirtualResourceEntry.Type type, int id) {
        super(-2, trace, startTime, endTime, type, id);
    }

    public AggregateResourcesEntry(@NonNull ITmfTrace trace, String name, long startTime, long endTime, VirtualResourceEntry.Type type, int id) {
        super(-2, trace, name, startTime, endTime, type, id);
    }

    public void addEvent(ITimeEvent event) {
    }

    public void addZoomedEvent(ITimeEvent event) {
    }

    @Override
    public Iterator<@NonNull ITimeEvent> getTimeEventsIterator() {
        return new AggregateEventIterator(this.fContributors, COMPARATOR);
    }

    public Iterator<@NonNull ITimeEvent> getTimeEventsIterator(long startTime, long stopTime, long visibleDuration) {
        return new AggregateEventIterator(this.fContributors, startTime, stopTime, visibleDuration, COMPARATOR);
    }

    public void addContributor(ITimeGraphEntry entry) {
        this.fContributors.add(entry);
    }
}

