/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.inandout.ui;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.incubator.internal.inandout.core.analysis.InAndOutAnalysisModule;
import org.eclipse.tracecompass.incubator.internal.inandout.core.analysis.SegmentSpecifier;
import org.eclipse.tracecompass.incubator.internal.inandout.ui.Activator;
import org.eclipse.tracecompass.incubator.internal.inandout.ui.SegmentSpecifierDialog;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.dialog.TmfFileDialogFactory;

public class InAndOutConfigDialog
extends Dialog {
    private final List<@NonNull SegmentSpecifier> fData = new ArrayList<SegmentSpecifier>();
    private ListViewer fSpecifiers = null;
    private Button fAdd = null;
    private File fPath = null;
    private ITmfTrace fTrace;
    private boolean fChanged = false;
    private static final String PREF_SAVED_OPEN_CONFIG_LOCATION = "PREF_LAST_OPEN_CONFIG_LOCATION";

    protected InAndOutConfigDialog(Shell parentShell, File supplementalPath, ITmfTrace trace) {
        super(parentShell);
        this.fPath = supplementalPath;
        this.fTrace = trace;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected Control createDialogArea(@Nullable Composite parent) {
        if (parent == null) {
            return null;
        }
        File file = new File(this.fPath.getAbsolutePath() + File.separator + "org.eclipse.tracecompass.incubator.inandout.analysis.config.json");
        @NonNull List read = InAndOutAnalysisModule.read((File)file);
        this.fData.addAll(read);
        Shell shell = this.getShell();
        shell.setText("Configure In and Out analysis");
        shell.addControlListener(InAndOutConfigDialog.resizeLayouter((Composite)shell));
        parent.addControlListener(InAndOutConfigDialog.resizeLayouter(parent));
        Composite localParent = (Composite)super.createDialogArea(parent);
        localParent.addControlListener(InAndOutConfigDialog.resizeLayouter(localParent));
        localParent.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        localParent.setLayoutData((Object)GridDataFactory.fillDefaults().hint(400, 340).grab(true, true).create());
        this.fSpecifiers = new ListViewer(localParent);
        this.fSpecifiers.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.fSpecifiers.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fSpecifiers.setInput(this.fData);
        Control list = this.fSpecifiers.getControl();
        list.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.fSpecifiers.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(@Nullable DoubleClickEvent event) {
                InAndOutConfigDialog.this.edit(InAndOutConfigDialog.this.fSpecifiers.getSelection());
            }
        });
        Composite controls = new Composite(localParent, 0);
        controls.setLayout((Layout)new GridLayout());
        controls.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).create());
        this.fAdd = new Button(controls, 8);
        this.fAdd.setEnabled(!this.fData.contains(InAndOutAnalysisModule.REFERENCE));
        this.fAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(@Nullable SelectionEvent e) {
                InAndOutConfigDialog.this.add(InAndOutConfigDialog.this.fSpecifiers);
            }
        });
        this.fAdd.setText("Add");
        Button edit = new Button(controls, 8);
        edit.setEnabled(false);
        this.fSpecifiers.addSelectionChangedListener(event -> edit.setEnabled(!this.fSpecifiers.getSelection().isEmpty()));
        edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(@Nullable SelectionEvent e) {
                InAndOutConfigDialog.this.edit(InAndOutConfigDialog.this.fSpecifiers.getSelection());
            }
        });
        edit.setText("Edit");
        Button remove = new Button(controls, 8);
        remove.setEnabled(false);
        this.fSpecifiers.addSelectionChangedListener(event -> remove.setEnabled(!event.getSelection().isEmpty() && this.fData.size() != 1));
        remove.addSelectionListener((SelectionListener)InAndOutConfigDialog.specifierAdapter(this.fSpecifiers, specifier -> {
            this.fData.remove(specifier);
            this.fSpecifiers.refresh();
            this.fAdd.setEnabled(!this.fData.contains(InAndOutAnalysisModule.REFERENCE));
        }));
        remove.setText("Remove");
        Button reset = new Button(controls, 8);
        reset.setEnabled(false);
        this.fSpecifiers.addSelectionChangedListener(event -> reset.setEnabled(this.fData.size() > 1 || !this.fData.contains(InAndOutAnalysisModule.REFERENCE)));
        reset.addSelectionListener((SelectionListener)InAndOutConfigDialog.specifierAdapter(this.fSpecifiers, specifier -> {
            this.fData.clear();
            this.add(this.fSpecifiers);
        }));
        reset.setText("Reset");
        Button importButton = new Button(controls, 8);
        importButton.setEnabled(true);
        importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(@Nullable SelectionEvent e) {
                InAndOutConfigDialog.this.importFile();
            }
        });
        importButton.setText("Import...");
        Button exportButton = new Button(controls, 8);
        exportButton.setEnabled(true);
        exportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(@Nullable SelectionEvent e) {
                InAndOutConfigDialog.this.exportFile();
            }
        });
        exportButton.setText("Export...");
        Button up = new Button(controls, 8);
        up.setEnabled(false);
        this.fSpecifiers.addSelectionChangedListener(event -> up.setEnabled(!event.getSelection().isEmpty() && this.fData.size() != 1));
        up.addSelectionListener((SelectionListener)InAndOutConfigDialog.specifierAdapter(this.fSpecifiers, specifier -> {
            int index = this.fData.indexOf(specifier);
            @NonNull SegmentSpecifier temp = this.fData.get(index - 1);
            this.fData.set(index - 1, (SegmentSpecifier)specifier);
            this.fData.set(index, temp);
            this.fSpecifiers.refresh();
        }));
        up.setText("^");
        Button down = new Button(controls, 8);
        down.setEnabled(false);
        this.fSpecifiers.addSelectionChangedListener(event -> down.setEnabled(!event.getSelection().isEmpty() && this.fData.size() != 1));
        down.addSelectionListener((SelectionListener)InAndOutConfigDialog.specifierAdapter(this.fSpecifiers, specifier -> {
            int index = this.fData.indexOf(specifier);
            @NonNull SegmentSpecifier temp = this.fData.get(index + 1);
            this.fData.set(index + 1, (SegmentSpecifier)specifier);
            this.fData.set(index, temp);
            this.fSpecifiers.refresh();
        }));
        down.setText("v");
        localParent.pack();
        return localParent;
    }

    private void exportFile() {
        FileDialog dialog = TmfFileDialogFactory.create((Shell)Display.getCurrent().getActiveShell(), (int)8192);
        dialog.setFilterExtensions(new String[]{"*.json"});
        InAndOutConfigDialog.loadFileDialogSettings(dialog);
        String selectedFileName = dialog.open();
        if (selectedFileName != null) {
            File fileName = new File(selectedFileName);
            InAndOutAnalysisModule.write((File)fileName, this.fData);
            InAndOutConfigDialog.saveFileDialogSettings(fileName.getParent());
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void importFile() {
        FileDialog dialog = TmfFileDialogFactory.create((Shell)Display.getCurrent().getActiveShell(), (int)4096);
        dialog.setFilterExtensions(new String[]{"*.json"});
        InAndOutConfigDialog.loadFileDialogSettings(dialog);
        String selectedFileName = dialog.open();
        if (selectedFileName != null) {
            File fileName = new File(selectedFileName);
            @NonNull List read = InAndOutAnalysisModule.read((File)fileName);
            this.fData.addAll(read);
            this.fSpecifiers.refresh();
            InAndOutConfigDialog.saveFileDialogSettings(fileName.getParent());
        }
    }

    private static void loadFileDialogSettings(FileDialog fd) {
        File parentFile;
        IEclipsePreferences defaultPreferences = InstanceScope.INSTANCE.getNode("org.eclipse.tracecompass.incubator.inandout.ui");
        String lastLocation = defaultPreferences.get(PREF_SAVED_OPEN_CONFIG_LOCATION, null);
        if (lastLocation != null && !lastLocation.isEmpty() && (parentFile = new File(lastLocation).getParentFile()) != null && parentFile.exists()) {
            fd.setFilterPath(parentFile.toString());
        }
    }

    private static void saveFileDialogSettings(String filePath) {
        if (filePath == null) {
            return;
        }
        InstanceScope.INSTANCE.getNode("org.eclipse.tracecompass.incubator.inandout.ui").put(PREF_SAVED_OPEN_CONFIG_LOCATION, filePath);
    }

    private static ControlListener resizeLayouter(final Composite composite) {
        return new ControlListener(){

            public void controlResized(ControlEvent e) {
                composite.layout();
            }

            public void controlMoved(ControlEvent e) {
                composite.layout();
            }
        };
    }

    private void add(ListViewer specifiers) {
        this.fData.add(new SegmentSpecifier(InAndOutAnalysisModule.REFERENCE));
        specifiers.refresh();
        this.fAdd.setEnabled(false);
    }

    private void edit(ISelection selection) {
        Object first = ((StructuredSelection)selection).getFirstElement();
        SegmentSpecifier specifier = (SegmentSpecifier)first;
        SegmentSpecifierDialog dialog = new SegmentSpecifierDialog(this.getParentShell(), specifier, this.fTrace);
        dialog.open();
        if (dialog.isUpdated()) {
            this.fSpecifiers.refresh();
            this.fAdd.setEnabled(!this.fData.contains(InAndOutAnalysisModule.REFERENCE));
        }
    }

    private static SelectionAdapter specifierAdapter(final ListViewer specifiers, final Consumer<@NonNull SegmentSpecifier> ss) {
        return new SelectionAdapter(){

            public void widgetSelected(@Nullable SelectionEvent e) {
                ISelection selection = specifiers.getSelection();
                Object firstElement = ((StructuredSelection)selection).getFirstElement();
                if (firstElement != null) {
                    ss.accept((SegmentSpecifier)firstElement);
                }
            }
        };
    }

    public boolean isChanged() {
        return this.fChanged;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            File file = new File(this.fPath.getAbsolutePath() + File.separator + "org.eclipse.tracecompass.incubator.inandout.analysis.config.json");
            boolean bl = this.fChanged = !Objects.equals(InAndOutAnalysisModule.read((File)file), this.fData);
            if (this.fChanged) {
                InAndOutAnalysisModule.write((File)file, this.fData);
                File stateSystemFile = new File(this.fPath.getAbsolutePath() + File.separator + "org.eclipse.tracecompass.incubator.inandout.analysis.ht");
                if (stateSystemFile.exists()) {
                    try {
                        Files.delete(stateSystemFile.toPath());
                    }
                    catch (IOException e) {
                        Activator activator = Activator.getDefault();
                        if (activator == null) {
                            throw new IllegalStateException("Activator should not be null here, IO exception caught", e);
                        }
                        activator.getLog().log((IStatus)new Status(4, activator.getBundle().getSymbolicName(), "Failed to delete file: " + stateSystemFile.getAbsolutePath(), (Throwable)e));
                    }
                }
            }
        }
        super.buttonPressed(buttonId);
    }
}

