/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.lttng2.ust.extras.core.pthread;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.building.AbstractTraceEventHandler;
import org.eclipse.tracecompass.analysis.graph.core.building.ITraceEventHandler;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdgeContextState;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfVertex;
import org.eclipse.tracecompass.analysis.os.linux.core.event.aspect.LinuxTidAspect;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.IOsExecutionGraphHandlerBuilder;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsExecutionGraphProvider;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsWorker;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.analysis.os.linux.core.model.ProcessStatus;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.legacy.OSEdgeContextState;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class PThreadLockGraphHandler
extends AbstractTraceEventHandler {
    private static final Pattern UNLOCK_EVENT = Pattern.compile("lttng_ust_pthread:pthread_.*_unlock");
    private static final Pattern ACQUIRE_LOCK_EVENT = Pattern.compile("lttng_ust_pthread:pthread_.*_lock_acq");
    private static final Pattern REQUEST_LOCK_EVENT = Pattern.compile("lttng_ust_pthread:pthread_.*_lock_req");
    private static final String MUTEX_FIELD = "mutex";
    private final OsExecutionGraphProvider fProvider;
    private final Table<Integer, Long, ITmfVertex> fLastRequest;
    private final Map<Long, LastLockOwner> fLastLockOwner = new HashMap<Long, LastLockOwner>();

    public PThreadLockGraphHandler(OsExecutionGraphProvider provider, int priority) {
        super(priority);
        this.fProvider = provider;
        this.fLastRequest = HashBasedTable.create();
    }

    private OsWorker getOrCreateKernelWorker(ITmfEvent event, Integer tid) {
        HostThread ht = new HostThread(event.getTrace().getHostId(), tid);
        OsWorker worker = this.fProvider.getSystem().findWorker(ht, null);
        if (worker != null) {
            return worker;
        }
        worker = new OsWorker(ht, "kernel/" + String.valueOf(tid), event.getTimestamp().getValue());
        worker.setStatus(ProcessStatus.RUN);
        this.fProvider.getSystem().addWorker(worker, null);
        return worker;
    }

    public void handleEvent(ITmfEvent event) {
        String name = event.getName();
        if (UNLOCK_EVENT.matcher(name).matches()) {
            this.handleUnlockEvent(event);
        } else if (REQUEST_LOCK_EVENT.matcher(name).matches()) {
            this.handleRequestLockEvent(event);
        } else if (ACQUIRE_LOCK_EVENT.matcher(name).matches()) {
            this.handleAcquireLockEvent(event);
        }
    }

    private void handleAcquireLockEvent(ITmfEvent event) {
        Integer tid = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), LinuxTidAspect.class, (ITmfEvent)event);
        if (tid == null) {
            return;
        }
        Long fieldValue = (Long)event.getContent().getFieldValue(Long.class, new String[]{MUTEX_FIELD});
        if (fieldValue == null) {
            return;
        }
        OsWorker worker = this.getOrCreateKernelWorker(event, tid);
        ITmfVertex lastReqVertex = (ITmfVertex)this.fLastRequest.get((Object)tid, (Object)fieldValue);
        if (lastReqVertex == null) {
            return;
        }
        LastLockOwner lastOwner = this.fLastLockOwner.get(fieldValue);
        if (lastOwner != null && lastOwner.fTid != tid && lastOwner.fVertex.getTimestamp() > lastReqVertex.getTimestamp()) {
            ITmfGraph graph = Objects.requireNonNull(this.fProvider.getGraph());
            graph.append(lastReqVertex, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            ITmfVertex unblockVertex = graph.createVertex((IGraphWorker)worker, event.getTimestamp().toNanos());
            graph.append(unblockVertex, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.BLOCKED));
            graph.edgeVertical(lastOwner.fVertex, unblockVertex, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.DEFAULT), MUTEX_FIELD);
        }
    }

    private void handleRequestLockEvent(ITmfEvent event) {
        Integer tid = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), LinuxTidAspect.class, (ITmfEvent)event);
        if (tid == null) {
            return;
        }
        Long fieldValue = (Long)event.getContent().getFieldValue(Long.class, new String[]{MUTEX_FIELD});
        if (fieldValue == null) {
            return;
        }
        ITmfGraph graph = Objects.requireNonNull(this.fProvider.getGraph());
        OsWorker worker = this.getOrCreateKernelWorker(event, tid);
        ITmfVertex vertex = graph.createVertex((IGraphWorker)worker, event.getTimestamp().toNanos());
        this.fLastRequest.put((Object)tid, (Object)fieldValue, (Object)vertex);
    }

    private void handleUnlockEvent(ITmfEvent event) {
        Integer tid = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), LinuxTidAspect.class, (ITmfEvent)event);
        if (tid == null) {
            return;
        }
        Long fieldValue = (Long)event.getContent().getFieldValue(Long.class, new String[]{MUTEX_FIELD});
        if (fieldValue == null) {
            return;
        }
        OsWorker worker = this.getOrCreateKernelWorker(event, tid);
        ITmfGraph graph = Objects.requireNonNull(this.fProvider.getGraph());
        ITmfVertex vertex = graph.createVertex((IGraphWorker)worker, event.getTimestamp().toNanos());
        graph.append(vertex, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        this.fLastLockOwner.put(fieldValue, new LastLockOwner(tid, vertex));
    }

    public static class HandlerBuilderPThreadLock
    implements IOsExecutionGraphHandlerBuilder {
        public ITraceEventHandler createHandler(@NonNull OsExecutionGraphProvider provider, int priority) {
            return new PThreadLockGraphHandler(provider, priority);
        }
    }

    private static class LastLockOwner {
        public final Integer fTid;
        public final ITmfVertex fVertex;

        public LastLockOwner(Integer tid, ITmfVertex vertex) {
            this.fTid = tid;
            this.fVertex = vertex;
        }
    }
}

