/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messages.Ros2MessagesUtil;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.objects.Ros2ObjectsUtil;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2CallbackPubMessageFlowSegment;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2MessageFlowBuildInfo;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2MessageFlowSegment;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2TransportMessageFlowSegment;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2WaitMessageFlowSegment;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messagelinks.Ros2MessageCausalLink;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2CallbackInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2CallbackPublicationInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2MessageTransportInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2PubInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2SubCallbackInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2CallbackType;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2ObjectHandle;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2PublisherObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2SubscriptionObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2TimerObject;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;

public class Ros2PublicationMessageFlowSegment
extends Ros2MessageFlowSegment {
    private final @NonNull Ros2PubInstance fPubInstance;
    private final @NonNull Ros2PublisherObject fPublisher;

    public Ros2PublicationMessageFlowSegment(long startTime, long endTime, @NonNull Ros2PubInstance pubInstance, @NonNull Ros2PublisherObject publisher) {
        super(startTime, endTime, publisher.getNodeHandle());
        this.fPubInstance = pubInstance;
        this.fPublisher = publisher;
    }

    public @NonNull Ros2PubInstance getPubInstance() {
        return this.fPubInstance;
    }

    public @NonNull Ros2PublisherObject getPublisher() {
        return this.fPublisher;
    }

    @Override
    public @NonNull Collection<@NonNull Ros2MessageFlowSegment> getDirectSuccessors(@NonNull Ros2MessageFlowBuildInfo info) {
        ArrayList<@NonNull Ros2MessageFlowSegment> next = new ArrayList<Ros2MessageFlowSegment>();
        Iterator<@NonNull T> transportLinks = Ros2MessagesUtil.getOutgoingTransportLinks(info.getMessagesSs(), this.getEndTime() + 1L, (Ros2ObjectHandle)((Object)this.getPublisher().getHandle())).iterator();
        while (transportLinks.hasNext()) {
            Ros2MessageTransportInstance transportInstance = (Ros2MessageTransportInstance)((Object)transportLinks.next());
            Long sourceTimestamp = transportInstance.getSourceTimestamp();
            Long destinationTimestamp = transportInstance.getDestinationTimestamp();
            Ros2SubscriptionObject subObject = Ros2ObjectsUtil.getSubscriptionObjectFromHandle(info.getObjectsSs(), destinationTimestamp, transportInstance.getSubscriptionHandle());
            if (subObject == null) continue;
            next.add(new Ros2TransportMessageFlowSegment(sourceTimestamp, destinationTimestamp, transportInstance, this.getPublisher(), subObject));
        }
        return next;
    }

    @Override
    public @NonNull Collection<@NonNull Ros2MessageFlowSegment> getDirectPredecessors(@NonNull Ros2MessageFlowBuildInfo info) {
        ArrayList<@NonNull Ros2MessageFlowSegment> previous = new ArrayList<Ros2MessageFlowSegment>();
        previous.addAll(this.getCallbackPublicationSegmentsBeforePublication(info));
        previous.addAll(this.getWaitSegmentsBeforePublication(info));
        return previous;
    }

    private Collection<@NonNull Ros2MessageFlowSegment> getCallbackPublicationSegmentsBeforePublication(@NonNull Ros2MessageFlowBuildInfo info) {
        ArrayList<@NonNull Ros2MessageFlowSegment> previous = new ArrayList<Ros2MessageFlowSegment>();
        long publicationTimestamp = this.getStartTime();
        Iterator<@NonNull T> callbackPublicationLinks = Ros2MessagesUtil.getIncomingCallbackPublicationLinks(info.getMessagesSs(), (Ros2ObjectHandle)((Object)this.getPublisher().getHandle()), publicationTimestamp).iterator();
        while (callbackPublicationLinks.hasNext()) {
            Ros2CallbackPublicationInstance callbackPublicationInstance = (Ros2CallbackPublicationInstance)((Object)callbackPublicationLinks.next());
            Ros2ObjectHandle callbackOwnerHandle = callbackPublicationInstance.getCallbackOwnerHandle();
            long time = callbackPublicationInstance.getPublicationTimestamp();
            Ros2CallbackType callbackType = callbackPublicationInstance.getCallbackType();
            if (callbackType.equals((Object)Ros2CallbackType.SUBSCRIPTION)) {
                Ros2SubscriptionObject subObject = Ros2ObjectsUtil.getSubscriptionObjectFromHandle(info.getObjectsSs(), time, callbackOwnerHandle);
                if (subObject == null) continue;
                previous.add(new Ros2CallbackPubMessageFlowSegment(time, time, callbackPublicationInstance, subObject, this.getPublisher()));
                continue;
            }
            if (callbackType.equals((Object)Ros2CallbackType.TIMER)) {
                Ros2TimerObject timerObject = Ros2ObjectsUtil.getTimerObjectFromHandle(info.getObjectsSs(), time, callbackOwnerHandle);
                if (timerObject == null) continue;
                previous.add(new Ros2CallbackPubMessageFlowSegment(time, time, callbackPublicationInstance, timerObject, this.getPublisher()));
                continue;
            }
            throw new IllegalStateException();
        }
        return previous;
    }

    private Collection<@NonNull Ros2MessageFlowSegment> getWaitSegmentsBeforePublication(@NonNull Ros2MessageFlowBuildInfo info) {
        ArrayList<@NonNull Ros2MessageFlowSegment> previous = new ArrayList<Ros2MessageFlowSegment>();
        for (Ros2MessageCausalLink link : info.getMessageLinksModel().getLinksForPub((Ros2ObjectHandle)((Object)this.getPublisher().getHandle()))) {
            for (Ros2ObjectHandle subHandle : link.getSubs()) {
                switch (link.getType()) {
                    case PERIODIC_ASYNC: {
                        this.getWaitPeriodicAsyncSegmentsBeforePublication(info, previous, subHandle);
                        break;
                    }
                    case PARTIAL_SYNC: {
                        this.getWaitPartialSyncSegmentsBeforePublication(info, previous, subHandle);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        }
        return previous;
    }

    private void getWaitPeriodicAsyncSegmentsBeforePublication(@NonNull Ros2MessageFlowBuildInfo info, Collection<@NonNull Ros2MessageFlowSegment> previous, @NonNull Ros2ObjectHandle subHandle) {
        ITmfStateInterval previousSubCallbackInstanceInterval = Ros2MessagesUtil.getPreviousSubCallbackInstanceInterval(info.getMessagesSs(), info.getObjectsSs(), this.getStartTime(), subHandle);
        if (previousSubCallbackInstanceInterval == null) {
            return;
        }
        Ros2SubCallbackInstance previousSubCallbackInstance = (Ros2SubCallbackInstance)((Object)previousSubCallbackInstanceInterval.getValue());
        if (previousSubCallbackInstance == null) {
            return;
        }
        Ros2SubscriptionObject subObject = Ros2ObjectsUtil.getSubscriptionObjectFromHandle(info.getObjectsSs(), previousSubCallbackInstanceInterval.getEndTime(), subHandle);
        if (subObject == null) {
            return;
        }
        previous.add(new Ros2WaitMessageFlowSegment(previousSubCallbackInstanceInterval.getEndTime(), this.getStartTime(), previousSubCallbackInstance, this.getPubInstance(), subObject, this.getPublisher()));
    }

    private void getWaitPartialSyncSegmentsBeforePublication(@NonNull Ros2MessageFlowBuildInfo info, Collection<@NonNull Ros2MessageFlowSegment> previous, @NonNull Ros2ObjectHandle subHandle) {
        boolean isCallbackPubLink;
        ITmfStateInterval previousSubCallbackInstanceInterval = Ros2MessagesUtil.getPreviousSubCallbackInstanceInterval(info.getMessagesSs(), info.getObjectsSs(), this.getStartTime(), subHandle);
        if (previousSubCallbackInstanceInterval == null) {
            return;
        }
        Ros2SubCallbackInstance previousSubCallbackInstance = (Ros2SubCallbackInstance)((Object)previousSubCallbackInstanceInterval.getValue());
        if (previousSubCallbackInstance == null) {
            return;
        }
        Ros2SubscriptionObject subObject = Ros2ObjectsUtil.getSubscriptionObjectFromHandle(info.getObjectsSs(), previousSubCallbackInstanceInterval.getEndTime(), subHandle);
        if (subObject == null) {
            return;
        }
        boolean bl = isCallbackPubLink = !previous.stream().filter(s -> {
            Ros2CallbackInstance callbackInstance;
            if (!(s instanceof Ros2CallbackPubMessageFlowSegment)) {
                return false;
            }
            Ros2CallbackPubMessageFlowSegment segment = (Ros2CallbackPubMessageFlowSegment)s;
            if (!(segment.getSource() instanceof Ros2SubscriptionObject)) {
                return false;
            }
            Ros2SubscriptionObject linkSubObject = (Ros2SubscriptionObject)segment.getSource();
            if (!linkSubObject.equals((Object)subObject)) {
                return false;
            }
            long linkTime = segment.getCallbackPubInstance().getPublicationTimestamp();
            return linkTime >= (callbackInstance = previousSubCallbackInstance.getCallbackInstance()).getStartTime() && linkTime <= callbackInstance.getEndTime();
        }).collect(Collectors.toUnmodifiableList()).isEmpty();
        if (isCallbackPubLink) {
            return;
        }
        previous.add(new Ros2WaitMessageFlowSegment(previousSubCallbackInstanceInterval.getEndTime(), this.getStartTime(), previousSubCallbackInstance, this.getPubInstance(), subObject, this.getPublisher()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.fPubInstance, this.fPublisher, super.hashCode()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Ros2PublicationMessageFlowSegment)) {
            return false;
        }
        Ros2PublicationMessageFlowSegment o = (Ros2PublicationMessageFlowSegment)obj;
        if (!this.fPubInstance.equals((Object)o.fPubInstance)) {
            return false;
        }
        return this.fPublisher.equals((Object)o.fPublisher);
    }

    @Override
    public String toString() {
        return String.format("Ros2PublicationMessageFlowSegment: %s, pubInstance=[%s], pub=[%s]", super.toString(), this.fPubInstance.toString(), this.fPublisher.toString());
    }
}

