/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.reorg;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.CreateTargetExecutionLog;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ICreateTargetQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ICreateTargetQuery;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.util.CoreUtility;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathsBlock;

public final class LoggedCreateTargetQueries
implements ICreateTargetQueries {
    private final CreateTargetExecutionLog fLog;

    public LoggedCreateTargetQueries(CreateTargetExecutionLog log) {
        Assert.isNotNull((Object)log);
        this.fLog = log;
    }

    @Override
    public ICreateTargetQuery createNewPackageQuery() {
        return new CreateTargetQuery();
    }

    public CreateTargetExecutionLog getCreateTargetExecutionLog() {
        return this.fLog;
    }

    private final class CreateTargetQuery
    implements ICreateTargetQuery {
        private CreateTargetQuery() {
        }

        private void createJavaProject(IProject project) throws CoreException {
            if (!project.exists()) {
                BuildPathsBlock.createProject(project, null, (IProgressMonitor)new NullProgressMonitor());
                BuildPathsBlock.addJavaNature(project, (IProgressMonitor)new NullProgressMonitor());
            }
        }

        private void createPackageFragmentRoot(IPackageFragmentRoot root) throws CoreException {
            IFolder folder;
            IJavaScriptProject project = root.getJavaScriptProject();
            if (!project.exists()) {
                this.createJavaProject(project.getProject());
            }
            if (!(folder = project.getProject().getFolder(root.getElementName())).exists()) {
                CoreUtility.createFolder(folder, true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            List<IIncludePathEntry> list = Arrays.asList(project.getRawIncludepath());
            list.add(JavaScriptCore.newSourceEntry((IPath)folder.getFullPath()));
            project.setRawIncludepath(list.toArray(new IIncludePathEntry[list.size()]), (IProgressMonitor)new NullProgressMonitor());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object getCreatedTarget(Object selection) {
            Object target = LoggedCreateTargetQueries.this.fLog.getCreatedElement(selection);
            if (target instanceof IPackageFragment) {
                IPackageFragment fragment = (IPackageFragment)target;
                IJavaScriptElement parent = fragment.getParent();
                if (!(parent instanceof IPackageFragmentRoot)) return target;
                try {
                    IPackageFragmentRoot root = (IPackageFragmentRoot)parent;
                    if (!root.exists()) {
                        this.createPackageFragmentRoot(root);
                    }
                    if (fragment.exists()) return target;
                    root.createPackageFragment(fragment.getElementName(), true, (IProgressMonitor)new NullProgressMonitor());
                    return target;
                }
                catch (CoreException exception) {
                    JavaScriptPlugin.log(exception);
                    return null;
                }
            }
            if (!(target instanceof IFolder)) return target;
            try {
                IFolder folder = (IFolder)target;
                IProject project = folder.getProject();
                if (!project.exists()) {
                    this.createJavaProject(project);
                }
                if (folder.exists()) return target;
                CoreUtility.createFolder(folder, true, true, (IProgressMonitor)new NullProgressMonitor());
                return target;
            }
            catch (CoreException exception) {
                JavaScriptPlugin.log(exception);
                return null;
            }
        }

        @Override
        public String getNewButtonLabel() {
            return "unused";
        }
    }
}

