/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.dpdk.core.mempool.analysis;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.Activator;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.mempool.analysis.DpdkMempoolAnalysisModule;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.mempool.analysis.Messages;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataType;
import org.eclipse.tracecompass.tmf.core.model.YModel;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.model.xy.AbstractTreeCommonXDataProvider;
import org.eclipse.tracecompass.tmf.core.model.xy.IYModel;
import org.eclipse.tracecompass.tmf.core.model.xy.TmfXYAxisDescription;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class DpdkMempoolAllocFreeRateDataProvider
extends AbstractTreeCommonXDataProvider<DpdkMempoolAnalysisModule, TmfTreeDataModel> {
    public static final String ID = "org.eclipse.tracecompass.incubator.internal.dpdk.core.mempool.alloc.free.dataprovider";
    private static final String PROVIDER_TITLE = Objects.requireNonNull("DPDK Mempool Alloc/Dealloc Rate");
    private static final TmfXYAxisDescription Y_AXIS_DESCRIPTION = new TmfXYAxisDescription(Objects.requireNonNull(Messages.DpdkMempoolAllocFreeRate_DataProvider_YAxis), "/s", DataType.NUMBER);

    public DpdkMempoolAllocFreeRateDataProvider(ITmfTrace trace, DpdkMempoolAnalysisModule module) {
        super(trace, (TmfStateSystemAnalysisModule)module);
    }

    public String getId() {
        return ID;
    }

    private static String getMempoolName(ITmfStateSystem ss, Integer mempoolNameQuark) {
        ITmfStateInterval interval = StateSystemUtils.queryUntilNonNullValue((ITmfStateSystem)ss, (int)mempoolNameQuark, (long)ss.getStartTime(), (long)ss.getCurrentEndTime());
        if (interval != null) {
            return String.valueOf(interval.getValue());
        }
        return "no_name";
    }

    protected TmfTreeModel<TmfTreeDataModel> getTree(ITmfStateSystem ss, Map<String, Object> parameters, @Nullable IProgressMonitor monitor) {
        ArrayList<TmfTreeDataModel> nodes = new ArrayList<TmfTreeDataModel>();
        long rootId = this.getId(-1);
        nodes.add(new TmfTreeDataModel(rootId, -1L, Collections.singletonList(Objects.requireNonNull(this.getTrace().getName())), false, null));
        try {
            Iterator iterator = ss.getQuarks(new String[]{"Mempools", "*"}).iterator();
            while (iterator.hasNext()) {
                int mempoolQuark = (Integer)iterator.next();
                long mempoolId = this.getId(mempoolQuark);
                int nameQuark = ss.getQuarkRelative(mempoolQuark, new String[]{"name"});
                String mempoolName = DpdkMempoolAllocFreeRateDataProvider.getMempoolName(ss, nameQuark);
                nodes.add(new TmfTreeDataModel(mempoolId, rootId, Collections.singletonList(mempoolName), false, null));
                int threadsQuark = ss.optQuarkRelative(mempoolQuark, new String[]{"threads"});
                if (threadsQuark == -2) continue;
                for (Integer threadQuark : ss.getQuarks(threadsQuark, new String[]{"*"})) {
                    int deallocMetricQuark;
                    long threadId = this.getId(threadQuark);
                    String threadName = ss.getAttributeName(threadQuark.intValue());
                    nodes.add(new TmfTreeDataModel(threadId, mempoolId, Collections.singletonList(threadName), false, null));
                    int allocQuark = ss.optQuarkRelative(threadQuark.intValue(), new String[]{"alloc"});
                    if (allocQuark != -2) {
                        long allocMetricId = this.getId(allocQuark);
                        nodes.add(new TmfTreeDataModel(allocMetricId, threadId, Collections.singletonList("alloc"), true, null));
                    }
                    if ((deallocMetricQuark = ss.optQuarkRelative(threadQuark.intValue(), new String[]{"free"})) == -2) continue;
                    long deallocMetricId = this.getId(deallocMetricQuark);
                    nodes.add(new TmfTreeDataModel(deallocMetricId, threadId, Collections.singletonList("free"), true, null));
                }
            }
        }
        catch (IndexOutOfBoundsException | AttributeNotFoundException e) {
            Activator.getInstance().logError(e.getMessage());
        }
        return new TmfTreeModel(Collections.emptyList(), nodes);
    }

    protected @Nullable Collection<IYModel> getYSeriesModels(ITmfStateSystem ss, Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQuery(fetchParameters);
        if (filter == null) {
            return null;
        }
        long[] xValues = filter.getTimesRequested();
        if (xValues.length <= 1) {
            return Collections.emptyList();
        }
        Map<Integer, MempoolBuilder> builderByQuark = this.initBuilders(ss, filter);
        if (builderByQuark.isEmpty()) {
            return Collections.emptyList();
        }
        long halfStepSize = (xValues[1] - xValues[0]) / 2L;
        long startTime = Math.max(filter.getStart() - halfStepSize, ss.getStartTime());
        for (MempoolBuilder builder2 : builderByQuark.values()) {
            ITmfStateInterval iv = ss.querySingleState(startTime, builder2.fMetricQuark);
            Object v = iv.getValue();
            long count = v instanceof Number ? ((Number)v).longValue() : 0L;
            builder2.setPrevObservation(count, startTime);
        }
        int n = xValues.length;
        ArrayList<Long> adjustedQueryTimes = new ArrayList<Long>(n);
        int i = 1;
        while (i < n) {
            adjustedQueryTimes.add(xValues[i] - halfStepSize);
            ++i;
        }
        adjustedQueryTimes.add(Math.min(xValues[n - 1] + halfStepSize, ss.getCurrentEndTime()));
        List intervals = StreamSupport.stream(ss.query2D(builderByQuark.keySet(), adjustedQueryTimes).spliterator(), false).sorted(Comparator.comparingLong(ITmfStateInterval::getStartTime)).collect(Collectors.toList());
        for (ITmfStateInterval interval : intervals) {
            if (monitor != null && monitor.isCanceled()) {
                return null;
            }
            int from = Collections.binarySearch(adjustedQueryTimes, interval.getStartTime());
            from = from >= 0 ? from : -1 - from;
            int to = Collections.binarySearch(adjustedQueryTimes, interval.getEndTime());
            int n2 = to = to >= 0 ? to + 1 : -1 - to;
            if (from >= to) continue;
            Object value = interval.getValue();
            long nbObjCount = value instanceof Number ? ((Number)value).longValue() : 0L;
            MempoolBuilder builder3 = builderByQuark.get(interval.getAttribute());
            if (builder3 == null) continue;
            int j = from;
            while (j < to) {
                builder3.updateValue(j, nbObjCount, (Long)adjustedQueryTimes.get(j));
                ++j;
            }
        }
        return ImmutableList.copyOf((Collection)builderByQuark.values().stream().map(builder -> builder.build(Y_AXIS_DESCRIPTION)).collect(Collectors.toList()));
    }

    protected boolean isCacheable() {
        return true;
    }

    protected String getTitle() {
        return PROVIDER_TITLE;
    }

    private Map<Integer, MempoolBuilder> initBuilders(ITmfStateSystem ss, SelectionTimeQueryFilter filter) {
        int length = filter.getTimesRequested().length;
        HashMap<Integer, MempoolBuilder> builderMap = new HashMap<Integer, MempoolBuilder>();
        for (Map.Entry entry : this.getSelectedEntries(filter).entrySet()) {
            int quark = Objects.requireNonNull((Integer)entry.getValue());
            try {
                String metricLabel = ss.getAttributeName(quark);
                if (!"alloc".equals(metricLabel) && !"free".equals(metricLabel)) continue;
                int threadQuark = ss.getParentAttributeQuark(quark);
                String threadName = ss.getAttributeName(threadQuark);
                int threadsQuark = ss.getParentAttributeQuark(threadQuark);
                int mempoolQuark = ss.getParentAttributeQuark(threadsQuark);
                String mempoolName = ss.getAttributeName(mempoolQuark);
                String name = this.getTrace().getName() + "/" + mempoolName + "/" + threadName + "/" + metricLabel;
                builderMap.put(quark, new MempoolBuilder((Long)entry.getKey(), quark, name, length));
            }
            catch (IndexOutOfBoundsException e) {
                Activator.getInstance().logError(e.getMessage());
            }
        }
        return builderMap;
    }

    private class MempoolBuilder {
        private final long fId;
        private final int fMetricQuark;
        private final String fName;
        private final double[] fValues;
        private static final double SECONDS_PER_NANOSECOND = 1.0E-9;
        private long fPrevObjectCount;
        private long fPrevTime;

        public MempoolBuilder(long id, int metricQuark, String name, int length) {
            this.fId = id;
            this.fMetricQuark = metricQuark;
            this.fName = name;
            this.fValues = new double[length];
        }

        public void updateValue(int pos, long objCount, long currTime) {
            long deltaCount = objCount - this.fPrevObjectCount;
            long deltaTime = currTime - this.fPrevTime;
            double rate = 0.0;
            if (deltaCount > 0L && deltaTime > 0L) {
                rate = (double)deltaCount / ((double)deltaTime * 1.0E-9);
            }
            this.fValues[pos] = rate;
            this.fPrevObjectCount = objCount;
            this.fPrevTime = currTime;
        }

        public void setPrevObservation(long prevObjCount, long timestamp) {
            this.fPrevObjectCount = prevObjCount;
            this.fPrevTime = timestamp;
        }

        public IYModel build(TmfXYAxisDescription yAxisDescription) {
            return new YModel(this.fId, this.fName, this.fValues, yAxisDescription);
        }
    }
}

