/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.gpu.core.handlers;

import org.eclipse.tracecompass.incubator.gpu.core.handlers.IGpuEventHandler;
import org.eclipse.tracecompass.incubator.gpu.core.trace.IGpuTraceEventLayout;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;

public class ApiEventHandler
implements IGpuEventHandler {
    @Override
    public void handleEvent(ITmfEvent event, ITmfStateSystemBuilder ssb, IGpuTraceEventLayout layout, ITmfStateProvider stateProvider) {
        Long tid = (Long)event.getContent().getFieldValue(Long.class, new String[]{layout.fieldThreadId()});
        if (tid == null) {
            return;
        }
        int rootQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{"root", "Processes"});
        int processQuark = ssb.getQuarkRelativeAndAdd(rootQuark, new String[]{tid.toString()});
        IGpuTraceEventLayout.IApiEventLayout apiLayout = layout.getCorrespondingApiLayout(event);
        int apiQuark = ssb.getQuarkRelativeAndAdd(processQuark, new String[]{apiLayout.getApiName()});
        int callStackQuark = ssb.getQuarkRelativeAndAdd(apiQuark, new String[]{"CallStack"});
        if (apiLayout.isBeginEvent(event)) {
            ssb.pushAttribute(event.getTimestamp().getValue(), (Object)apiLayout.getEventName(event), callStackQuark);
        } else {
            ssb.popAttribute(event.getTimestamp().getValue(), callStackQuark);
        }
        if (!layout.fieldDuration().equals("")) {
            Long duration = (Long)event.getContent().getFieldValue(Long.class, new String[]{layout.fieldDuration()});
            if (duration == null) {
                duration = 1L;
            }
            stateProvider.addFutureEvent(event.getTimestamp().getValue() + duration, (Object)event, callStackQuark, ITmfStateProvider.FutureEventType.POP);
        }
    }
}

