/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.pdom.FailedToReAcquireLockException;
import org.eclipse.core.runtime.IProgressMonitor;

public class YieldableIndexLock {
    private final IWritableIndex index;
    private final boolean flushIndex;
    private final IProgressMonitor progressMonitor;
    private long lastLockTime;
    private long cumulativeLockTime;

    public YieldableIndexLock(IWritableIndex index, boolean flushIndex, IProgressMonitor monitor) {
        this.index = index;
        this.flushIndex = flushIndex;
        this.progressMonitor = monitor;
    }

    public void acquire() throws InterruptedException {
        this.index.acquireWriteLock(this.progressMonitor);
        this.lastLockTime = System.currentTimeMillis();
    }

    public void release() {
        if (this.lastLockTime != 0L) {
            this.index.releaseWriteLock(this.flushIndex);
            this.cumulativeLockTime += System.currentTimeMillis() - this.lastLockTime;
            this.lastLockTime = 0L;
        }
    }

    public void yield() throws FailedToReAcquireLockException {
        if (this.index.hasWaitingReaders()) {
            this.index.releaseWriteLock(false);
            this.cumulativeLockTime += System.currentTimeMillis() - this.lastLockTime;
            this.lastLockTime = 0L;
            try {
                this.acquire();
            }
            catch (Throwable t) {
                throw new FailedToReAcquireLockException(t);
            }
        }
    }

    public long getCumulativeLockTime() {
        return this.cumulativeLockTime;
    }
}

