/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ctf.core.event.aspect;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.event.types.ICompositeDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IDefinition;
import org.eclipse.tracecompass.internal.tmf.ctf.core.event.aspect.Messages;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEventField;

public class CtfStreamContextAspect
implements ITmfEventAspect<List<ITmfEventField>> {
    private static final @NonNull String ANON = "";
    private static ITmfEventAspect<List<ITmfEventField>> sInstance = null;

    public static @NonNull ITmfEventAspect<List<ITmfEventField>> getInstance() {
        CtfStreamContextAspect instance = sInstance;
        if (instance == null) {
            sInstance = instance = new CtfStreamContextAspect();
        }
        return instance;
    }

    private CtfStreamContextAspect() {
    }

    public List<ITmfEventField> resolve(ITmfEvent event) {
        if (!(event instanceof CtfTmfEvent)) {
            return null;
        }
        ICompositeDefinition streamContext = ((CtfTmfEvent)event).getStreamContext();
        if (streamContext == null) {
            return null;
        }
        Object value = CtfTmfEventField.parseField((IDefinition)streamContext, ANON).getValue();
        if (value instanceof ITmfEventField[]) {
            return Arrays.asList((ITmfEventField[])value);
        }
        return null;
    }

    public @NonNull String getName() {
        return Messages.getMessage(Messages.CtfStreamContextAspect_name);
    }

    public @NonNull String getHelpText() {
        return Messages.getMessage(Messages.CtfStreamContextAspect_description);
    }

    public boolean isHiddenByDefault() {
        return true;
    }
}

