/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.association;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import org.apache.commons.lang3.NotImplementedException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.InvocationSecondaryAssociation;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class InvocationSecondaryAssociationTest
extends SwingModelTest {
    @Test
    public void test_0() throws Exception {
        InvocationSecondaryAssociationTest.setFileContentSrc("test/AFrame.java", this.getTestSource("public class AFrame extends JFrame {", "  protected void addGB(Container parent, Component child, String constraints) {", "    parent.add(child, constraints);", "  }", "}"));
        InvocationSecondaryAssociationTest.setFileContentSrc("test/AFrame.wbp-component.xml", InvocationSecondaryAssociationTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='addGB'>", "      <parameter type='java.awt.Container' parent2='true'/>", "      <parameter type='java.awt.Component' child2='true'/>", "      <parameter type='java.lang.String'/>", "    </method>", "  </methods>", "</component>"));
        InvocationSecondaryAssociationTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("public class Test extends AFrame {", "  public Test() {", "    addGB(getContentPane(), new JButton('north'), BorderLayout.NORTH);", "    addGB(getContentPane(), new JButton('west'), BorderLayout.WEST);", "  }", "}");
        frame.refresh();
        InvocationSecondaryAssociationTest.assertEquals((int)1, (int)frame.getChildrenComponents().size());
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        BorderLayout borderLayout = (BorderLayout)contentPane.getContainer().getLayout();
        InvocationSecondaryAssociationTest.assertEquals((int)2, (int)contentPane.getChildrenComponents().size());
        Container container = contentPane.getContainer();
        Component[] components = container.getComponents();
        InvocationSecondaryAssociationTest.assertEquals((int)2, (int)components.length);
        ComponentInfo button = (ComponentInfo)contentPane.getChildrenComponents().get(0);
        InvocationSecondaryAssociationTest.assertSame((Object)"North", (Object)borderLayout.getConstraints(button.getComponent()));
        button = (ComponentInfo)contentPane.getChildrenComponents().get(1);
        InvocationSecondaryAssociationTest.assertSame((Object)"West", (Object)borderLayout.getConstraints(button.getComponent()));
        button = (ComponentInfo)contentPane.getChildrenComponents().get(0);
        InvocationSecondaryAssociation association = (InvocationSecondaryAssociation)button.getAssociation();
        InvocationSecondaryAssociationTest.assertEquals((Object)"addGB(getContentPane(), new JButton(\"north\"), BorderLayout.NORTH)", (Object)association.getSource());
        InvocationSecondaryAssociationTest.assertEquals((Object)"addGB(getContentPane(), new JButton(\"north\"), BorderLayout.NORTH);", (Object)this.m_lastEditor.getSource((ASTNode)association.getStatement()));
        try {
            association.move(null);
            InvocationSecondaryAssociationTest.fail();
        }
        catch (NotImplementedException notImplementedException) {
            // empty catch block
        }
        try {
            association.setParent(null);
            InvocationSecondaryAssociationTest.fail();
        }
        catch (NotImplementedException notImplementedException) {
            // empty catch block
        }
    }

    @Test
    public void test_deletePossible() throws Exception {
        InvocationSecondaryAssociationTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void add2(Component child, Object constraints) {", "    add(child, constraints);", "  }", "  public void add2(Component child) {", "    add(child);", "  }", "}"));
        InvocationSecondaryAssociationTest.setFileContentSrc("test/MyPanel.wbp-component.xml", InvocationSecondaryAssociationTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='add2'>", "      <parameter type='java.awt.Component' child='true' parent2='true'/>", "      <parameter type='java.lang.Object' child2='true'/>", "    </method>", "    <method name='add2'>", "      <parameter type='java.awt.Component' child='true'/>", "    </method>", "  </methods>", "</component>"));
        InvocationSecondaryAssociationTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    add2(new JButton(), new GridBagConstraints());", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        JavaInfo constraints = (JavaInfo)button.getChildrenJava().get(0);
        InvocationSecondaryAssociation association = (InvocationSecondaryAssociation)constraints.getAssociation();
        InvocationSecondaryAssociationTest.assertEquals((Object)"add2(new JButton(), new GridBagConstraints())", (Object)association.getSource());
        InvocationSecondaryAssociationTest.assertTrue((boolean)association.canDelete());
        InvocationSecondaryAssociationTest.assertTrue((boolean)button.canDelete());
        constraints.delete();
        this.assertEditor("public class Test extends MyPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    add2(new JButton());", "  }", "}");
    }

    @Test
    public void test_deletePossible2() throws Exception {
        InvocationSecondaryAssociationTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void add2(Component child) {", "    add(child);", "  }", "  public void setConstraints2(Component child, Object constraints) {", "  }", "}"));
        InvocationSecondaryAssociationTest.setFileContentSrc("test/MyPanel.wbp-component.xml", InvocationSecondaryAssociationTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='add2'>", "      <parameter type='java.awt.Component' child='true'/>", "    </method>", "    <method name='setConstraints2'>", "      <parameter type='java.awt.Component' parent2='true'/>", "      <parameter type='java.lang.Object' child2='true'/>", "      <tag name='secondaryAssociation.alwaysDelete' value='true'/>", "    </method>", "  </methods>", "</component>"));
        InvocationSecondaryAssociationTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton();", "      add2(button);", "      setConstraints2(button, new GridBagConstraints());", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        JavaInfo constraints = (JavaInfo)button.getChildrenJava().get(0);
        InvocationSecondaryAssociation association = (InvocationSecondaryAssociation)constraints.getAssociation();
        InvocationSecondaryAssociationTest.assertEquals((Object)"setConstraints2(button, new GridBagConstraints())", (Object)association.getSource());
        InvocationSecondaryAssociationTest.assertTrue((boolean)association.canDelete());
        InvocationSecondaryAssociationTest.assertTrue((boolean)button.canDelete());
        constraints.delete();
        this.assertEditor("public class Test extends MyPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton();", "      add2(button);", "    }", "  }", "}");
    }

    @Test
    public void test_deleteNotPossible() throws Exception {
        InvocationSecondaryAssociationTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void add2(Component child, Object constraints) {", "    add(child, constraints);", "  }", "}"));
        InvocationSecondaryAssociationTest.setFileContentSrc("test/MyPanel.wbp-component.xml", InvocationSecondaryAssociationTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='add2'>", "      <parameter type='java.awt.Component' child='true' parent2='true'/>", "      <parameter type='java.lang.Object' child2='true'/>", "    </method>", "  </methods>", "</component>"));
        InvocationSecondaryAssociationTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    add2(new JButton(), new GridBagConstraints());", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        JavaInfo constraints = (JavaInfo)button.getChildrenJava().get(0);
        InvocationSecondaryAssociation association = (InvocationSecondaryAssociation)constraints.getAssociation();
        InvocationSecondaryAssociationTest.assertEquals((Object)"add2(new JButton(), new GridBagConstraints())", (Object)association.getSource());
        InvocationSecondaryAssociationTest.assertFalse((boolean)association.canDelete());
        InvocationSecondaryAssociationTest.assertFalse((boolean)button.canDelete());
    }

    @Test
    public void test_deleteParent() throws Exception {
        InvocationSecondaryAssociationTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void add2(Component child, Object constraints) {", "    add(child, constraints);", "  }", "}"));
        InvocationSecondaryAssociationTest.setFileContentSrc("test/MyPanel.wbp-component.xml", InvocationSecondaryAssociationTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='add2'>", "      <parameter type='java.awt.Component' child='true' parent2='true'/>", "      <parameter type='java.lang.Object' child2='true'/>", "    </method>", "  </methods>", "</component>"));
        InvocationSecondaryAssociationTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    add2(new JButton(), new GridBagConstraints());", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        button.delete();
        this.assertEditor("public class Test extends MyPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "  }", "}");
    }
}

