/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.util;

import org.assertj.core.api.Assertions;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wb.core.controls.BrowserComposite;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.errors.ErrorEntryInfo;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.core.utils.exception.FatalDesignerException;
import org.eclipse.wb.tests.designer.core.TestBundle;
import org.eclipse.wb.tests.designer.tests.DesignerTestCase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

public class DesignerExceptionUtilsTest
extends DesignerTestCase {
    @Override
    @AfterEach
    public void tearDown() throws Exception {
        DesignerExceptionUtils.flushErrorEntriesCache();
        super.tearDown();
    }

    @Test
    public void test_getRootCause_noCause() {
        Throwable e = new Throwable();
        DesignerExceptionUtilsTest.assertSame((Object)e, (Object)DesignerExceptionUtils.getRootCause((Throwable)e));
    }

    @Test
    public void test_getRootCause_singleCause() {
        Throwable e1 = new Throwable();
        Throwable e2 = new Throwable(e1);
        DesignerExceptionUtilsTest.assertSame((Object)e1, (Object)DesignerExceptionUtils.getRootCause((Throwable)e2));
    }

    @Test
    public void test_getRootCause_twoCauses() {
        Throwable e1 = new Throwable();
        Throwable e2 = new Throwable(e1);
        Throwable e3 = new Throwable(e2);
        DesignerExceptionUtilsTest.assertSame((Object)e1, (Object)DesignerExceptionUtils.getRootCause((Throwable)e3));
    }

    @Test
    public void test_getDesignerCause_noDesignerException() throws Exception {
        Throwable e = new Throwable();
        DesignerExceptionUtilsTest.assertSame((Object)e, (Object)DesignerExceptionUtils.getDesignerCause((Throwable)e));
    }

    @Test
    public void test_getDesignerCause_itself() throws Exception {
        DesignerException e = new DesignerException(-1, new String[0]);
        DesignerExceptionUtilsTest.assertSame((Object)((Object)e), (Object)DesignerExceptionUtils.getDesignerCause((Throwable)e));
    }

    @Test
    public void test_getDesignerCause_withInner() throws Exception {
        Throwable e = new Throwable();
        DesignerException e1 = new DesignerException(-1, e, new String[0]);
        DesignerExceptionUtilsTest.assertSame((Object)((Object)e1), (Object)DesignerExceptionUtils.getDesignerCause((Throwable)e1));
    }

    @Test
    public void test_getDesignerCause_inError() throws Exception {
        DesignerException e = new DesignerException(-1, new String[0]);
        Error e1 = new Error(e);
        DesignerExceptionUtilsTest.assertSame((Object)((Object)e), (Object)DesignerExceptionUtils.getDesignerCause((Throwable)e1));
    }

    @Test
    public void test_getDesignerException_noDesignerException() throws Exception {
        Throwable e = new Throwable();
        try {
            DesignerExceptionUtils.getDesignerException((Throwable)e);
            DesignerExceptionUtilsTest.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Test
    public void test_getDesignerException_itself() throws Exception {
        DesignerException e = new DesignerException(-1, new String[0]);
        DesignerExceptionUtilsTest.assertSame((Object)((Object)e), (Object)((Object)DesignerExceptionUtils.getDesignerException((Throwable)e)));
    }

    @Test
    public void test_getDesignerException_withInner() throws Exception {
        Throwable e = new Throwable();
        DesignerException e1 = new DesignerException(-1, e, new String[0]);
        DesignerExceptionUtilsTest.assertSame((Object)((Object)e1), (Object)((Object)DesignerExceptionUtils.getDesignerException((Throwable)e1)));
    }

    @Test
    public void test_getDesignerException_inError() throws Exception {
        DesignerException e = new DesignerException(-1, new String[0]);
        Error e1 = new Error(e);
        DesignerExceptionUtilsTest.assertSame((Object)((Object)e), (Object)((Object)DesignerExceptionUtils.getDesignerException((Throwable)e1)));
    }

    @Test
    public void test_getSourcePosition_notSet() throws Exception {
        Error throwable = new Error();
        DesignerExceptionUtilsTest.assertEquals((int)-1, (int)DesignerExceptionUtils.getSourcePosition((Throwable)throwable));
    }

    @Test
    public void test_getSourcePosition_wasSet() throws Exception {
        Error throwable = new Error();
        DesignerExceptionUtils.setSourcePosition((Throwable)throwable, (int)123);
        DesignerExceptionUtilsTest.assertEquals((int)123, (int)DesignerExceptionUtils.getSourcePosition((Throwable)throwable));
    }

    @Test
    public void test_isWarning_notDesignerException() throws Exception {
        Error e = new Error();
        DesignerExceptionUtilsTest.assertFalse((boolean)DesignerExceptionUtils.isWarning((Throwable)e));
    }

    @Test
    public void test_isWarning_notWarning() throws Exception {
        TestBundle testBundle = new TestBundle();
        try {
            testBundle.setFile("resources/exceptions.xml", DesignerExceptionUtilsTest.getSource("<exceptions>", "  <exception id='-1000' title='My title'></exception>", "</exceptions>"));
            testBundle.addExtension("org.eclipse.wb.core.exceptions", "<file path='resources/exceptions.xml'/>");
            testBundle.install();
            DesignerException e = new DesignerException(-1000, new String[0]);
            DesignerExceptionUtilsTest.assertFalse((boolean)DesignerExceptionUtils.isWarning((Throwable)e));
        }
        finally {
            testBundle.dispose();
        }
    }

    @Test
    public void test_isWarning_true() throws Exception {
        TestBundle testBundle = new TestBundle();
        try {
            testBundle.setFile("resources/exceptions.xml", DesignerExceptionUtilsTest.getSource("<exceptions>", "  <exception id='-1000' title='My title' warning='true'></exception>", "</exceptions>"));
            testBundle.addExtension("org.eclipse.wb.core.exceptions", "<file path='resources/exceptions.xml'/>");
            testBundle.install();
            DesignerException e = new DesignerException(-1000, new String[0]);
            DesignerExceptionUtilsTest.assertTrue((boolean)DesignerExceptionUtils.isWarning((Throwable)e));
        }
        finally {
            testBundle.dispose();
        }
    }

    @Test
    public void test_isFatal_false() throws Exception {
        Error e = new Error();
        DesignerExceptionUtilsTest.assertFalse((boolean)DesignerExceptionUtils.isFatal((Throwable)e));
    }

    @Test
    public void test_isFatal_directly() throws Exception {
        FatalDesignerException fde = new FatalDesignerException(-1, new String[0]);
        DesignerExceptionUtilsTest.assertTrue((boolean)DesignerExceptionUtils.isFatal((Throwable)fde));
    }

    @Test
    public void test_isFatal_indirectly() throws Exception {
        FatalDesignerException fde = new FatalDesignerException(-1, new String[0]);
        Error e = new Error((Throwable)fde);
        DesignerExceptionUtilsTest.assertTrue((boolean)DesignerExceptionUtils.isFatal((Throwable)e));
    }

    @Test
    public void test_getExceptionTitle_notFound() throws Exception {
        String title = DesignerExceptionUtils.getExceptionTitle((int)-1000);
        DesignerExceptionUtilsTest.assertEquals((Object)"No description", (Object)title);
    }

    @Test
    public void test_getExceptionTitle_hasTitle() throws Exception {
        TestBundle testBundle = new TestBundle();
        try {
            testBundle.setFile("resources/exceptions.xml", DesignerExceptionUtilsTest.getSourceDQ("<exceptions>", "  <exception id='-1000' title='My title'></exception>", "</exceptions>"));
            testBundle.addExtension("org.eclipse.wb.core.exceptions", "<file path='resources/exceptions.xml'/>");
            testBundle.install();
            try {
                String title = DesignerExceptionUtils.getExceptionTitle((int)-1000);
                DesignerExceptionUtilsTest.assertEquals((Object)"My title", (Object)title);
            }
            finally {
                testBundle.uninstall();
            }
        }
        finally {
            testBundle.dispose();
        }
    }

    @Test
    public void test_getErrorEntry_notFound() throws Exception {
        ErrorEntryInfo entry = DesignerExceptionUtils.getErrorEntry((int)-1000, (String[])new String[0]);
        DesignerExceptionUtilsTest.assertNotNull((Object)entry);
        DesignerExceptionUtilsTest.assertEquals((int)-1000, (int)entry.getCode());
        DesignerExceptionUtilsTest.assertEquals((Object)"WindowBuilder error", (Object)entry.getTitle());
        DesignerExceptionUtilsTest.assertEquals((Object)"No detailed description found for error (-1000).", (Object)entry.getDescription());
    }

    @Test
    public void test_getErrorEntry_basic() throws Exception {
        TestBundle testBundle = new TestBundle();
        try {
            testBundle.setFile("resources/exceptions.xml", DesignerExceptionUtilsTest.getSourceDQ("<exceptions>", "  <exception id='-1000' title='My title'>", "  My description {0} + {1}.", "  </exception>", "</exceptions>"));
            testBundle.addExtension("org.eclipse.wb.core.exceptions", "<file path='resources/exceptions.xml'/>");
            testBundle.install();
            try {
                ErrorEntryInfo entry = DesignerExceptionUtils.getErrorEntry((int)-1000, (String[])new String[]{"aaa", "bbb"});
                DesignerExceptionUtilsTest.assertNotNull((Object)entry);
                DesignerExceptionUtilsTest.assertEquals((int)-1000, (int)entry.getCode());
                DesignerExceptionUtilsTest.assertEquals((Object)"My title", (Object)entry.getTitle());
                DesignerExceptionUtilsTest.assertEquals((Object)"My description aaa + bbb.", (Object)entry.getDescription().trim());
            }
            finally {
                testBundle.uninstall();
            }
        }
        finally {
            testBundle.dispose();
        }
    }

    @Test
    public void test_getErrorEntry_escapeParametersForHTML() throws Exception {
        TestBundle testBundle = new TestBundle();
        try {
            testBundle.setFile("resources/exceptions.xml", DesignerExceptionUtilsTest.getSourceDQ("<exceptions>", "  <exception id='-1000' title='My title'>", "  My description {0}", "  </exception>", "</exceptions>"));
            testBundle.addExtension("org.eclipse.wb.core.exceptions", "<file path='resources/exceptions.xml'/>");
            testBundle.install();
            try {
                ErrorEntryInfo entry = DesignerExceptionUtils.getErrorEntry((int)-1000, (String[])new String[]{"<msg>"});
                DesignerExceptionUtilsTest.assertEquals((Object)"My description &lt;msg&gt;", (Object)entry.getDescription().trim());
            }
            finally {
                testBundle.uninstall();
            }
        }
        finally {
            testBundle.dispose();
        }
    }

    @Test
    public void test_getErrorDescription_DesignerException() throws Exception {
        int code = 99;
        DesignerException e = new DesignerException(code, new String[0]);
        ErrorEntryInfo entry = DesignerExceptionUtils.getErrorEntry((Throwable)e);
        DesignerExceptionUtilsTest.assertEquals((int)code, (int)entry.getCode());
    }

    @Test
    public void test_getErrorDescription_genericThrowable() throws Exception {
        Error e = new Error("foo");
        ErrorEntryInfo entry = DesignerExceptionUtils.getErrorEntry((Throwable)e);
        DesignerExceptionUtilsTest.assertEquals((int)1, (int)entry.getCode());
        DesignerExceptionUtilsTest.assertEquals((Object)"Internal Error", (Object)entry.getTitle());
    }

    @Test
    public void test_rewriteException() throws Exception {
        Throwable e = new Exception();
        Throwable rewritten = DesignerExceptionUtils.rewriteException((Throwable)e);
        DesignerExceptionUtilsTest.assertSame((Object)e, (Object)rewritten);
        e = new NoClassDefFoundError("org/eclipse/wb/Foo");
        rewritten = DesignerExceptionUtils.rewriteException((Throwable)e);
        DesignerExceptionUtilsTest.assertNotSame((Object)e, (Object)rewritten);
    }

    @Test
    public void test_hasTraceElementsSequence() throws Exception {
        Exception e = new Exception();
        DesignerExceptionUtilsTest.assertFalse((boolean)DesignerExceptionUtils.hasTraceElementsSequence((Throwable)e, (String[][])new String[][]{{"no.such.Class", "noSuchMethod"}, {"no.Matter", "noMatter"}}));
        DesignerExceptionUtilsTest.assertTrue((boolean)DesignerExceptionUtils.hasTraceElementsSequence((Throwable)e, (String[][])new String[][]{{"org.eclipse.equinox.launcher.Main", "run"}, {"org.eclipse.equinox.launcher.Main", "main"}}));
    }

    @Test
    public void test_getExceptionHTML() throws Exception {
        TestBundle testBundle = new TestBundle();
        try {
            testBundle.setFile("resources/exceptions.xml", DesignerExceptionUtilsTest.getSourceDQ("<exceptions>", "  <exception id='-1000' title='My title'>", "  My description {0} + {1}.", "  </exception>", "</exceptions>"));
            testBundle.addExtension("org.eclipse.wb.core.exceptions", "<file path='resources/exceptions.xml'/>");
            testBundle.install();
            try {
                DesignerException e = new DesignerException(-1000, new String[]{"AAA", "BBB"});
                String html = DesignerExceptionUtils.getExceptionHTML((Throwable)e);
                Assertions.assertThat((String)html).contains(new CharSequence[]{"My description AAA + BBB."});
                if (BrowserComposite.browserAvailable((Composite)DesignerPlugin.getShell())) {
                    Assertions.assertThat((String)html).contains(new CharSequence[]{"javascript:toggleVisibleAll()"});
                    Assertions.assertThat((String)html).contains(new CharSequence[]{"javascript:toggleVisibleAll()"});
                    Assertions.assertThat((String)html).contains(new CharSequence[]{"Show stack trace."});
                    Assertions.assertThat((String)html).contains(new CharSequence[]{"Hide stack trace."});
                }
                Assertions.assertThat((String)html).contains(new CharSequence[]{"at org.eclipse.wb.tests.designer.core.util.DesignerExceptionUtilsTest.test_getExceptionHTML"});
            }
            finally {
                testBundle.uninstall();
            }
        }
        finally {
            testBundle.dispose();
        }
    }
}

