/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.databinding.rcp.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.internal.core.databinding.model.IBindingInfo;
import org.eclipse.wb.internal.core.databinding.ui.editor.IPageListener;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.BindingContentProvider;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.ChooseClassAndPropertiesConfiguration;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.ChooseClassConfiguration;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.LabelUiContentProvider;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.SeparatorUiContentProvider;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.rcp.databinding.DatabindingsProvider;
import org.eclipse.wb.internal.rcp.databinding.model.context.BindingInfo;
import org.eclipse.wb.internal.rcp.databinding.model.context.BindingUiContentProviderContext;
import org.eclipse.wb.internal.rcp.databinding.ui.contentproviders.CheckedElementsUiContentProvider;
import org.eclipse.wb.internal.rcp.databinding.ui.contentproviders.ConverterUiContentProvider;
import org.eclipse.wb.internal.rcp.databinding.ui.contentproviders.ObservableDetailUiContentProvider;
import org.eclipse.wb.internal.rcp.databinding.ui.contentproviders.SwtDelayUiContentProvider;
import org.eclipse.wb.internal.rcp.databinding.ui.contentproviders.SwtTextEventsUiContentProvider;
import org.eclipse.wb.internal.rcp.databinding.ui.contentproviders.UpdateStrategyPropertiesUiContentProvider;
import org.eclipse.wb.internal.rcp.databinding.ui.contentproviders.UpdateStrategyUiContentProvider;
import org.eclipse.wb.internal.rcp.databinding.ui.contentproviders.ValidatorUiContentProvider;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.tests.designer.databinding.rcp.DatabindingTestUtils;
import org.eclipse.wb.tests.designer.databinding.rcp.model.AbstractBindingTest;
import org.junit.jupiter.api.Test;

public class UiConfigurationTest
extends AbstractBindingTest {
    @Test
    public void test_ObservableInfo() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"import org.eclipse.core.databinding.Binding;", "public class Test {", "  protected Shell m_shell;", "  private Text m_text;", "  private CheckboxTableViewer m_viewer;", "  private DataBindingContext m_bindingContext;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_text = new Text(m_shell, SWT.SINGLE);", "    m_viewer = new CheckboxTableViewer(m_shell, SWT.BORDER);", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    IObservableValue observeValue = BeanProperties.value(\"name\").observe(getClass());", "    IObservableValue observeDetailValue = BeanProperties.value(\"empty\", boolean.class).observeDetail(observeValue);", "    IObservableValue observeWidget = WidgetProperties.font().observe(m_shell);", "    IObservableValue observeText = WidgetProperties.text(SWT.Modify).observe(m_text);", "    IObservableSet observeSet = BeanProperties.set(\"name\").observe(getClass());", "    IObservableSet observeViewerSet = ViewerProperties.checkedElements(String.class).observe((Viewer)m_viewer);", "    DataBindingContext bindingContext = new DataBindingContext();", "    bindingContext.bindValue(observeWidget, observeValue, null, null);", "    bindingContext.bindValue(observeText, observeDetailValue, null, null);", "    bindingContext.bindSet(observeViewerSet, observeSet, null, null);", "    return bindingContext;", "  }", "}"});
        UiConfigurationTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        ArrayList providers = new ArrayList();
        BindingUiContentProviderContext context = new BindingUiContentProviderContext();
        context.setDirection("Target");
        UiConfigurationTest.assertEquals((Object)"Target", (Object)context.getDirection());
        UiConfigurationTest.assertNull((Object)context.getValue("MyValueKey"));
        context.setValue("MyValueKey", (Object)"MyValue");
        UiConfigurationTest.assertEquals((Object)"MyValue", (Object)context.getValue("MyValueKey"));
        context.setValue("MyValueKey", null);
        UiConfigurationTest.assertNull((Object)context.getValue("MyValueKey"));
        UiConfigurationTest.assertEquals((int)3, (int)provider.getBindings().size());
        UiConfigurationTest.assertInstanceOf(BindingInfo.class, provider.getBindings().get(0));
        BindingInfo binding0 = (BindingInfo)provider.getBindings().get(0);
        binding0.getModelObservable().createContentProviders(providers, context, provider);
        UiConfigurationTest.assertTrue((boolean)providers.isEmpty());
        binding0.getTargetObservable().createContentProviders(providers, context, provider);
        UiConfigurationTest.assertEquals((int)1, (int)providers.size());
        UiConfigurationTest.assertInstanceOf(SwtDelayUiContentProvider.class, providers.get(0));
        UiConfigurationTest.assertInstanceOf(BindingInfo.class, provider.getBindings().get(1));
        BindingInfo binding1 = (BindingInfo)provider.getBindings().get(1);
        providers.clear();
        binding1.getTargetObservable().createContentProviders(providers, context, provider);
        UiConfigurationTest.assertEquals((int)2, (int)providers.size());
        UiConfigurationTest.assertInstanceOf(SwtTextEventsUiContentProvider.class, providers.get(0));
        UiConfigurationTest.assertInstanceOf(SwtDelayUiContentProvider.class, providers.get(1));
        providers.clear();
        binding1.getModelObservable().createContentProviders(providers, context, provider);
        UiConfigurationTest.assertEquals((int)1, (int)providers.size());
        UiConfigurationTest.assertInstanceOf(ObservableDetailUiContentProvider.class, providers.get(0));
        ChooseClassAndPropertiesConfiguration detailActual = (ChooseClassAndPropertiesConfiguration)UiConfigurationTest.getConfiguration(providers.get(0));
        ChooseClassAndPropertiesConfiguration detailExpected = new ChooseClassAndPropertiesConfiguration();
        detailExpected.setDialogFieldLabel("Master bean class:");
        detailExpected.setValueScope("beans");
        detailExpected.setChooseInterfaces(true);
        detailExpected.setEmptyClassErrorMessage("Choose a master bean class that contains properties.");
        detailExpected.setErrorMessagePrefix("Master bean class");
        detailExpected.setPropertiesLabel("Properties (for detail):");
        detailExpected.setPropertiesErrorMessage("Choose a detail property.");
        detailExpected.addDefaultStart("detail(");
        UiConfigurationTest.assertEquals(detailExpected, detailActual);
        UiConfigurationTest.assertInstanceOf(BindingInfo.class, provider.getBindings().get(2));
        BindingInfo binding2 = (BindingInfo)provider.getBindings().get(2);
        providers.clear();
        binding2.getTargetObservable().createContentProviders(providers, context, provider);
        UiConfigurationTest.assertEquals((int)1, (int)providers.size());
        UiConfigurationTest.assertInstanceOf(CheckedElementsUiContentProvider.class, providers.get(0));
        ChooseClassConfiguration actual = UiConfigurationTest.getConfiguration(providers.get(0));
        ChooseClassConfiguration expected = new ChooseClassConfiguration();
        expected.setDialogFieldLabel("Checked bean class:");
        expected.setValueScope("beans");
        expected.setChooseInterfaces(true);
        expected.setEmptyClassErrorMessage("Choose Target checked bean class.");
        expected.setErrorMessagePrefix("Target checked bean");
        UiConfigurationTest.assertEquals(expected, actual);
    }

    @Test
    public void test_UpdateValueStrategy() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"import org.eclipse.core.databinding.Binding;", "public class Test {", "  protected Shell m_shell;", "  private DataBindingContext m_bindingContext;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    IObservableValue observeValue = BeanProperties.value(\"name\").observe(getClass());", "    IObservableValue observeWidget = WidgetProperties.text().observe(m_shell);", "    DataBindingContext bindingContext = new DataBindingContext();", "    bindingContext.bindValue(observeWidget, observeValue, null, null);", "    return bindingContext;", "  }", "}"});
        UiConfigurationTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        UiConfigurationTest.assertEquals((int)1, (int)provider.getBindings().size());
        UiConfigurationTest.assertInstanceOf(BindingInfo.class, provider.getBindings().get(0));
        BindingInfo binding = (BindingInfo)provider.getBindings().get(0);
        UiConfigurationTest.assertNotNull((Object)binding.getTargetStrategy());
        ArrayList providers = new ArrayList();
        BindingUiContentProviderContext context = new BindingUiContentProviderContext();
        context.setDirection("Target");
        binding.getTargetStrategy().createContentProviders(providers, context);
        UiConfigurationTest.assertEquals((int)2, (int)providers.size());
        UiConfigurationTest.assertInstanceOf(UpdateStrategyUiContentProvider.class, providers.get(0));
        UiConfigurationTest.assertInstanceOf(ChooseClassConfiguration.class, (Object)ReflectionUtils.getFieldObject(providers.get(0), (String)"m_configuration"));
        ChooseClassConfiguration actual = UiConfigurationTest.getConfiguration(providers.get(0));
        ChooseClassConfiguration expected = new ChooseClassConfiguration();
        expected.setDialogFieldLabel("UpdateValueStrategy:");
        expected.setDefaultValues(new String[]{"POLICY_UPDATE", "POLICY_NEVER", "POLICY_ON_REQUEST", "POLICY_CONVERT"});
        expected.setValueScope("org.eclipse.core.databinding.UpdateValueStrategy");
        expected.setRetargetClassName("org.eclipse.core.databinding.UpdateValueStrategy", "POLICY_UPDATE");
        expected.setBaseClassName("org.eclipse.core.databinding.UpdateValueStrategy");
        expected.setConstructorParameters(ArrayUtils.EMPTY_CLASS_ARRAY);
        expected.setEmptyClassErrorMessage("Target strategy class is empty.");
        expected.setErrorMessagePrefix("Target strategy");
        UiConfigurationTest.assertEquals(expected, actual);
        UiConfigurationTest.assertInstanceOf(UpdateStrategyPropertiesUiContentProvider.class, providers.get(1));
        List subProviders = (List)ReflectionUtils.getFieldObject(providers.get(1), (String)"m_providers");
        UiConfigurationTest.assertEquals((int)4, (int)subProviders.size());
        UiConfigurationTest.assertInstanceOf(ValidatorUiContentProvider.class, subProviders.get(0));
        UiConfigurationTest.assertInstanceOf(ValidatorUiContentProvider.class, subProviders.get(1));
        UiConfigurationTest.assertInstanceOf(ValidatorUiContentProvider.class, subProviders.get(2));
        UiConfigurationTest.assertInstanceOf(ConverterUiContentProvider.class, subProviders.get(3));
        ChooseClassConfiguration afterConvertValidatorActual = UiConfigurationTest.getConfiguration(subProviders.get(0));
        ChooseClassConfiguration afterConvertValidatorExpected = new ChooseClassConfiguration();
        afterConvertValidatorExpected.setDialogFieldLabel("AfterConvertValidator:");
        afterConvertValidatorExpected.setValueScope("org.eclipse.core.databinding.validation.IValidator");
        afterConvertValidatorExpected.setClearValue("N/S");
        afterConvertValidatorExpected.setBaseClassName("org.eclipse.core.databinding.validation.IValidator");
        afterConvertValidatorExpected.setConstructorParameters(ArrayUtils.EMPTY_CLASS_ARRAY);
        afterConvertValidatorExpected.setEmptyClassErrorMessage(context.getDirection() + " \"AfterConvertValidator\" class is empty.");
        afterConvertValidatorExpected.setErrorMessagePrefix(context.getDirection() + " \"AfterConvertValidator\"");
        UiConfigurationTest.assertEquals(afterConvertValidatorExpected, afterConvertValidatorActual);
        ChooseClassConfiguration afterGetValidatorActual = UiConfigurationTest.getConfiguration(subProviders.get(1));
        ChooseClassConfiguration afterGetValidatorExpected = new ChooseClassConfiguration();
        afterGetValidatorExpected.setDialogFieldLabel("AfterGetValidator:");
        afterGetValidatorExpected.setValueScope("org.eclipse.core.databinding.validation.IValidator");
        afterGetValidatorExpected.setClearValue("N/S");
        afterGetValidatorExpected.setBaseClassName("org.eclipse.core.databinding.validation.IValidator");
        afterGetValidatorExpected.setConstructorParameters(ArrayUtils.EMPTY_CLASS_ARRAY);
        afterGetValidatorExpected.setEmptyClassErrorMessage(context.getDirection() + " \"AfterGetValidator\" class is empty.");
        afterGetValidatorExpected.setErrorMessagePrefix(context.getDirection() + " \"AfterGetValidator\"");
        UiConfigurationTest.assertEquals(afterGetValidatorExpected, afterGetValidatorActual);
        ChooseClassConfiguration beforeSetValidatorActual = UiConfigurationTest.getConfiguration(subProviders.get(2));
        ChooseClassConfiguration beforeSetValidatorExpected = new ChooseClassConfiguration();
        beforeSetValidatorExpected.setDialogFieldLabel("BeforeSetValidator:");
        beforeSetValidatorExpected.setValueScope("org.eclipse.core.databinding.validation.IValidator");
        beforeSetValidatorExpected.setClearValue("N/S");
        beforeSetValidatorExpected.setBaseClassName("org.eclipse.core.databinding.validation.IValidator");
        beforeSetValidatorExpected.setConstructorParameters(ArrayUtils.EMPTY_CLASS_ARRAY);
        beforeSetValidatorExpected.setEmptyClassErrorMessage(context.getDirection() + " \"BeforeSetValidator\" class is empty.");
        beforeSetValidatorExpected.setErrorMessagePrefix(context.getDirection() + " \"BeforeSetValidator\"");
        UiConfigurationTest.assertEquals(beforeSetValidatorExpected, beforeSetValidatorActual);
        ChooseClassConfiguration converterActual = UiConfigurationTest.getConfiguration(subProviders.get(3));
        ChooseClassConfiguration converterExpected = new ChooseClassConfiguration();
        converterExpected.setDialogFieldLabel("Converter:");
        converterExpected.setValueScope("org.eclipse.core.databinding.conversion.IConverter");
        converterExpected.setClearValue("N/S");
        converterExpected.setBaseClassName("org.eclipse.core.databinding.conversion.IConverter");
        converterExpected.setConstructorParameters(ArrayUtils.EMPTY_CLASS_ARRAY);
        converterExpected.setEmptyClassErrorMessage("Target converter class is empty.");
        converterExpected.setErrorMessagePrefix("Target converter");
        UiConfigurationTest.assertEquals(converterExpected, converterActual);
    }

    @Test
    public void test_BindingInfo() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"import org.eclipse.core.databinding.Binding;", "public class Test {", "  protected Shell m_shell;", "  private DataBindingContext m_bindingContext;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    IObservableValue observeValue = BeanProperties.value(\"name\").observe(getClass());", "    IObservableValue observeWidget = WidgetProperties.text().observe(m_shell);", "    DataBindingContext bindingContext = new DataBindingContext();", "    bindingContext.bindValue(observeWidget, observeValue, null, null);", "    return bindingContext;", "  }", "}"});
        UiConfigurationTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        UiConfigurationTest.assertEquals((int)1, (int)provider.getBindings().size());
        UiConfigurationTest.assertInstanceOf(BindingInfo.class, provider.getBindings().get(0));
        BindingInfo binding = (BindingInfo)provider.getBindings().get(0);
        UiConfigurationTest.assertNotNull((Object)binding.getTargetStrategy());
        IPageListener listener = new IPageListener(){

            public void setTitleImage(Image image) {
            }

            public void setTitle(String title) {
            }

            public void setPageComplete(boolean complete) {
            }

            public void setMessage(String newMessage) {
            }

            public void setErrorMessage(String newMessage) {
            }
        };
        List providers = provider.getContentProviders((IBindingInfo)binding, listener);
        UiConfigurationTest.assertEquals((int)11, (int)providers.size());
        UiConfigurationTest.assertInstanceOf(LabelUiContentProvider.class, providers.get(0));
        UiConfigurationTest.assertEquals((Object)"Target:", (Object)ReflectionUtils.getFieldObject(providers.get(0), (String)"m_title"));
        UiConfigurationTest.assertEquals((Object)"m_shell.text", (Object)ReflectionUtils.getFieldObject(providers.get(0), (String)"m_value"));
        UiConfigurationTest.assertInstanceOf(SwtTextEventsUiContentProvider.class, providers.get(1));
        UiConfigurationTest.assertInstanceOf(SwtDelayUiContentProvider.class, providers.get(2));
        UiConfigurationTest.assertInstanceOf(UpdateStrategyUiContentProvider.class, providers.get(3));
        UiConfigurationTest.assertInstanceOf(ChooseClassConfiguration.class, (Object)ReflectionUtils.getFieldObject(providers.get(3), (String)"m_configuration"));
        ChooseClassConfiguration actualTargetStrategy = UiConfigurationTest.getConfiguration(providers.get(3));
        ChooseClassConfiguration expectedTargetStrategy = new ChooseClassConfiguration();
        expectedTargetStrategy.setDialogFieldLabel("UpdateValueStrategy:");
        expectedTargetStrategy.setDefaultValues(new String[]{"POLICY_UPDATE", "POLICY_NEVER", "POLICY_ON_REQUEST", "POLICY_CONVERT"});
        expectedTargetStrategy.setValueScope("org.eclipse.core.databinding.UpdateValueStrategy");
        expectedTargetStrategy.setRetargetClassName("org.eclipse.core.databinding.UpdateValueStrategy", "POLICY_UPDATE");
        expectedTargetStrategy.setBaseClassName("org.eclipse.core.databinding.UpdateValueStrategy");
        expectedTargetStrategy.setConstructorParameters(ArrayUtils.EMPTY_CLASS_ARRAY);
        expectedTargetStrategy.setEmptyClassErrorMessage("Target strategy class is empty.");
        expectedTargetStrategy.setErrorMessagePrefix("Target strategy");
        UiConfigurationTest.assertEquals(expectedTargetStrategy, actualTargetStrategy);
        UiConfigurationTest.assertInstanceOf(UpdateStrategyPropertiesUiContentProvider.class, providers.get(4));
        List subProvidersTargetStrategy = (List)ReflectionUtils.getFieldObject(providers.get(4), (String)"m_providers");
        UiConfigurationTest.assertEquals((int)4, (int)subProvidersTargetStrategy.size());
        UiConfigurationTest.assertInstanceOf(ValidatorUiContentProvider.class, subProvidersTargetStrategy.get(0));
        UiConfigurationTest.assertInstanceOf(ValidatorUiContentProvider.class, subProvidersTargetStrategy.get(1));
        UiConfigurationTest.assertInstanceOf(ValidatorUiContentProvider.class, subProvidersTargetStrategy.get(2));
        UiConfigurationTest.assertInstanceOf(ConverterUiContentProvider.class, subProvidersTargetStrategy.get(3));
        ChooseClassConfiguration afterConvertValidatorActualTarget = UiConfigurationTest.getConfiguration(subProvidersTargetStrategy.get(0));
        ChooseClassConfiguration afterConvertValidatorExpectedTarget = new ChooseClassConfiguration();
        afterConvertValidatorExpectedTarget.setDialogFieldLabel("AfterConvertValidator:");
        afterConvertValidatorExpectedTarget.setValueScope("org.eclipse.core.databinding.validation.IValidator");
        afterConvertValidatorExpectedTarget.setClearValue("N/S");
        afterConvertValidatorExpectedTarget.setBaseClassName("org.eclipse.core.databinding.validation.IValidator");
        afterConvertValidatorExpectedTarget.setConstructorParameters(ArrayUtils.EMPTY_CLASS_ARRAY);
        afterConvertValidatorExpectedTarget.setEmptyClassErrorMessage("Target \"AfterConvertValidator\" class is empty.");
        afterConvertValidatorExpectedTarget.setErrorMessagePrefix("Target \"AfterConvertValidator\"");
        UiConfigurationTest.assertEquals(afterConvertValidatorExpectedTarget, afterConvertValidatorActualTarget);
        ChooseClassConfiguration afterGetValidatorActualTarget = UiConfigurationTest.getConfiguration(subProvidersTargetStrategy.get(1));
        ChooseClassConfiguration afterGetValidatorExpectedTarget = new ChooseClassConfiguration();
        afterGetValidatorExpectedTarget.setDialogFieldLabel("AfterGetValidator:");
        afterGetValidatorExpectedTarget.setValueScope("org.eclipse.core.databinding.validation.IValidator");
        afterGetValidatorExpectedTarget.setClearValue("N/S");
        afterGetValidatorExpectedTarget.setBaseClassName("org.eclipse.core.databinding.validation.IValidator");
        afterGetValidatorExpectedTarget.setConstructorParameters(ArrayUtils.EMPTY_CLASS_ARRAY);
        afterGetValidatorExpectedTarget.setEmptyClassErrorMessage("Target \"AfterGetValidator\" class is empty.");
        afterGetValidatorExpectedTarget.setErrorMessagePrefix("Target \"AfterGetValidator\"");
        UiConfigurationTest.assertEquals(afterGetValidatorExpectedTarget, afterGetValidatorActualTarget);
        ChooseClassConfiguration beforeSetValidatorActualTarget = UiConfigurationTest.getConfiguration(subProvidersTargetStrategy.get(2));
        ChooseClassConfiguration beforeSetValidatorExpectedTarget = new ChooseClassConfiguration();
        beforeSetValidatorExpectedTarget.setDialogFieldLabel("BeforeSetValidator:");
        beforeSetValidatorExpectedTarget.setValueScope("org.eclipse.core.databinding.validation.IValidator");
        beforeSetValidatorExpectedTarget.setClearValue("N/S");
        beforeSetValidatorExpectedTarget.setBaseClassName("org.eclipse.core.databinding.validation.IValidator");
        beforeSetValidatorExpectedTarget.setConstructorParameters(ArrayUtils.EMPTY_CLASS_ARRAY);
        beforeSetValidatorExpectedTarget.setEmptyClassErrorMessage("Target \"BeforeSetValidator\" class is empty.");
        beforeSetValidatorExpectedTarget.setErrorMessagePrefix("Target \"BeforeSetValidator\"");
        UiConfigurationTest.assertEquals(beforeSetValidatorExpectedTarget, beforeSetValidatorActualTarget);
        ChooseClassConfiguration converterActualTarget = UiConfigurationTest.getConfiguration(subProvidersTargetStrategy.get(3));
        ChooseClassConfiguration converterExpectedTarget = new ChooseClassConfiguration();
        converterExpectedTarget.setDialogFieldLabel("Converter:");
        converterExpectedTarget.setValueScope("org.eclipse.core.databinding.conversion.IConverter");
        converterExpectedTarget.setClearValue("N/S");
        converterExpectedTarget.setBaseClassName("org.eclipse.core.databinding.conversion.IConverter");
        converterExpectedTarget.setConstructorParameters(ArrayUtils.EMPTY_CLASS_ARRAY);
        converterExpectedTarget.setEmptyClassErrorMessage("Target converter class is empty.");
        converterExpectedTarget.setErrorMessagePrefix("Target converter");
        UiConfigurationTest.assertEquals(converterExpectedTarget, converterActualTarget);
        UiConfigurationTest.assertInstanceOf(SeparatorUiContentProvider.class, providers.get(5));
        UiConfigurationTest.assertInstanceOf(LabelUiContentProvider.class, providers.get(6));
        UiConfigurationTest.assertEquals((Object)"Model:", (Object)ReflectionUtils.getFieldObject(providers.get(6), (String)"m_title"));
        UiConfigurationTest.assertEquals((Object)"getClass().name", (Object)ReflectionUtils.getFieldObject(providers.get(6), (String)"m_value"));
        UiConfigurationTest.assertInstanceOf(UpdateStrategyUiContentProvider.class, providers.get(7));
        UiConfigurationTest.assertInstanceOf(ChooseClassConfiguration.class, (Object)ReflectionUtils.getFieldObject(providers.get(7), (String)"m_configuration"));
        ChooseClassConfiguration actualModelStrategy = UiConfigurationTest.getConfiguration(providers.get(7));
        ChooseClassConfiguration expectedModelStrategy = new ChooseClassConfiguration();
        expectedModelStrategy.setDialogFieldLabel("UpdateValueStrategy:");
        expectedModelStrategy.setDefaultValues(new String[]{"POLICY_UPDATE", "POLICY_NEVER", "POLICY_ON_REQUEST", "POLICY_CONVERT"});
        expectedModelStrategy.setValueScope("org.eclipse.core.databinding.UpdateValueStrategy");
        expectedModelStrategy.setRetargetClassName("org.eclipse.core.databinding.UpdateValueStrategy", "POLICY_UPDATE");
        expectedModelStrategy.setBaseClassName("org.eclipse.core.databinding.UpdateValueStrategy");
        expectedModelStrategy.setConstructorParameters(ArrayUtils.EMPTY_CLASS_ARRAY);
        expectedModelStrategy.setEmptyClassErrorMessage("Model strategy class is empty.");
        expectedModelStrategy.setErrorMessagePrefix("Model strategy");
        UiConfigurationTest.assertEquals(expectedModelStrategy, actualModelStrategy);
        UiConfigurationTest.assertInstanceOf(UpdateStrategyPropertiesUiContentProvider.class, providers.get(8));
        List subProvidersModelStrategy = (List)ReflectionUtils.getFieldObject(providers.get(8), (String)"m_providers");
        UiConfigurationTest.assertEquals((int)4, (int)subProvidersModelStrategy.size());
        UiConfigurationTest.assertInstanceOf(ValidatorUiContentProvider.class, subProvidersModelStrategy.get(0));
        UiConfigurationTest.assertInstanceOf(ValidatorUiContentProvider.class, subProvidersModelStrategy.get(1));
        UiConfigurationTest.assertInstanceOf(ValidatorUiContentProvider.class, subProvidersModelStrategy.get(2));
        UiConfigurationTest.assertInstanceOf(ConverterUiContentProvider.class, subProvidersModelStrategy.get(3));
        ChooseClassConfiguration afterConvertValidatorActualModel = UiConfigurationTest.getConfiguration(subProvidersModelStrategy.get(0));
        ChooseClassConfiguration afterConvertValidatorExpectedModel = new ChooseClassConfiguration();
        afterConvertValidatorExpectedModel.setDialogFieldLabel("AfterConvertValidator:");
        afterConvertValidatorExpectedModel.setValueScope("org.eclipse.core.databinding.validation.IValidator");
        afterConvertValidatorExpectedModel.setClearValue("N/S");
        afterConvertValidatorExpectedModel.setBaseClassName("org.eclipse.core.databinding.validation.IValidator");
        afterConvertValidatorExpectedModel.setConstructorParameters(ArrayUtils.EMPTY_CLASS_ARRAY);
        afterConvertValidatorExpectedModel.setEmptyClassErrorMessage("Model \"AfterConvertValidator\" class is empty.");
        afterConvertValidatorExpectedModel.setErrorMessagePrefix("Model \"AfterConvertValidator\"");
        UiConfigurationTest.assertEquals(afterConvertValidatorExpectedModel, afterConvertValidatorActualModel);
        ChooseClassConfiguration afterGetValidatorActualModel = UiConfigurationTest.getConfiguration(subProvidersModelStrategy.get(1));
        ChooseClassConfiguration afterGetValidatorExpectedModel = new ChooseClassConfiguration();
        afterGetValidatorExpectedModel.setDialogFieldLabel("AfterGetValidator:");
        afterGetValidatorExpectedModel.setValueScope("org.eclipse.core.databinding.validation.IValidator");
        afterGetValidatorExpectedModel.setClearValue("N/S");
        afterGetValidatorExpectedModel.setBaseClassName("org.eclipse.core.databinding.validation.IValidator");
        afterGetValidatorExpectedModel.setConstructorParameters(ArrayUtils.EMPTY_CLASS_ARRAY);
        afterGetValidatorExpectedModel.setEmptyClassErrorMessage("Model \"AfterGetValidator\" class is empty.");
        afterGetValidatorExpectedModel.setErrorMessagePrefix("Model \"AfterGetValidator\"");
        UiConfigurationTest.assertEquals(afterGetValidatorExpectedModel, afterGetValidatorActualModel);
        ChooseClassConfiguration beforeSetValidatorActualModel = UiConfigurationTest.getConfiguration(subProvidersModelStrategy.get(2));
        ChooseClassConfiguration beforeSetValidatorExpectedModel = new ChooseClassConfiguration();
        beforeSetValidatorExpectedModel.setDialogFieldLabel("BeforeSetValidator:");
        beforeSetValidatorExpectedModel.setValueScope("org.eclipse.core.databinding.validation.IValidator");
        beforeSetValidatorExpectedModel.setClearValue("N/S");
        beforeSetValidatorExpectedModel.setBaseClassName("org.eclipse.core.databinding.validation.IValidator");
        beforeSetValidatorExpectedModel.setConstructorParameters(ArrayUtils.EMPTY_CLASS_ARRAY);
        beforeSetValidatorExpectedModel.setEmptyClassErrorMessage("Model \"BeforeSetValidator\" class is empty.");
        beforeSetValidatorExpectedModel.setErrorMessagePrefix("Model \"BeforeSetValidator\"");
        UiConfigurationTest.assertEquals(beforeSetValidatorExpectedModel, beforeSetValidatorActualModel);
        ChooseClassConfiguration converterActualModel = UiConfigurationTest.getConfiguration(subProvidersModelStrategy.get(3));
        ChooseClassConfiguration converterExpectedModel = new ChooseClassConfiguration();
        converterExpectedModel.setDialogFieldLabel("Converter:");
        converterExpectedModel.setValueScope("org.eclipse.core.databinding.conversion.IConverter");
        converterExpectedModel.setClearValue("N/S");
        converterExpectedModel.setBaseClassName("org.eclipse.core.databinding.conversion.IConverter");
        converterExpectedModel.setConstructorParameters(ArrayUtils.EMPTY_CLASS_ARRAY);
        converterExpectedModel.setEmptyClassErrorMessage("Model converter class is empty.");
        converterExpectedModel.setErrorMessagePrefix("Model converter");
        UiConfigurationTest.assertEquals(converterExpectedModel, converterActualModel);
        UiConfigurationTest.assertInstanceOf(SeparatorUiContentProvider.class, providers.get(9));
        UiConfigurationTest.assertInstanceOf(BindingContentProvider.class, providers.get(10));
    }

    @Test
    public void test_UpdateListStrategy() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"import org.eclipse.core.databinding.Binding;", "public class Test {", "  protected Shell m_shell;", "  private DataBindingContext m_bindingContext;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    IObservableList observeList1 = BeanProperties.list(\"name\").observe(getClass());", "    IObservableList observeList2 = BeanProperties.list(\"modifiers\").observe(getClass());", "    DataBindingContext bindingContext = new DataBindingContext();", "    bindingContext.bindList(observeList1, observeList2, null, null);", "    return bindingContext;", "  }", "}"});
        UiConfigurationTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        UiConfigurationTest.assertEquals((int)1, (int)provider.getBindings().size());
        UiConfigurationTest.assertInstanceOf(BindingInfo.class, provider.getBindings().get(0));
        BindingInfo binding = (BindingInfo)provider.getBindings().get(0);
        UiConfigurationTest.assertNotNull((Object)binding.getTargetStrategy());
        ArrayList providers = new ArrayList();
        BindingUiContentProviderContext context = new BindingUiContentProviderContext();
        context.setDirection("Target");
        binding.getTargetStrategy().createContentProviders(providers, context);
        UiConfigurationTest.assertEquals((int)2, (int)providers.size());
        UiConfigurationTest.assertInstanceOf(UpdateStrategyUiContentProvider.class, providers.get(0));
        UiConfigurationTest.assertInstanceOf(ChooseClassConfiguration.class, (Object)ReflectionUtils.getFieldObject(providers.get(0), (String)"m_configuration"));
        ChooseClassConfiguration actual = UiConfigurationTest.getConfiguration(providers.get(0));
        ChooseClassConfiguration expected = new ChooseClassConfiguration();
        expected.setDialogFieldLabel("UpdateListStrategy:");
        expected.setDefaultValues(new String[]{"POLICY_UPDATE", "POLICY_NEVER", "POLICY_ON_REQUEST"});
        expected.setValueScope("org.eclipse.core.databinding.UpdateListStrategy");
        expected.setRetargetClassName("org.eclipse.core.databinding.UpdateListStrategy", "POLICY_UPDATE");
        expected.setBaseClassName("org.eclipse.core.databinding.UpdateListStrategy");
        expected.setConstructorParameters(ArrayUtils.EMPTY_CLASS_ARRAY);
        expected.setEmptyClassErrorMessage("Target strategy class is empty.");
        expected.setErrorMessagePrefix("Target strategy");
        UiConfigurationTest.assertEquals(expected, actual);
        UiConfigurationTest.assertInstanceOf(UpdateStrategyPropertiesUiContentProvider.class, providers.get(1));
        List subProviders = (List)ReflectionUtils.getFieldObject(providers.get(1), (String)"m_providers");
        UiConfigurationTest.assertEquals((int)1, (int)subProviders.size());
        UiConfigurationTest.assertInstanceOf(ConverterUiContentProvider.class, subProviders.get(0));
        ChooseClassConfiguration converterActual = UiConfigurationTest.getConfiguration(subProviders.get(0));
        ChooseClassConfiguration converterExpected = new ChooseClassConfiguration();
        converterExpected.setDialogFieldLabel("Converter:");
        converterExpected.setValueScope("org.eclipse.core.databinding.conversion.IConverter");
        converterExpected.setClearValue("N/S");
        converterExpected.setBaseClassName("org.eclipse.core.databinding.conversion.IConverter");
        converterExpected.setConstructorParameters(ArrayUtils.EMPTY_CLASS_ARRAY);
        converterExpected.setEmptyClassErrorMessage("Target converter class is empty.");
        converterExpected.setErrorMessagePrefix("Target converter");
        UiConfigurationTest.assertEquals(converterExpected, converterActual);
    }

    @Test
    public void test_UpdateSetStrategy() throws Exception {
        CompositeInfo shell = DatabindingTestUtils.parseTestSource(this, new String[]{"import org.eclipse.core.databinding.Binding;", "public class Test {", "  protected Shell m_shell;", "  private DataBindingContext m_bindingContext;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "    m_bindingContext = initDataBindings();", "  }", "  private DataBindingContext initDataBindings() {", "    IObservableSet observeSet1 = BeanProperties.set(\"name\").observe(getClass());", "    IObservableSet observeSet2 = BeanProperties.set(\"modifiers\").observe(getClass());", "    DataBindingContext bindingContext = new DataBindingContext();", "    bindingContext.bindSet(observeSet1, observeSet2, null, null);", "    return bindingContext;", "  }", "}"});
        UiConfigurationTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        UiConfigurationTest.assertEquals((int)1, (int)provider.getBindings().size());
        UiConfigurationTest.assertInstanceOf(BindingInfo.class, provider.getBindings().get(0));
        BindingInfo binding = (BindingInfo)provider.getBindings().get(0);
        UiConfigurationTest.assertNotNull((Object)binding.getTargetStrategy());
        ArrayList providers = new ArrayList();
        BindingUiContentProviderContext context = new BindingUiContentProviderContext();
        context.setDirection("Target");
        binding.getTargetStrategy().createContentProviders(providers, context);
        UiConfigurationTest.assertEquals((int)2, (int)providers.size());
        UiConfigurationTest.assertInstanceOf(UpdateStrategyUiContentProvider.class, providers.get(0));
        UiConfigurationTest.assertInstanceOf(ChooseClassConfiguration.class, (Object)ReflectionUtils.getFieldObject(providers.get(0), (String)"m_configuration"));
        ChooseClassConfiguration actual = UiConfigurationTest.getConfiguration(providers.get(0));
        ChooseClassConfiguration expected = new ChooseClassConfiguration();
        expected.setDialogFieldLabel("UpdateSetStrategy:");
        expected.setDefaultValues(new String[]{"POLICY_UPDATE", "POLICY_NEVER", "POLICY_ON_REQUEST"});
        expected.setValueScope("org.eclipse.core.databinding.UpdateSetStrategy");
        expected.setRetargetClassName("org.eclipse.core.databinding.UpdateSetStrategy", "POLICY_UPDATE");
        expected.setBaseClassName("org.eclipse.core.databinding.UpdateSetStrategy");
        expected.setConstructorParameters(ArrayUtils.EMPTY_CLASS_ARRAY);
        expected.setEmptyClassErrorMessage("Target strategy class is empty.");
        expected.setErrorMessagePrefix("Target strategy");
        UiConfigurationTest.assertEquals(expected, actual);
        UiConfigurationTest.assertInstanceOf(UpdateStrategyPropertiesUiContentProvider.class, providers.get(1));
        List subProviders = (List)ReflectionUtils.getFieldObject(providers.get(1), (String)"m_providers");
        UiConfigurationTest.assertEquals((int)1, (int)subProviders.size());
        UiConfigurationTest.assertInstanceOf(ConverterUiContentProvider.class, subProviders.get(0));
        ChooseClassConfiguration converterActual = UiConfigurationTest.getConfiguration(subProviders.get(0));
        ChooseClassConfiguration converterExpected = new ChooseClassConfiguration();
        converterExpected.setDialogFieldLabel("Converter:");
        converterExpected.setValueScope("org.eclipse.core.databinding.conversion.IConverter");
        converterExpected.setClearValue("N/S");
        converterExpected.setBaseClassName("org.eclipse.core.databinding.conversion.IConverter");
        converterExpected.setConstructorParameters(ArrayUtils.EMPTY_CLASS_ARRAY);
        converterExpected.setEmptyClassErrorMessage("Target converter class is empty.");
        converterExpected.setErrorMessagePrefix("Target converter");
        UiConfigurationTest.assertEquals(converterExpected, converterActual);
    }

    private static void assertEquals(ChooseClassConfiguration expected, ChooseClassConfiguration actual) throws Exception {
        UiConfigurationTest.assertEquals((Object)expected.getDialogFieldLabel(), (Object)actual.getDialogFieldLabel());
        UiConfigurationTest.assertEquals((Object)expected.isDialogFieldEnabled(), (Object)actual.isDialogFieldEnabled());
        UiConfigurationTest.assertEquals((Object)expected.isUseClearButton(), (Object)actual.isUseClearButton());
        UiConfigurationTest.assertEquals((Object)expected.getClearValue(), (Object)actual.getClearValue());
        UiConfigurationTest.assertEquals((Object)expected.getValuesScope(), (Object)actual.getValuesScope());
        UiConfigurationTest.assertTrue((boolean)Arrays.equals(expected.getDefaultValues(), actual.getDefaultValues()));
        UiConfigurationTest.assertEquals((Object)Arrays.toString(expected.getBaseClassNames()), (Object)Arrays.toString(actual.getBaseClassNames()));
        UiConfigurationTest.assertEquals((Object)expected.isChooseInterfaces(), (Object)actual.isChooseInterfaces());
        UiConfigurationTest.assertTrue((boolean)Arrays.equals((Object[])expected.getConstructorsParameters(), (Object[])actual.getConstructorsParameters()));
        UiConfigurationTest.assertEquals((Object)expected.getEmptyClassErrorMessage(), (Object)actual.getEmptyClassErrorMessage());
        UiConfigurationTest.assertEquals((Object)expected.getErrorMessagePrefix(), (Object)actual.getErrorMessagePrefix());
        UiConfigurationTest.assertEquals((Object)ReflectionUtils.getFieldObject((Object)expected, (String)"m_defaultStarts"), (Object)ReflectionUtils.getFieldObject((Object)actual, (String)"m_defaultStarts"));
        UiConfigurationTest.assertEquals((Object)ReflectionUtils.getFieldObject((Object)expected, (String)"m_targetClassName"), (Object)ReflectionUtils.getFieldObject((Object)actual, (String)"m_targetClassName"));
        UiConfigurationTest.assertEquals((Object)ReflectionUtils.getFieldObject((Object)expected, (String)"m_retargetClassName"), (Object)ReflectionUtils.getFieldObject((Object)actual, (String)"m_retargetClassName"));
    }

    private static void assertEquals(ChooseClassAndPropertiesConfiguration expected, ChooseClassAndPropertiesConfiguration actual) throws Exception {
        UiConfigurationTest.assertEquals((ChooseClassConfiguration)expected, (ChooseClassConfiguration)actual);
        UiConfigurationTest.assertEquals((Object)expected.getPropertiesLabel(), (Object)actual.getPropertiesLabel());
        UiConfigurationTest.assertEquals((Object)expected.isPropertiesMultiChecked(), (Object)actual.isPropertiesMultiChecked());
        UiConfigurationTest.assertEquals((Object)expected.isReorderMode(), (Object)actual.isReorderMode());
        UiConfigurationTest.assertEquals((Object)expected.getLoadedPropertiesCheckedStrategy(), (Object)actual.getLoadedPropertiesCheckedStrategy());
        UiConfigurationTest.assertEquals((Object)expected.getPropertiesErrorMessage(), (Object)actual.getPropertiesErrorMessage());
        if (expected.getPropertiesLabelProvider() == null) {
            UiConfigurationTest.assertNull((Object)actual.getPropertiesLabelProvider());
        } else {
            UiConfigurationTest.assertNotNull((Object)actual.getPropertiesLabelProvider());
            UiConfigurationTest.assertSame(expected.getPropertiesLabelProvider().getClass(), actual.getPropertiesLabelProvider().getClass());
        }
    }

    private static ChooseClassConfiguration getConfiguration(Object object) {
        return (ChooseClassConfiguration)ReflectionUtils.getFieldObject((Object)object, (String)"m_configuration");
    }
}

