/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.property;

import java.lang.reflect.Array;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swt.model.jface.resource.ColorRegistryInfo;
import org.eclipse.wb.internal.swt.model.jface.resource.KeyFieldInfo;
import org.eclipse.wb.internal.swt.model.jface.resource.RegistryContainerInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ResourceRegistryTest
extends RcpModelTest {
    private int m_initialDisplayRunnables;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.m_initialDisplayRunnables = this.getDisplayRunnablesCount();
    }

    @Override
    protected void tearDown_afterLastModelDispose() throws Exception {
        super.tearDown_afterLastModelDispose();
        ResourceRegistryTest.assertEquals((int)this.m_initialDisplayRunnables, (int)this.getDisplayRunnablesCount());
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_info() throws Exception {
        ResourceRegistryTest.setFileContentSrc("test/IRegistry.java", this.getTestSource("public interface IRegistry {", "  String X_KEY = '_x_key_';", "  StringBuffer SB = new StringBuffer();", "  Object object = new Object();", "}"));
        ResourceRegistryTest.setFileContentSrc("test/AbstractRegistry.java", this.getTestSource("public class AbstractRegistry extends ColorRegistry {", "  public static final String R_KEY = '_r_key_';", "  int XXX = 0;", "  public AbstractRegistry() {", "    put(R_KEY, new RGB(10, 10, 10));", "  }", "}"));
        ResourceRegistryTest.setFileContentSrc("test/MyRegistry.java", this.getTestSource("public class MyRegistry extends AbstractRegistry implements IRegistry {", "  public static final String R2_KEY = '_r2_key_';", "  public static final String R1_KEY = '_r1_key_';", "  static String m_zzz;", "  private static final String AAA = 'BBB';", "  public MyRegistry() {", "    put(R2_KEY, new RGB(10, 10, 10));", "  }", "}"));
        ResourceRegistryTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private MyRegistry registry = new MyRegistry();", "  public Test() {", "    setBackground(registry.get(MyRegistry.R1_KEY));", "  }", "}");
        shell.refresh();
        List children = shell.getChildren(RegistryContainerInfo.class);
        ResourceRegistryTest.assertEquals((int)1, (int)children.size());
        RegistryContainerInfo containerInfo = (RegistryContainerInfo)children.get(0);
        ResourceRegistryTest.assertSame((Object)containerInfo, (Object)RegistryContainerInfo.get((JavaInfo)shell));
        List colors = containerInfo.getChildren(ColorRegistryInfo.class);
        ResourceRegistryTest.assertEquals((int)1, (int)colors.size());
        ColorRegistryInfo colorRegistryInfo = (ColorRegistryInfo)colors.get(0);
        List keyFields = colorRegistryInfo.getKeyFields();
        ResourceRegistryTest.assertEquals((int)4, (int)keyFields.size());
        ResourceRegistryTest.assertRegistryKey("R1_KEY", "test.MyRegistry.R1_KEY", "_r1_key_", (KeyFieldInfo)keyFields.get(0));
        ResourceRegistryTest.assertRegistryKey("R2_KEY", "test.MyRegistry.R2_KEY", "_r2_key_", (KeyFieldInfo)keyFields.get(1));
        ResourceRegistryTest.assertRegistryKey("R_KEY", "test.AbstractRegistry.R_KEY", "_r_key_", (KeyFieldInfo)keyFields.get(2));
        ResourceRegistryTest.assertRegistryKey("X_KEY", "test.IRegistry.X_KEY", "_x_key_", (KeyFieldInfo)keyFields.get(3));
    }

    private static void assertRegistryKey(String keyName, String keyAccessSource, String keyValue, KeyFieldInfo info) throws Exception {
        ResourceRegistryTest.assertEquals((Object)keyName, (Object)info.keyName);
        ResourceRegistryTest.assertEquals((Object)keyAccessSource, (Object)info.keySource);
        ResourceRegistryTest.assertEquals((Object)keyValue, (Object)info.keyValue);
        ResourceRegistryTest.assertNull((Object)info.value);
    }

    private int getDisplayRunnablesCount() throws Exception {
        int runnableCount = 0;
        Object disposeList = ReflectionUtils.getFieldObject((Object)Display.getDefault(), (String)"disposeList");
        if (disposeList != null) {
            int length = Array.getLength(disposeList);
            int i = 0;
            while (i < length) {
                Object runnable = Array.get(disposeList, i);
                if (runnable != null) {
                    ++runnableCount;
                }
                ++i;
            }
        }
        return runnableCount;
    }
}

