/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.swtbot.designer.bot;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.wb.tests.designer.core.TestProject;
import org.eclipse.wb.tests.swtbot.designer.bot.UIUtil;
import org.eclipse.wb.tests.swtbot.designer.bot.WindowBuilderProjectExplorerBot;

public class WindowBuilderWorkbenchBot
extends SWTWorkbenchBot {
    private static final String TEST_PROJECT_NAME = "TestProject";
    private static final Logger LOGGER = Logger.getLogger(WindowBuilderWorkbenchBot.class.getSimpleName());
    private TestProject testProject = new TestProject(this.createProject());
    private List<IFile> createdFiles = new ArrayList<IFile>();
    private boolean init;

    public WindowBuilderWorkbenchBot() {
        if (!this.init) {
            this.init = true;
            UIUtil.syncExec(() -> {
                IWorkbench wb = PlatformUI.getWorkbench();
                IIntroManager im = wb.getIntroManager();
                IIntroPart intro = wb.getIntroManager().getIntro();
                if (intro != null) {
                    im.closeIntro(intro);
                }
                IWorkbenchWindow ww = wb.getActiveWorkbenchWindow();
                wb.getPerspectiveRegistry().setDefaultPerspective("org.eclipse.ui.resourcePerspective");
                wb.showPerspective("org.eclipse.ui.resourcePerspective", ww);
            });
        }
    }

    private IProject createProject() {
        IProject project = WindowBuilderWorkbenchBot.getTestProject();
        if (project.exists()) {
            return project;
        }
        SWTBot wizard = this.openNewWizard().bot();
        wizard.tree().expandNode(new String[]{"WindowBuilder", "SWT Designer", "SWT/JFace Java Project"}).click();
        wizard.button("Next >").click();
        wizard.text().setText(TEST_PROJECT_NAME);
        wizard.checkBox("Create module-info.java file").deselect();
        wizard.button("Next >").click();
        wizard.button("Finish").click();
        this.waitWhile(Conditions.shellIsActive((String)"New SWT/JFace Java Project"));
        return WindowBuilderWorkbenchBot.getTestProject();
    }

    private static IProject getTestProject() {
        return (IProject)UIUtil.syncCall(() -> ResourcesPlugin.getWorkspace().getRoot().getProject(TEST_PROJECT_NAME));
    }

    public void resetWorkbench() {
        Iterator<IFile> iterator = this.createdFiles.iterator();
        while (iterator.hasNext()) {
            UIUtil.syncExec(() -> ((IFile)iterator.next()).delete(true, null));
            iterator.remove();
        }
        super.resetWorkbench();
    }

    public WindowBuilderProjectExplorerBot getProjectExplorer() {
        LOGGER.fine("Open Project Explorer");
        SWTBotView projectExplorer = this.viewByPartName("Project Explorer");
        LOGGER.fine("Opened Project Explorer");
        return new WindowBuilderProjectExplorerBot(projectExplorer.getViewReference(), this);
    }

    public SWTBotShell openNewWizard() {
        LOGGER.fine("Open New wizard");
        this.shell().menu().menu(new String[]{"File"}).menu(new String[]{"New", "Other..."}).click();
        LOGGER.fine("Opened New wizard");
        return this.activeShell();
    }

    private IFile getFile(String packageName, String fileName) {
        return (IFile)UIUtil.syncCall(() -> {
            IFolder packageFolder = (IFolder)this.testProject.getPackage(packageName).getResource();
            return packageFolder.getFile(fileName);
        });
    }

    public void addFile(String fileName) {
        this.addFile("", fileName);
    }

    public void addFile(String packageName, String fileName) {
        IFile sourceFile = this.getFile(packageName, fileName);
        this.createdFiles.add(sourceFile);
    }

    public void setFileContent(String fileName, String content) {
        this.setFileContent("", fileName, content);
    }

    public void setFileContent(String packageName, String fileName, String content) {
        UIUtil.syncExec(() -> {
            Throwable throwable = null;
            Object var5_6 = null;
            try (ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));){
                IFile sourceFile = this.getFile(packageName, fileName);
                sourceFile.setContents((InputStream)is, true, false, null);
                this.createdFiles.add(sourceFile);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        });
    }

    public String getFileContent(String fileName) {
        return this.getFileContent("", fileName);
    }

    public String getFileContent(String packageName, String fileName) {
        return (String)UIUtil.syncCall(() -> {
            IFile sourceFile = this.getFile(packageName, fileName);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Throwable throwable = null;
            Object var6_7 = null;
            try (InputStream is = sourceFile.getContents();){
                is.transferTo(os);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return new String(os.toByteArray(), StandardCharsets.UTF_8);
        });
    }
}

