#!/usr/bin/env python
from sys import path
path.insert(0, '..')

from reportlab.lib.styles import ParagraphStyle
from reportlab.lib.enums import TA_JUSTIFY

from stoqlib.reporting import ReportTemplate, build_report, print_preview
from stoqlib.reporting.default_style import STYLE_SHEET

class ContractExample(ReportTemplate):
    def __init__(self, filename):
        ReportTemplate.__init__(self, filename, "", do_footer=0, topMargin=0,
                                bottomMargin=0)
        self.add_title("Termo de Compromisso de Estgio")
        self.add_info_table()
        self.add_blank_space(10)
        self.add_contract_body()

    def create_extra_styles(self):
        styles = [ParagraphStyle("JustifyParagraph",
                                 fontName="Helvetica",
                                 fontSize=10,
                                 leading=11,
                                 alignment=TA_JUSTIFY,
                                 spaceAfter=6)]
        for style in styles:
            STYLE_SHEET.add(style)
    
    def add_info_table(self):
        rows = [["Concedente:", ""],
                ["Endereo:", ""],
                ["Estagirio:", ""],
                ["Instituio de Ensino:", ""],
                ["Endereo:", ""],
                ["Nvel:", ""],
                ["Curso:", ""]]
        self.add_data_table(rows)

    def add_contract_body(self):
        contract_body = [
            ("As Partes acima justificadas assinam o presente Termo de "
             "Compromisso regido pelas condies estabelecidas no "
             "Instrumento Jurdico celebrado com a Instituio de Ensino e "
             "mediante as seguintes condies:"),
            ("1- O propsito do presente estgio  propiciar ao estagirio(a) "
             "treinamento prtico, aperfeioamento tcnico, cultural, "
             "cientfico e de relacionamento humano, como complementao do "
             "ensino ou aprendizagem a serem planejadas de conformidade com "
             "os programas e calendrios escolares."),
            ("2 - A jornada de atividade do(a) estagirio(a), compatveis "
             "com o seu horrio escolar e com o horrio da CONCEDENTE, Ter "
             "uma carga de _______ horas semanais. O termo de compromisso "
             "ter incio em ____________________ e trmino em "
             "____________________, podendo ser interrompido a qualquer "
             "momento, unilateralmente, mediante comunicao escrita. Nos "
             "perodos de frias escolares, a jornada de estgio ser "
             "estabelecida de comum acordo entre o(a) estagirio(a) e a "
             "CONCEDENTE, com o conhecimento da Instituio de Ensino "
             "envolvida."),
            ("3 - Fica estabelecida a Bolsa de Estgio de R$ ________,00 por "
             "ms."),
            ("4 - O presente estgio no cria vnculo empregatcio de qualquer "
             "natureza nos termos de legislao aplicvel em vigor. Na "
             "vigncia deste compromisso, o(a) estagirio(a) compromete-se a "
             "observar as normas de segurana bem como as instrues "
             "aplicveis a terceiros."),
            ("A CONCEDENTE incluir o(a) estagirio(a), em uma aplice de "
             "seguros de acidentes pessoais. Se solicitado pela Instituio de "
             "Ensino do(a) estagirio(a), a CONCEDENTE expedir uma Declarao"
             "de Estgio."),
            ("5 - O(a) estagirio(a) dever informar de imediato e por "
             "escrito  CONCEDENTE, qualquer fato que interrompa, suspenda ou "
             "cancele sua matrcula na Instituio de Ensino interveniente, "
             "ficando ele responsvel de quaisquer despesas causadas pela "
             "ausncia dessa informao."),
            ("6 - E por estarem de comum acordo com as condies acima, "
             "firmam o presente compromisso em trs vias de igual teor.")]

        self.create_extra_styles()
        map(lambda t: self.add_paragraph(t, style="JustifyParagraph"),
            contract_body)
        self.add_blank_space(20)
        self.add_paragraph("Data:", style="JustifyParagraph")
        self.add_blank_space(10)
        self.add_paragraph("Testemunhas:", style="JustifyParagraph")

        self.add_signatures(["Assinatura do(a) Estagirio(a)",
                             "Responsvel Legal"], height=20)
        self.add_signatures(["Responsvel Legal", "Instituio de Ensino"])

filename = build_report(ContractExample)
print_preview(filename)

